/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BufferOverflowException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class CircularCharBuffer {
    private static final int DEFAULT_SIZE = 1024;
    public static final int INFINITE_SIZE = -1;
    protected char[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected volatile int markPosition = 0;
    protected volatile int markSize = 0;
    protected volatile boolean infinite = false;
    protected boolean blockingWrite = true;
    protected Reader reader = new CircularCharBufferReader();
    protected boolean readerClosed = false;
    protected Writer writer = new CircularCharBufferWriter();
    protected boolean writerClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.markPosition = 0;
            this.readerClosed = false;
            this.writerClosed = false;
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceLeft() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.spaceLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.buffer.length;
        }
    }

    private void resize() {
        char[] newBuffer = new char[this.buffer.length * 2];
        int marked = this.marked();
        int available = this.available();
        if (this.markPosition <= this.writePosition) {
            int length = this.writePosition - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length);
        } else {
            int length1 = this.buffer.length - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length1);
            int length2 = this.writePosition;
            System.arraycopy(this.buffer, 0, newBuffer, length1, length2);
        }
        this.buffer = newBuffer;
        this.markPosition = 0;
        this.readPosition = marked;
        this.writePosition = marked + available;
    }

    private int spaceLeft() {
        if (this.writePosition < this.markPosition) {
            return this.markPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.markPosition);
    }

    private int available() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    private int marked() {
        if (this.markPosition <= this.readPosition) {
            return this.readPosition - this.markPosition;
        }
        return this.buffer.length - (this.markPosition - this.readPosition);
    }

    private void ensureMark() {
        if (this.marked() > this.markSize) {
            this.markPosition = this.readPosition;
            this.markSize = 0;
        }
    }

    public CircularCharBuffer() {
        this(1024, true);
    }

    public CircularCharBuffer(int size) {
        this(size, true);
    }

    public CircularCharBuffer(boolean blockingWrite) {
        this(1024, blockingWrite);
    }

    public CircularCharBuffer(int size, boolean blockingWrite) {
        if (size == -1) {
            this.buffer = new char[1024];
            this.infinite = true;
        } else {
            this.buffer = new char[size];
            this.infinite = false;
        }
        this.blockingWrite = blockingWrite;
    }

    protected class CircularCharBufferWriter
    extends Writer {
        protected CircularCharBufferWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (!CircularCharBuffer.this.writerClosed) {
                    this.flush();
                }
                CircularCharBuffer.this.writerClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.writerClosed) {
                    throw new IOException("Writer has been closed; cannot flush a closed Writer.");
                }
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("Buffer closed by Reader; cannot flush.");
                }
            }
        }

        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len > 0) {
                int written;
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this.spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < len) {
                        CircularCharBuffer.this.resize();
                        spaceLeft = CircularCharBuffer.this.spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < len) {
                        throw new BufferOverflowException("CircularCharBuffer is full; cannot write " + len + " characters");
                    }
                    int realLen = Math.min(len, spaceLeft);
                    int firstLen = Math.min(realLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.writePosition);
                    int secondLen = Math.min(realLen - firstLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.markPosition - 1);
                    written = firstLen + secondLen;
                    if (firstLen > 0) {
                        System.arraycopy(cbuf, off, CircularCharBuffer.this.buffer, CircularCharBuffer.this.writePosition, firstLen);
                    }
                    if (secondLen > 0) {
                        System.arraycopy(cbuf, off + firstLen, CircularCharBuffer.this.buffer, 0, secondLen);
                        CircularCharBuffer.this.writePosition = secondLen;
                    } else {
                        CircularCharBuffer.this.writePosition += written;
                    }
                    if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                        CircularCharBuffer.this.writePosition = 0;
                    }
                    off += written;
                }
                if ((len -= written) <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Waiting for available space in buffer interrupted.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int c) throws IOException {
            boolean written = false;
            while (!written) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this.spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < 1) {
                        CircularCharBuffer.this.resize();
                        spaceLeft = CircularCharBuffer.this.spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < 1) {
                        throw new BufferOverflowException("CircularCharBuffer is full; cannot write 1 character");
                    }
                    if (spaceLeft > 0) {
                        CircularCharBuffer.this.buffer[CircularCharBuffer.this.writePosition] = (char)(c & 0xFFFF);
                        ++CircularCharBuffer.this.writePosition;
                        if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.writePosition = 0;
                        }
                        written = true;
                    }
                }
                if (written) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Waiting for available space in buffer interrupted.");
                }
            }
        }

        public void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String str, int off, int len) throws IOException {
            while (len > 0) {
                int written;
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    int i;
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this.spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < len) {
                        CircularCharBuffer.this.resize();
                        spaceLeft = CircularCharBuffer.this.spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < len) {
                        throw new BufferOverflowException("CircularCharBuffer is full; cannot write " + len + " characters");
                    }
                    int realLen = Math.min(len, spaceLeft);
                    int firstLen = Math.min(realLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.writePosition);
                    int secondLen = Math.min(realLen - firstLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.markPosition - 1);
                    written = firstLen + secondLen;
                    for (i = 0; i < firstLen; ++i) {
                        CircularCharBuffer.this.buffer[CircularCharBuffer.this.writePosition + i] = str.charAt(off + i);
                    }
                    if (secondLen > 0) {
                        for (i = 0; i < secondLen; ++i) {
                            CircularCharBuffer.this.buffer[i] = str.charAt(off + firstLen + i);
                        }
                        CircularCharBuffer.this.writePosition = secondLen;
                    } else {
                        CircularCharBuffer.this.writePosition += written;
                    }
                    if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                        CircularCharBuffer.this.writePosition = 0;
                    }
                    off += written;
                }
                if ((len -= written) <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Waiting for available space in buffer interrupted.");
                }
            }
        }
    }

    protected class CircularCharBufferReader
    extends Reader {
        protected CircularCharBufferReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                CircularCharBuffer.this.readerClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mark(int readAheadLimit) throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("Reader has been closed; cannot mark a closed Reader.");
                }
                if (CircularCharBuffer.this.buffer.length - 1 <= readAheadLimit) {
                    throw new IOException("Cannot mark stream, readAheadLimit bigger than buffer size.");
                }
                CircularCharBuffer.this.markSize = readAheadLimit;
                CircularCharBuffer.this.markPosition = CircularCharBuffer.this.readPosition;
            }
        }

        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Reader has been closed; cannot read from a closed Reader.");
                    }
                    int available = CircularCharBuffer.this.available();
                    if (available > 0) {
                        int result = CircularCharBuffer.this.buffer[CircularCharBuffer.this.readPosition] & 0xFFFF;
                        ++CircularCharBuffer.this.readPosition;
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this.ensureMark();
                        return result;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return -1;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cbuf, int off, int len) throws IOException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Reader has been closed; cannot read from a closed Reader.");
                    }
                    int available = CircularCharBuffer.this.available();
                    if (available > 0) {
                        int length = Math.min(len, available);
                        int firstLen = Math.min(length, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.readPosition);
                        int secondLen = length - firstLen;
                        System.arraycopy(CircularCharBuffer.this.buffer, CircularCharBuffer.this.readPosition, cbuf, off, firstLen);
                        if (secondLen > 0) {
                            System.arraycopy(CircularCharBuffer.this.buffer, 0, cbuf, off + firstLen, secondLen);
                            CircularCharBuffer.this.readPosition = secondLen;
                        } else {
                            CircularCharBuffer.this.readPosition += length;
                        }
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this.ensureMark();
                        return length;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return -1;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("Reader has been closed, it is not ready.");
                }
                return CircularCharBuffer.this.available() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("Reader has been closed; cannot reset a closed Reader.");
                }
                CircularCharBuffer.this.readPosition = CircularCharBuffer.this.markPosition;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long n) throws IOException, IllegalArgumentException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("Reader has been closed; cannot skip characters on a closed Reader.");
                    }
                    int available = CircularCharBuffer.this.available();
                    if (available > 0) {
                        int firstLen;
                        int length = Math.min((int)n, available);
                        int secondLen = length - (firstLen = Math.min(length, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.readPosition));
                        CircularCharBuffer.this.readPosition = secondLen > 0 ? secondLen : (CircularCharBuffer.this.readPosition += length);
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this.ensureMark();
                        return length;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return 0L;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }
    }
}

