/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CmdLnOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLnResult {
    private CmdLnOption option;
    private ArrayList<String> arguments;

    CmdLnResult(CmdLnOption option) {
        this.option = option;
    }

    public CmdLnOption getOption() {
        return this.option;
    }

    void addArgument(String argument) {
        if (this.hasAllArguments()) {
            throw new IllegalStateException("Too many arguments to option");
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList(Math.min(this.option.getMaxArguments(), 16));
        }
        this.arguments.add(argument);
    }

    boolean hasAllArguments() {
        return this.getArgumentCount() >= this.option.getMaxArguments();
    }

    boolean requiresMoreArguments() {
        return this.getArgumentCount() < this.option.getMinArguments();
    }

    public int getArgumentCount() {
        if (this.arguments == null) {
            return 0;
        }
        return this.arguments.size();
    }

    public List<String> getArguments() {
        if (this.getArgumentCount() == 0) {
            return null;
        }
        return Collections.unmodifiableList(this.arguments);
    }

    public String getArgument() {
        if (this.getArgumentCount() == 0) {
            return null;
        }
        return this.arguments.get(0);
    }
}

