/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.DateTimeLexer;
import com.Ostermiller.util.DateTimeToken;
import com.Ostermiller.util.StringHelper;
import com.Ostermiller.util.UberProperties;
import com.Ostermiller.util.YearExtensionAround;
import com.Ostermiller.util.YearExtensionPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeParse {
    private Field[] fieldOrder = null;
    private Map<String, Integer> monthWords = new HashMap<String, Integer>();
    private Map<String, Integer> eraWords = new HashMap<String, Integer>();
    private Set<String> weekdayWords = new HashSet<String>();
    private Map<String, Integer> ordinalWords = new HashMap<String, Integer>();
    private Map<String, Integer> ampmWords = new HashMap<String, Integer>();
    private static final String[] ALL_PROPERTIES = new String[]{"", "da", "de", "en", "es", "fr", "it", "nl", "pl", "pt", "ro", "ru", "sv", "tr"};
    private YearExtensionPolicy yearExtensionPolicy = YearExtensionAround.NEAREST;
    private int defaultYear = Calendar.getInstance().get(1);
    private TimeZone defaultZone = TimeZone.getDefault();
    private static final int ZONE_STATE_INIT = 0;
    private static final int ZONE_STATE_PLUS_MINUS = 1;
    private static final int ZONE_STATE_HOUR = 2;
    private static final int ZONE_STATE_HOUR_SEP = 3;
    private static final int ZONE_STATE_DONE = 4;
    private static final int TIME_STATE_INIT = 0;
    private static final int TIME_STATE_HOUR = 1;
    private static final int TIME_STATE_HOUR_SEP = 2;
    private static final int TIME_STATE_MINUTE = 3;
    private static final int TIME_STATE_MINUTE_SEP = 4;
    private static final int TIME_STATE_SECOND = 5;
    private static final int TIME_STATE_DONE = 6;

    public DateTimeParse() {
        this(Locale.getDefault());
    }

    public DateTimeParse(Locale locale) {
        this.loadResources(locale);
    }

    public void setFieldOrder(List<Field> fieldOrder) {
        this.setFieldOrder(fieldOrder.toArray(new Field[0]));
    }

    public void setFieldOrder(Field[] fieldOrder) {
        this.fieldOrder = DateTimeParse.copyAndVerify(fieldOrder);
    }

    public List<Field> getFieldOrder() {
        ArrayList<Field> l = new ArrayList<Field>();
        for (Field f : this.fieldOrder) {
            l.add(f);
        }
        return l;
    }

    private static Field[] copyAndVerify(Field[] fieldOrder) {
        boolean y = false;
        boolean m = false;
        boolean d = false;
        Field[] result = new Field[3];
        int i = 0;
        block5: for (Field f : fieldOrder) {
            switch (f) {
                case YEAR: {
                    if (y) continue block5;
                    y = true;
                    result[i] = f;
                    ++i;
                    continue block5;
                }
                case MONTH: {
                    if (m) continue block5;
                    m = true;
                    result[i] = f;
                    ++i;
                    continue block5;
                }
                case DAY: {
                    if (d) continue block5;
                    d = true;
                    result[i] = f;
                    ++i;
                }
            }
        }
        for (int j = i; j < 3; ++j) {
            if (!y) {
                y = true;
                result[j] = Field.YEAR;
                continue;
            }
            if (!m) {
                m = true;
                result[j] = Field.MONTH;
                continue;
            }
            if (d) continue;
            d = true;
            result[j] = Field.DAY;
        }
        return result;
    }

    private static List<Field> getFieldOrder(String s) {
        ArrayList<Field> l = new ArrayList<Field>();
        for (String name : s.split("[^A-Za-z]+")) {
            if (name.length() <= 0) continue;
            Field field = Field.valueOf(name.toUpperCase());
            l.add(field);
        }
        return l;
    }

    private void loadResources(Locale locale) {
        HashSet<String> allKeys = new HashSet<String>();
        if (locale != null && locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            String langProp = locale.getLanguage();
            if (locale.getCountry() != null && locale.getCountry().length() > 0) {
                String countryProp = langProp + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    String variantProp = countryProp + "_" + locale.getVariant();
                    this.loadProperties(allKeys, variantProp);
                }
                this.loadProperties(allKeys, countryProp);
            }
            this.loadProperties(allKeys, langProp);
        }
        for (String propertyName : ALL_PROPERTIES) {
            this.loadProperties(allKeys, propertyName);
        }
    }

    private void loadProperties(Set<String> allKeys, String propertiesLocale) {
        try {
            InputStream in;
            if (!"".equals(propertiesLocale)) {
                propertiesLocale = "_" + propertiesLocale;
            }
            if ((in = this.getClass().getResourceAsStream("DateTimeParse" + propertiesLocale + ".properties")) != null) {
                UberProperties prop = new UberProperties();
                prop.load(new InputStreamReader(in, "UTF-8"));
                DateTimeParse.addStringInts(allKeys, this.ordinalWords, prop.getProperty("ordinalWords"));
                DateTimeParse.addStringInts(allKeys, this.ampmWords, prop.getProperty("ampmWords"));
                DateTimeParse.addStrings(allKeys, this.weekdayWords, prop.getProperty("weekdayWords"));
                DateTimeParse.addStringInts(allKeys, this.eraWords, prop.getProperty("eraWords"));
                DateTimeParse.addStringInts(allKeys, this.monthWords, prop.getProperty("monthWords"));
                if (this.fieldOrder == null && prop.getProperty("fieldOrder") != null) {
                    this.setFieldOrder(DateTimeParse.getFieldOrder(prop.getProperty("fieldOrder")));
                }
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    private static void addStringInts(Set<String> allKeys, Map<String, Integer> addTo, String s) {
        if (s == null) {
            return;
        }
        for (String pair : s.split("\\,")) {
            String value;
            int sep = pair.lastIndexOf(">");
            String key = pair.substring(0, sep).trim().toLowerCase();
            if (allKeys.contains(key) || key.equals(value = pair.substring(sep + 1).trim())) continue;
            allKeys.add(key);
            addTo.put(key, Integer.valueOf(value));
        }
    }

    private static void addStrings(Set<String> allKeys, Set<String> addTo, String s) {
        if (s == null) {
            return;
        }
        for (String key : s.split("\\,")) {
            if (allKeys.contains(key = key.trim().toLowerCase())) continue;
            allKeys.add(key);
            addTo.add(key);
        }
    }

    public void setDefaultYear(int defaultYear) {
        this.defaultYear = defaultYear;
    }

    public DateTimeParse setYearExtensionPolicy(YearExtensionPolicy yearExtensionPolicy) {
        this.yearExtensionPolicy = yearExtensionPolicy;
        return this;
    }

    private LinkedList<DateTimeToken> getTokens(String dateString) throws IOException {
        DateTimeToken token;
        DateTimeLexer lex = new DateTimeLexer(new StringReader(dateString));
        LinkedList<DateTimeToken> l = new LinkedList<DateTimeToken>();
        while ((token = lex.getNextToken()) != null) {
            switch (token.getType()) {
                case ERROR: {
                    return null;
                }
            }
            l.add(token);
        }
        return l;
    }

    public Date parse(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            LinkedList<DateTimeToken> tokens = this.getTokens(dateString);
            if (tokens == null || tokens.size() == 0) {
                return null;
            }
            WorkingDateTime work = new WorkingDateTime();
            if (!this.setTime(work, tokens)) {
                return null;
            }
            if (!this.setZone(work, tokens)) {
                work.setZone(this.defaultZone);
            }
            if (!this.setObviousDateFields(work, tokens)) {
                return null;
            }
            if (!this.setPreferredDateNumberFields(work, tokens)) {
                return null;
            }
            if (!this.containsOnlySpacesAndPunctuation(tokens)) {
                return null;
            }
            return work.getDate();
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return null;
        }
    }

    public DateTimeParse setTimeZone(TimeZone zone) {
        this.defaultZone = zone;
        return this;
    }

    private boolean setZone(WorkingDateTime work, LinkedList<DateTimeToken> tokens) {
        int start = 0;
        int end = 0;
        int hour = -1;
        int minute = -1;
        boolean plusMinus = true;
        int state = 0;
        int position = 0;
        Iterator i = tokens.iterator();
        while (i.hasNext() && state != 4) {
            DateTimeToken token = (DateTimeToken)i.next();
            block1 : switch (token.getType()) {
                case NUMBER: {
                    switch (state) {
                        case 1: {
                            String tokenText = token.getText();
                            if (tokenText.length() == 4) {
                                String hourPart = tokenText.substring(0, 2);
                                String minutePart = tokenText.substring(2, 4);
                                try {
                                    int hours = Integer.parseInt(hourPart);
                                    int minutes = Integer.parseInt(minutePart);
                                    if (hours <= 24 && minutes <= 60) {
                                        hour = hours;
                                        minute = minutes;
                                        end = position;
                                        state = 4;
                                        break block1;
                                    }
                                    start = 0;
                                    end = 0;
                                    hour = -1;
                                    minute = -1;
                                    plusMinus = true;
                                    state = 0;
                                }
                                catch (NumberFormatException nfx) {
                                    start = 0;
                                    end = 0;
                                    hour = -1;
                                    minute = -1;
                                    plusMinus = true;
                                    state = 0;
                                }
                                break block1;
                            }
                            if (token.getValue() <= 24) {
                                hour = token.getValue();
                                state = 2;
                                break block1;
                            }
                            start = 0;
                            end = 0;
                            hour = -1;
                            minute = -1;
                            plusMinus = true;
                            state = 0;
                            break block1;
                        }
                        case 3: {
                            if (token.getValue() <= 60) {
                                minute = token.getValue();
                                end = position;
                                state = 4;
                                break block1;
                            }
                            start = 0;
                            end = 0;
                            hour = -1;
                            minute = -1;
                            plusMinus = true;
                            state = 0;
                            break block1;
                        }
                    }
                    start = 0;
                    end = 0;
                    hour = -1;
                    minute = -1;
                    plusMinus = true;
                    state = 0;
                    break;
                }
                case PUNCTUATION: {
                    switch (state) {
                        case 0: {
                            if ("+".equals(token.getText())) {
                                start = position;
                                plusMinus = true;
                                state = 1;
                                break;
                            }
                            if (!"-".equals(token.getText())) break block1;
                            start = position;
                            plusMinus = false;
                            state = 1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (":".equals(token.getText())) {
                                state = 3;
                                break;
                            }
                            start = 0;
                            end = 0;
                            hour = -1;
                            minute = -1;
                            plusMinus = true;
                            state = 0;
                            break;
                        }
                        default: {
                            start = 0;
                            end = 0;
                            hour = -1;
                            minute = -1;
                            plusMinus = true;
                            state = 0;
                            break;
                        }
                    }
                    break;
                }
                case SPACE: {
                    switch (state) {
                        case 1: {
                            break block1;
                        }
                        case 2: 
                        case 3: {
                            state = 3;
                            break block1;
                        }
                    }
                    start = 0;
                    end = 0;
                    hour = -1;
                    minute = -1;
                    plusMinus = true;
                    state = 0;
                    break;
                }
                default: {
                    start = 0;
                    end = 0;
                    hour = -1;
                    minute = -1;
                    plusMinus = true;
                    state = 0;
                }
            }
            ++position;
        }
        if (state == 4) {
            String zoneOffset = (plusMinus ? "+" : "-") + StringHelper.prepad(hour, 2) + ":" + StringHelper.prepad(minute, 2);
            TimeZone zone = TimeZone.getTimeZone("GMT" + zoneOffset);
            work.setZone(zone);
            int position2 = 0;
            Iterator i2 = tokens.iterator();
            while (i2.hasNext()) {
                i2.next();
                if (position2 >= start && position2 <= end) {
                    i2.remove();
                }
                ++position2;
            }
            return true;
        }
        return false;
    }

    private boolean setTime(WorkingDateTime work, LinkedList<DateTimeToken> tokens) {
        int start = 0;
        int end = 0;
        int state = 0;
        int hour = -1;
        int position = 0;
        Iterator i = tokens.iterator();
        while (i.hasNext() && state != 6) {
            DateTimeToken token = (DateTimeToken)i.next();
            block0 : switch (token.getType()) {
                case NUMBER: {
                    switch (state) {
                        case 0: 
                        case 1: {
                            if (token.getValue() > 24) break block0;
                            start = position;
                            hour = token.getValue();
                            state = 1;
                            break;
                        }
                        case 2: {
                            if (token.getValue() <= 60) {
                                work.setHour(hour);
                                work.minute = token.getValue();
                                state = 3;
                                break;
                            }
                            return false;
                        }
                        case 4: {
                            if (token.getValue() <= 60) {
                                work.second = token.getValue();
                                state = 5;
                                break;
                            }
                            return false;
                        }
                        default: {
                            end = position;
                            state = 6;
                            break;
                        }
                    }
                    break;
                }
                case PUNCTUATION: {
                    switch (state) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (":".equals(token.getText())) {
                                state = 2;
                                break block0;
                            }
                            start = 0;
                            end = 0;
                            hour = -1;
                            state = 0;
                            break block0;
                        }
                        case 2: {
                            start = 0;
                            end = 0;
                            hour = -1;
                            state = 0;
                            break block0;
                        }
                        case 3: {
                            if (":".equals(token.getText())) {
                                state = 4;
                                break block0;
                            }
                            end = position;
                            state = 6;
                            break block0;
                        }
                    }
                    end = position;
                    state = 6;
                    break;
                }
                case SPACE: {
                    break;
                }
                default: {
                    switch (state) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            start = 0;
                            end = 0;
                            hour = -1;
                            state = 0;
                            break block0;
                        }
                    }
                    end = position;
                    state = 6;
                }
            }
            ++position;
        }
        if (!i.hasNext()) {
            switch (state) {
                case 2: 
                case 4: {
                    return false;
                }
                case 3: 
                case 5: {
                    end = tokens.size();
                    state = 6;
                }
            }
        }
        if (state == 6) {
            int position2 = 0;
            Iterator i2 = tokens.iterator();
            while (i2.hasNext()) {
                i2.next();
                if (position2 >= start && position2 < end) {
                    i2.remove();
                }
                ++position2;
            }
        }
        return true;
    }

    private boolean setPreferredDateNumberFields(WorkingDateTime work, LinkedList<DateTimeToken> tokens) {
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            DateTimeToken token = (DateTimeToken)i.next();
            if (token.getType() == DateTimeToken.DateTimeTokenType.NUMBER && !work.setPreferredField(token)) {
                return false;
            }
            i.remove();
        }
        return true;
    }

    private boolean setObviousDateFields(WorkingDateTime work, LinkedList<DateTimeToken> tokens) {
        int numberCount = 0;
        int tokensToExamine = 0;
        while (tokensToExamine != tokens.size()) {
            tokensToExamine = tokens.size();
            ListIterator<DateTimeToken> i = tokens.listIterator();
            while (i.hasNext()) {
                DateTimeToken token = (DateTimeToken)i.next();
                switch (token.getType()) {
                    case NUMBER: {
                        if (this.setWords(token, work, i)) break;
                        int value = token.getValue();
                        if (work.hasYear() && numberCount == 1 && !work.hasMonth() && !work.hasDay() && this.fieldOrder[0] != Field.YEAR && value <= 12) {
                            if (!work.setMonth(value)) {
                                return false;
                            }
                            i.remove();
                        } else {
                            Boolean set = work.setObviousDateNumberField(token);
                            if (set != null) {
                                if (Boolean.FALSE.equals(set)) {
                                    return false;
                                }
                                i.remove();
                            }
                        }
                        ++numberCount;
                        break;
                    }
                    case WORD: {
                        if (this.setWords(token, work, i)) break;
                        return false;
                    }
                    case APOS_YEAR: {
                        if (!work.setYear(token)) {
                            return false;
                        }
                        i.remove();
                        break;
                    }
                    case ORDINAL_DAY: {
                        if (!work.setDay(token.getValue())) {
                            return false;
                        }
                        i.remove();
                    }
                }
            }
        }
        return true;
    }

    private boolean setWord(String text, WorkingDateTime work) {
        if (this.monthWords.containsKey(text = text.toLowerCase())) {
            return work.setMonth(this.monthWords.get(text));
        }
        if (this.ampmWords.containsKey(text)) {
            return work.setAmPm(this.ampmWords.get(text));
        }
        if (this.ordinalWords.containsKey(text)) {
            return work.setDay(this.ordinalWords.get(text));
        }
        if (this.weekdayWords.contains(text)) {
            return true;
        }
        if (this.eraWords.containsKey(text)) {
            return work.setEra(this.eraWords.get(text));
        }
        return false;
    }

    private boolean setWords(DateTimeToken token, WorkingDateTime work, ListIterator<DateTimeToken> iterator) {
        if (this.setWord(token.getText(), work)) {
            iterator.remove();
            return true;
        }
        if (!iterator.hasNext()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(token.getText().toLowerCase());
        int additionalWords = 0;
        block4: while (additionalWords < 4 && iterator.hasNext()) {
            token = iterator.next();
            ++additionalWords;
            switch (token.getType()) {
                case NUMBER: 
                case WORD: {
                    sb.append(token.getText().toLowerCase());
                    break;
                }
                case SPACE: {
                    sb.append(" ");
                    break;
                }
                default: {
                    sb.append(token.getText().toLowerCase());
                    break block4;
                }
            }
            if (!this.setWord(sb.toString(), work)) continue;
            for (int i = 0; i < additionalWords; ++i) {
                iterator.remove();
                iterator.previous();
            }
            iterator.remove();
            return true;
        }
        for (int i = 0; i <= additionalWords; ++i) {
            iterator.previous();
        }
        iterator.next();
        return false;
    }

    private boolean containsOnlySpacesAndPunctuation(LinkedList<DateTimeToken> tokens) {
        Iterator i = tokens.iterator();
        block3: while (i.hasNext()) {
            DateTimeToken token = (DateTimeToken)i.next();
            switch (token.getType()) {
                case PUNCTUATION: 
                case SPACE: {
                    i.remove();
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    private class WorkingDateTime {
        int year = -1;
        int month = -1;
        int day = -1;
        int era = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int millisecond = -1;
        int amPm = -1;
        TimeZone zone = null;

        private WorkingDateTime() {
        }

        public Date getDate() {
            GregorianCalendar c;
            if (this.hasYear() && !this.hasMonth()) {
                this.month = 1;
            }
            if (this.hasMonth() && !this.hasDay()) {
                this.day = 1;
            }
            if (this.hasMonth() && !this.hasYear()) {
                this.year = DateTimeParse.this.defaultYear;
            }
            if (this.hasHour() && !this.hasYear() && !this.hasMonth() && !this.hasDay()) {
                c = new GregorianCalendar();
                this.year = c.get(1);
                this.month = c.get(2) + 1;
                this.day = c.get(5);
            }
            if (!(this.hasYear() && this.hasMonth() && this.hasDay())) {
                return null;
            }
            c = new GregorianCalendar();
            c.clear();
            c.set(this.year, this.month - 1, this.day);
            if (this.hasEra()) {
                c.set(0, this.era);
            }
            if (this.hasHour()) {
                int h = this.hour;
                if (this.isPm()) {
                    h += 12;
                }
                c.set(10, h);
            }
            if (this.hasMinute()) {
                c.set(12, this.minute);
            }
            if (this.hasSecond()) {
                c.set(13, this.second);
            }
            if (this.hasMillisecond()) {
                c.set(14, this.millisecond);
            }
            ((Calendar)c).setTimeZone(this.zone);
            return c.getTime();
        }

        public boolean hasEra() {
            return this.era != -1;
        }

        public boolean hasYear() {
            return this.year != -1;
        }

        public boolean hasMonth() {
            return this.month != -1;
        }

        public boolean hasDay() {
            return this.day != -1;
        }

        public boolean hasHour() {
            return this.hour != -1;
        }

        public boolean hasMinute() {
            return this.minute != -1;
        }

        public boolean hasSecond() {
            return this.second != -1;
        }

        public boolean hasAmPm() {
            return this.amPm != -1;
        }

        public boolean hasZone() {
            return this.zone != null;
        }

        public boolean hasMillisecond() {
            return this.millisecond != -1;
        }

        public boolean setEra(int value) {
            if (this.hasEra()) {
                return false;
            }
            this.era = value;
            return true;
        }

        public boolean setZone(TimeZone zone) {
            if (this.hasZone()) {
                return false;
            }
            this.zone = zone;
            return true;
        }

        public boolean isPm() {
            return this.amPm == 1;
        }

        public boolean setHour(int value) {
            if (this.hasHour()) {
                return false;
            }
            if (this.isPm() && value > 12) {
                return false;
            }
            this.hour = value;
            return true;
        }

        public boolean setAmPm(int value) {
            if (this.hasAmPm()) {
                return false;
            }
            if (this.hasHour() && this.hour > 12) {
                return false;
            }
            this.amPm = value;
            return true;
        }

        public boolean setMonth(int value) {
            if (this.hasMonth()) {
                return false;
            }
            this.month = value;
            return true;
        }

        public boolean setDay(int value) {
            if (this.hasDay()) {
                return false;
            }
            this.day = value;
            return true;
        }

        public boolean setYear(DateTimeToken t) {
            if (this.hasYear()) {
                return false;
            }
            String text = t.getText();
            int value = t.getValue();
            if (text.length() <= 2 && value < 100) {
                value = DateTimeParse.this.yearExtensionPolicy.extendYear(value);
            }
            this.year = value;
            return true;
        }

        public boolean setPreferredField(DateTimeToken t) {
            int value = t.getValue();
            block5: for (Field field : DateTimeParse.this.fieldOrder) {
                switch (field) {
                    case MONTH: {
                        if (this.hasMonth() || value < 1 || value > 12) continue block5;
                        return this.setMonth(value);
                    }
                    case DAY: {
                        if (this.hasDay() || value < 1 || value > 31) continue block5;
                        return this.setDay(value);
                    }
                    case YEAR: {
                        if (this.hasYear()) continue block5;
                        return this.setYear(t);
                    }
                }
            }
            return false;
        }

        public Boolean setObviousDateNumberField(DateTimeToken t) {
            String text = t.getText();
            int value = t.getValue();
            if (text.length() >= 3 || value > 31) {
                return this.setYear(t);
            }
            if (this.hasYear() && value > 12 && value <= 31) {
                return this.setDay(value);
            }
            if (this.hasYear() && this.hasDay() && value <= 12) {
                return this.setMonth(value);
            }
            if (this.hasYear() && this.hasMonth() && value >= 1 && value <= 31) {
                return this.setDay(value);
            }
            if (this.hasDay() && this.hasMonth()) {
                return this.setYear(t);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        YEAR,
        MONTH,
        DAY;

    }
}

