/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadLineEndingException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVPrint;
import com.Ostermiller.util.StringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class ExcelCSVPrinter
implements CSVPrint {
    private static final boolean AUTO_FLUSH_DEFAULT = true;
    protected boolean autoFlush = true;
    private static final boolean ALWAYS_QUOTE_DEFAULT = false;
    protected boolean alwaysQuote = false;
    protected boolean error = false;
    private static final char DELIMITER_DEFAULT = ',';
    protected char delimiterChar = (char)44;
    private static final char QUOTE_DEFAULT = '\"';
    protected char quoteChar = (char)34;
    protected Writer out;
    protected boolean newLine = true;
    private static final String LINE_ENDING_DEFAULT = "\n";
    private static final String LINE_ENDING_SYSTEM = null;
    protected String lineEnding = "\n";

    public ExcelCSVPrinter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public ExcelCSVPrinter(Writer out) {
        this(out, false, true);
    }

    public ExcelCSVPrinter(Writer out, boolean alwaysQuote, boolean autoFlush) {
        this(out, '\"', ',', alwaysQuote, autoFlush);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter) throws BadDelimiterException, BadQuoteException {
        this(out, quote, delimiter, false, true);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter, String lineEnding) throws BadDelimiterException, BadQuoteException, BadLineEndingException {
        this(out, quote, delimiter, lineEnding, false, true);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException {
        this(out, quote, delimiter, LINE_ENDING_SYSTEM, alwaysQuote, autoFlush);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter, String lineEnding, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException, BadLineEndingException {
        this.out = out;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
        this.setLineEnding(lineEnding);
    }

    public void changeDelimiter(char newDelimiter) throws BadDelimiterException {
        if (this.delimiterChar == newDelimiter) {
            return;
        }
        if (newDelimiter == '\n' || newDelimiter == '\r' || newDelimiter == this.delimiterChar || newDelimiter == this.quoteChar) {
            throw new BadDelimiterException();
        }
        this.delimiterChar = newDelimiter;
    }

    public void changeQuote(char newQuote) throws BadQuoteException {
        if (this.quoteChar == newQuote) {
            return;
        }
        if (newQuote == '\n' || newQuote == '\r' || newQuote == this.delimiterChar || newQuote == this.quoteChar) {
            throw new BadQuoteException();
        }
        this.quoteChar = newQuote;
    }

    public void setLineEnding(String lineEnding) throws BadLineEndingException {
        boolean setDefault;
        boolean bl = setDefault = lineEnding == null;
        if (setDefault) {
            lineEnding = System.getProperty("line.separator");
        }
        if (!(LINE_ENDING_DEFAULT.equals(lineEnding) || "\r".equals(lineEnding) || "\r\n".equals(lineEnding))) {
            if (setDefault) {
                lineEnding = LINE_ENDING_DEFAULT;
            } else {
                throw new BadLineEndingException();
            }
        }
        this.lineEnding = lineEnding;
    }

    public void println(String value) {
        try {
            this.writeln(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String value) throws IOException {
        try {
            this.write(value);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println() {
        try {
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln() throws IOException {
        try {
            this.out.write(this.lineEnding);
            if (this.autoFlush) {
                this.flush();
            }
            this.newLine = true;
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println(String[] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String[] values) throws IOException {
        try {
            this.print(values);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void print(String[] values) {
        try {
            this.write(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void write(String[] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.write(values[i]);
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println(String[][] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String[][] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.writeln(values[i]);
            }
            if (values.length == 0) {
                this.writeln();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void printlnComment(String comment) {
        this.println();
    }

    public void writelnComment(String comment) throws IOException {
        this.writeln();
    }

    public void print(String value) {
        try {
            this.write(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void write(String value) throws IOException {
        try {
            if (value == null) {
                value = "";
            }
            boolean quote = false;
            if (this.alwaysQuote) {
                quote = true;
            } else if (value.length() > 0) {
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c != this.quoteChar && c != this.delimiterChar && c != '\n' && c != '\r') continue;
                    quote = true;
                }
            } else if (this.newLine) {
                quote = true;
            }
            if (this.newLine) {
                this.newLine = false;
            } else {
                this.out.write(this.delimiterChar);
            }
            if (quote) {
                this.out.write(this.escapeAndQuote(value));
            } else {
                this.out.write(value);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    private String escapeAndQuote(String value) {
        String s = StringHelper.replace(value, String.valueOf(this.quoteChar), String.valueOf(this.quoteChar) + String.valueOf(this.quoteChar));
        return new StringBuffer(2 + s.length()).append(this.quoteChar).append(s).append(this.quoteChar).toString();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public boolean checkError() {
        try {
            if (this.error) {
                return true;
            }
            this.flush();
            if (this.error) {
                return true;
            }
            if (this.out instanceof PrintWriter) {
                this.error = ((PrintWriter)this.out).checkError();
            }
        }
        catch (IOException iox) {
            this.error = true;
        }
        return this.error;
    }

    public void setAlwaysQuote(boolean alwaysQuote) {
        this.alwaysQuote = alwaysQuote;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }
}

