/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.RandPass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RandPassApplet
extends JApplet {
    private static final long serialVersionUID = 1838771003552061341L;
    private JTextArea display = new JTextArea();
    private JButton clearButton = new JButton("Clear");
    private JButton generateButton = new JButton("Generate");
    private char[] passwordAlphabet = RandPass.NONCONFUSING_ALPHABET;
    private JTextField alphabetField = new JTextField(new String(this.passwordAlphabet));
    private char[] passwordFirstAlphabet = new char[0];
    private JTextField alphabetFirstField = new JTextField(new String(this.passwordFirstAlphabet));
    private char[] passwordLastAlphabet = new char[0];
    private JTextField alphabetLastField = new JTextField(new String(this.passwordLastAlphabet));
    private int passwordLength = 8;
    private JTextField passwordLengthField = new JTextField("" + this.passwordLength);
    private RandPass randPass = new RandPass(this.passwordAlphabet);
    private GridLayout preferencesPanelLayout = new GridLayout(4, 2);
    private JPanel preferencesPanel = new JPanel(this.preferencesPanelLayout);

    public void init() {
        this.getContentPane().removeAll();
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.getAccessibleContext().setAccessibleDescription("Change how passwords are generated.");
        JMenuItem prefsMenuItem = new JMenuItem("Preferences...", 80);
        prefsMenuItem.getAccessibleContext().setAccessibleDescription("Set password length and content.");
        this.preferencesPanelLayout.setHgap(5);
        Dimension d = this.passwordLengthField.getPreferredSize();
        d.setSize(70.0, d.getHeight());
        this.passwordLengthField.setPreferredSize(d);
        d = this.alphabetField.getPreferredSize();
        d.setSize(70.0, d.getHeight());
        this.alphabetField.setPreferredSize(d);
        d = this.alphabetFirstField.getPreferredSize();
        d.setSize(70.0, d.getHeight());
        this.alphabetFirstField.setPreferredSize(d);
        d = this.alphabetLastField.getPreferredSize();
        d.setSize(70.0, d.getHeight());
        this.alphabetLastField.setPreferredSize(d);
        this.preferencesPanel.add(new JLabel("Length:"));
        this.preferencesPanel.add(this.passwordLengthField);
        this.preferencesPanel.add(new JLabel("Alphabet:"));
        this.preferencesPanel.add(this.alphabetField);
        this.preferencesPanel.add(new JLabel("First Character Alphabet:"));
        this.preferencesPanel.add(this.alphabetFirstField);
        this.preferencesPanel.add(new JLabel("Last Character Alphabet:"));
        this.preferencesPanel.add(this.alphabetLastField);
        prefsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RandPassApplet.this.passwordLengthField.setText("" + RandPassApplet.this.passwordLength);
                RandPassApplet.this.alphabetField.setText(new String(RandPassApplet.this.passwordAlphabet));
                RandPassApplet.this.alphabetFirstField.setText(new String(RandPassApplet.this.passwordFirstAlphabet));
                RandPassApplet.this.alphabetLastField.setText(new String(RandPassApplet.this.passwordLastAlphabet));
                int preferencesResult = JOptionPane.showConfirmDialog(RandPassApplet.this, RandPassApplet.this.preferencesPanel, "Preferences", 2, 3);
                if (preferencesResult == 0) {
                    try {
                        int length = Integer.parseInt(RandPassApplet.this.passwordLengthField.getText());
                        if (length >= 3 && length <= 100) {
                            RandPassApplet.this.passwordLength = length;
                        }
                    }
                    catch (NumberFormatException x) {
                        // empty catch block
                    }
                    String alphabetString = RandPassApplet.this.alphabetField.getText();
                    RandPassApplet.access$202(RandPassApplet.this, new char[alphabetString.length()]);
                    alphabetString.getChars(0, alphabetString.length(), RandPassApplet.this.passwordAlphabet, 0);
                    RandPassApplet.this.randPass.setAlphabet(RandPassApplet.this.passwordAlphabet);
                    String alphabetFirstString = RandPassApplet.this.alphabetFirstField.getText();
                    RandPassApplet.access$402(RandPassApplet.this, new char[alphabetFirstString.length()]);
                    alphabetFirstString.getChars(0, alphabetFirstString.length(), RandPassApplet.this.passwordFirstAlphabet, 0);
                    RandPassApplet.this.randPass.setFirstAlphabet(RandPassApplet.this.passwordFirstAlphabet);
                    String alphabetLastString = RandPassApplet.this.alphabetLastField.getText();
                    RandPassApplet.access$602(RandPassApplet.this, new char[alphabetLastString.length()]);
                    alphabetLastString.getChars(0, alphabetLastString.length(), RandPassApplet.this.passwordLastAlphabet, 0);
                    RandPassApplet.this.randPass.setLastAlphabet(RandPassApplet.this.passwordLastAlphabet);
                }
            }
        });
        editMenu.add(prefsMenuItem);
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
        this.display.setEditable(false);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.display), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RandPassApplet.this.display.setText("");
            }
        });
        buttonPanel.add(this.clearButton);
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RandPassApplet.this.display.append(RandPassApplet.this.randPass.getPass(RandPassApplet.this.passwordLength) + '\n');
            }
        });
        buttonPanel.add(this.generateButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.display.setText(this.randPass.getPass(this.passwordLength) + '\n');
    }

    public String getAppletInfo() {
        return "Title: Random Password Generator\nAuthor: Stephen Ostermiller\nhttp://ostermiller.org/contact.pl?regarding=Random+Password+Generator+Applet\nGenerates secure random passwords.";
    }

    static /* synthetic */ char[] access$202(RandPassApplet x0, char[] x1) {
        x0.passwordAlphabet = x1;
        return x1;
    }

    static /* synthetic */ char[] access$402(RandPassApplet x0, char[] x1) {
        x0.passwordFirstAlphabet = x1;
        return x1;
    }

    static /* synthetic */ char[] access$602(RandPassApplet x0, char[] x1) {
        x0.passwordLastAlphabet = x1;
        return x1;
    }
}

