/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitInputStream
extends InputStream {
    protected InputStream in;
    protected long maxBytesToRead = 0L;
    protected long bytesRead = 0L;
    protected long bytesReadSinceMark = 0L;
    protected long markReadLimitBytes = -1L;

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesLeft() {
        return this.maxBytesToRead - this.bytesRead;
    }

    public boolean allBytesRead() {
        return this.getBytesLeft() == 0L;
    }

    public long getMaxBytesToRead() {
        return this.maxBytesToRead;
    }

    public SizeLimitInputStream(InputStream in, long maxBytesToRead) {
        this.in = in;
        this.maxBytesToRead = maxBytesToRead;
    }

    public int read() throws IOException {
        if (this.bytesRead >= this.maxBytesToRead) {
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            ++this.bytesRead;
            ++this.bytesReadSinceMark;
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead >= this.maxBytesToRead) {
            return -1;
        }
        long bytesLeft = this.getBytesLeft();
        if ((long)len > bytesLeft) {
            len = (int)bytesLeft;
        }
        int bytesJustRead = this.in.read(b, off, len);
        this.bytesRead += (long)bytesJustRead;
        this.bytesReadSinceMark += (long)bytesJustRead;
        return bytesJustRead;
    }

    public long skip(long n) throws IOException {
        if (this.bytesRead >= this.maxBytesToRead) {
            return -1L;
        }
        long bytesLeft = this.getBytesLeft();
        if (n > bytesLeft) {
            n = bytesLeft;
        }
        return this.in.skip(n);
    }

    public int available() throws IOException {
        long bytesLeft;
        int available = this.in.available();
        if ((long)available > (bytesLeft = this.getBytesLeft())) {
            available = (int)bytesLeft;
        }
        return available;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readlimit) {
        if (this.in.markSupported()) {
            this.markReadLimitBytes = readlimit;
            this.bytesReadSinceMark = 0L;
            this.in.mark(readlimit);
        }
    }

    public void reset() throws IOException {
        if (this.in.markSupported() && this.bytesReadSinceMark <= this.markReadLimitBytes) {
            this.bytesRead -= this.bytesReadSinceMark;
            this.in.reset();
            this.bytesReadSinceMark = 0L;
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

