/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.PropertiesLexer;
import com.Ostermiller.util.PropertiesToken;
import com.Ostermiller.util.StringHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class UberProperties {
    private HashMap<String, Property> properties = new HashMap();
    private String comment = null;
    private static final int TYPE_COMMENT = 0;
    private static final int TYPE_NAME = 1;
    private static final int TYPE_VALUE = 2;

    public UberProperties() {
    }

    public UberProperties(UberProperties defaults) {
        this.merge(defaults);
    }

    private void merge(UberProperties defaults) {
        String[] names;
        this.setComment(defaults.getComment());
        for (String element : names = defaults.propertyNames()) {
            this.setProperties(element, defaults.getProperties(element));
            this.setComment(element, defaults.getComment(element));
        }
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.properties.containsKey(name);
    }

    public boolean remove(String name) {
        if (!this.contains(name)) {
            return false;
        }
        this.properties.remove(name);
        return true;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove(name);
        } else if (this.properties.containsKey(name)) {
            Property property = this.properties.get(name);
            property.set(value);
        } else {
            Property property = new Property(value);
            this.properties.put(name, property);
        }
    }

    public void setProperties(String name, String[] values) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        if (this.properties.containsKey(name)) {
            Property property = this.properties.get(name);
            property.set(values);
        } else {
            Property property = new Property(values);
            this.properties.put(name, property);
        }
    }

    public void setProperty(String name, String value, String comment) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.setProperty(name, value);
            this.setComment(name, comment);
        }
    }

    public void setProperties(String name, String[] values, String comment) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setProperties(name, values);
        this.setComment(name, comment);
    }

    private void setComment(String name, String comment) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.properties.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        this.properties.get(name).setComment(comment);
    }

    public void addProperty(String name, String value, String comment) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.addProperty(name, value);
        this.setComment(name, comment);
    }

    public void addProperties(String name, String[] values, String comment) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        this.addProperties(name, values);
        this.setComment(name, comment);
    }

    public void addProperty(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.properties.containsKey(name)) {
            Property property = this.properties.get(name);
            property.add(value);
        } else {
            Property property = new Property(value);
            this.properties.put(name, property);
        }
    }

    public void addProperties(String name, String[] values) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.properties.containsKey(name)) {
            Property property = this.properties.get(name);
            property.add(values);
        } else {
            Property property = new Property(values);
            this.properties.put(name, property);
        }
    }

    private static int hexDigitValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    private static String unescape(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i >= s.length()) continue;
                c = s.charAt(i);
                switch (c) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'u': {
                        boolean foundUnicode = false;
                        if (i + 4 < s.length()) {
                            int unicodeValue = 0;
                            for (int j = 3; unicodeValue >= 0 && j >= 0; --j) {
                                int val = UberProperties.hexDigitValue(s.charAt(i + (4 - j)));
                                if (val == -1) {
                                    unicodeValue = -1;
                                    continue;
                                }
                                unicodeValue |= val << (j << 2);
                            }
                            if (unicodeValue >= 0) {
                                i += 4;
                                foundUnicode = true;
                                sb.append((char)unicodeValue);
                            }
                        }
                        if (foundUnicode) continue block7;
                        sb.append(c);
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void load(String[] userFile, String systemResource) throws IOException {
        int length = userFile.length;
        if (userFile.length == 0) {
            throw new IllegalArgumentException();
        }
        InputStream in = ClassLoader.getSystemResourceAsStream(systemResource);
        if (in == null) {
            throw new FileNotFoundException(systemResource);
        }
        if (systemResource != null) {
            this.load(in);
        }
        File f = new File(System.getProperty("user.home"));
        for (int i = 0; f.exists() && i < length; ++i) {
            f = new File(f, userFile[i]);
        }
        if (f.exists()) {
            this.load(new FileInputStream(f));
        }
    }

    public void load(InputStream in, boolean add) throws IOException {
        this.load(new InputStreamReader(in, "ISO-8859-1"), add);
    }

    public void load(Reader reader, boolean add) throws IOException {
        PropertiesToken t;
        PropertiesLexer lex = new PropertiesLexer(reader);
        HashSet<String> names = new HashSet<String>();
        StringBuffer comment = new StringBuffer();
        boolean foundComment = false;
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean atStart = true;
        String lastSeparator = null;
        while ((t = lex.getNextToken()) != null) {
            if (t.getID() == 0) {
                int start = 1;
                String commentText = t.getContents();
                if (commentText.startsWith("# ")) {
                    start = 2;
                }
                comment.append(commentText.substring(start, commentText.length()));
                comment.append("\n");
                lex.getNextToken();
                foundComment = true;
                continue;
            }
            if (t.getID() == 5) {
                if (atStart) {
                    this.setComment(comment.toString());
                    comment.setLength(0);
                    atStart = false;
                }
                name.append(t.getContents());
                continue;
            }
            if (t.getID() == 6) {
                if (atStart) {
                    this.setComment(comment.toString());
                    comment.setLength(0);
                    atStart = false;
                }
                value.append(t.getContents());
                continue;
            }
            if (t.getID() == 3) {
                lastSeparator = t.getContents();
                continue;
            }
            if (t.getID() != 1) continue;
            if (atStart) {
                this.setComment(comment.toString());
                comment.setLength(0);
                atStart = false;
            }
            String stName = UberProperties.unescape(name.toString());
            String stValue = UberProperties.unescape(value.toString());
            if (lastSeparator != null || stName.length() > 0 || stValue.length() > 0) {
                if (add || names.contains(stName)) {
                    this.addProperty(stName, stValue);
                } else {
                    this.setProperty(stName, stValue);
                    names.add(stName);
                }
                if (foundComment) {
                    this.setComment(stName, UberProperties.unescape(comment.toString()));
                }
            }
            comment.setLength(0);
            name.setLength(0);
            value.setLength(0);
            foundComment = false;
            lastSeparator = null;
        }
    }

    public void load(InputStream in) throws IOException {
        this.load(in, false);
    }

    public void load(Reader in) throws IOException {
        this.load(in, false);
    }

    public void save(String[] userFile) throws IOException {
        int length = userFile.length;
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        File f = new File(System.getProperty("user.home"));
        for (int i = 0; i < length; ++i) {
            f = new File(f, userFile[i]);
            if (i != length - 2 || f.exists()) continue;
            f.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(Writer out) throws IOException {
        UberProperties.writeComment(out, this.comment);
        out.write(10);
        Object[] names = this.propertyNames();
        Arrays.sort(names);
        for (Object element : names) {
            String[] values;
            UberProperties.writeComment(out, this.getComment((String)element));
            for (String element2 : values = this.getProperties((String)element)) {
                UberProperties.writeProperty(out, (String)element, element2);
            }
        }
        out.flush();
    }

    public void save(OutputStream out) throws IOException {
        UberProperties.writeComment(out, this.comment);
        out.write(10);
        Object[] names = this.propertyNames();
        Arrays.sort(names);
        for (Object element : names) {
            String[] values;
            UberProperties.writeComment(out, this.getComment((String)element));
            for (String element2 : values = this.getProperties((String)element)) {
                UberProperties.writeProperty(out, (String)element, element2);
            }
        }
        out.flush();
    }

    private static void writeProperty(OutputStream out, String name, String value) throws IOException {
        UberProperties.writeEscapedISO88591(out, name, 1);
        out.write(61);
        UberProperties.writeEscapedISO88591(out, value, 2);
        out.write(10);
    }

    private static void writeProperty(Writer out, String name, String value) throws IOException {
        UberProperties.writeEscapedText(out, name, 1);
        out.write(61);
        UberProperties.writeEscapedText(out, value, 2);
        out.write(10);
    }

    private static void writeComment(OutputStream out, String comment) throws IOException {
        if (comment != null) {
            StringTokenizer tok = new StringTokenizer(comment, "\r\n");
            while (tok.hasMoreTokens()) {
                out.write(35);
                out.write(32);
                UberProperties.writeEscapedISO88591(out, tok.nextToken(), 0);
                out.write(10);
            }
        }
    }

    private static void writeComment(Writer out, String comment) throws IOException {
        if (comment != null) {
            StringTokenizer tok = new StringTokenizer(comment, "\r\n");
            while (tok.hasMoreTokens()) {
                out.write(35);
                out.write(32);
                UberProperties.writeEscapedText(out, tok.nextToken(), 0);
                out.write(10);
            }
        }
    }

    private static void writeEscapedISO88591(OutputStream out, String s, int type) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0100') {
                boolean escape = false;
                if (c == '\r' || c == '\n' || c == '\\') {
                    escape = true;
                } else if (c == ' ' || c == '\t' || c == '\f') {
                    if (type == 1) {
                        escape = true;
                    } else if (type == 2 && (i == 0 || i == s.length() - 1)) {
                        escape = true;
                    }
                } else if (type == 1 && (c == '=' || c == ':')) {
                    escape = true;
                }
                if (escape) {
                    block0 : switch (c) {
                        case '\n': {
                            switch (type) {
                                case 0: {
                                    out.write(10);
                                    out.write(35);
                                    out.write(32);
                                    break block0;
                                }
                                case 1: {
                                    out.write(92);
                                    out.write(110);
                                    out.write(92);
                                    out.write(10);
                                    out.write(9);
                                    break block0;
                                }
                                case 2: {
                                    out.write(92);
                                    out.write(110);
                                    out.write(92);
                                    out.write(10);
                                    out.write(9);
                                    out.write(9);
                                }
                            }
                            break;
                        }
                        case '\\': {
                            out.write(92);
                            out.write(92);
                            break;
                        }
                        case '\r': {
                            out.write(92);
                            out.write(114);
                            break;
                        }
                        case '\t': {
                            out.write(92);
                            out.write(116);
                            break;
                        }
                        case '\f': {
                            out.write(92);
                            out.write(102);
                            break;
                        }
                        default: {
                            out.write(92);
                            out.write((byte)c);
                            break;
                        }
                    }
                    continue;
                }
                out.write((byte)c);
                continue;
            }
            out.write(92);
            out.write(117);
            out.write(StringHelper.prepad(Integer.toHexString(c), 4, '0').getBytes("ISO-8859-1"));
        }
    }

    private static void writeEscapedText(Writer out, String s, int type) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean escape = false;
            if (c == '\r' || c == '\n' || c == '\\') {
                escape = true;
            } else if (c == ' ' || c == '\t' || c == '\f') {
                if (type == 1) {
                    escape = true;
                } else if (type == 2 && (i == 0 || i == s.length() - 1)) {
                    escape = true;
                }
            } else if (type == 1 && (c == '=' || c == ':')) {
                escape = true;
            }
            if (escape) {
                block0 : switch (c) {
                    case '\n': {
                        switch (type) {
                            case 0: {
                                out.write("\n# ");
                                break block0;
                            }
                            case 1: {
                                out.write("\\n\\\n\t");
                                break block0;
                            }
                            case 2: {
                                out.write("\\n\\\n\t\t");
                            }
                        }
                        break;
                    }
                    case '\\': {
                        out.write("\\\\");
                        break;
                    }
                    case '\r': {
                        out.write("\\r");
                        break;
                    }
                    case '\t': {
                        out.write("\\t");
                        break;
                    }
                    case '\f': {
                        out.write("\\f");
                        break;
                    }
                    default: {
                        out.write(92);
                        out.write(c);
                        break;
                    }
                }
                continue;
            }
            out.write(c);
        }
    }

    public String getProperty(String name) {
        String value = null;
        if (this.properties.containsKey(name)) {
            value = this.properties.get(name).getValue();
        }
        return value;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getProperties(String name) {
        String[] values = null;
        if (this.properties.containsKey(name)) {
            values = this.properties.get(name).getValues();
        }
        return values;
    }

    public Properties toJavaUtilProperties() {
        Properties p = new Properties();
        for (String name : this.propertyNames()) {
            p.put(name, this.getProperty(name));
        }
        return p;
    }

    public String[] getProperties(String name, String[] defaultValues) {
        String[] values = this.getProperties(name);
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    public String getComment(String name) {
        String comment = null;
        if (this.properties.containsKey(name)) {
            comment = this.properties.get(name).getComment();
        }
        return comment;
    }

    public String[] propertyNames() {
        Set<String> names = this.properties.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public int getPropertyNameCount() {
        return this.properties.keySet().size();
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.save(out);
        }
        catch (IOException iox) {
            throw new Error("IO constructed on memory, this shouldn't happen.", iox);
        }
        String s = null;
        try {
            s = new String(out.toByteArray(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error("ISO-8859-1 should be recognized.", uee);
        }
        return s;
    }

    public Integer getIntegerProperty(String name) {
        return StringHelper.parseInteger(this.getProperty(name));
    }

    public int getIntProperty(String name, int defaultValue) {
        return StringHelper.parseInt(this.getProperty(name), defaultValue);
    }

    public Boolean getBooleanProperty(String name) {
        return StringHelper.parseBoolean(this.getProperty(name));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return StringHelper.parseBoolean(this.getProperty(name), defaultValue);
    }

    private class Property {
        private ArrayList<String> list;
        private String comment = null;

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public Property(String value) {
            this.list = new ArrayList(1);
            this.add(value);
        }

        public Property(String[] values) {
            this.list = new ArrayList(values.length);
            this.add(values);
        }

        public void set(String value) {
            this.list.clear();
            this.add(value);
        }

        public void set(String[] values) {
            this.list.clear();
            this.add(values);
        }

        public void add(String value) {
            this.list.add(value);
        }

        public void add(String[] values) {
            this.list.ensureCapacity(this.list.size() + values.length);
            for (String element : values) {
                this.add(element);
            }
        }

        public String getValue() {
            return this.list.get(this.list.size() - 1);
        }

        public String[] getValues() {
            return this.list.toArray(new String[this.list.size()]);
        }
    }
}

