package algorithmen;

import java.lang.Thread;
import java.nio.file.*;
import javax.swing.*;

import graph.*;
/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public abstract class GraphAlgo extends Thread {

  // Anfang Attribute
  private boolean stepping;
  private boolean waitforrepaint;
  private boolean waitforclick;
  protected boolean inArbeit;
  private GraphPlotter gp;
  private Knoten startKnoten;
  private int speed =100;
  protected Graph g;
  // Ende Attribute

  // Anfang Methoden
  public GraphAlgo(GraphPlotter graphPlotter) {
    stepping = true;    
    waitforrepaint = false;
    waitforclick = false;
    gp = graphPlotter;
    g = gp.getGraph();
  }

  public void step() {
    try{
      gp.updateMxGraph();
      gp.setInfoText(getInfo());
      Thread.sleep(speed);
      if(stepping) {
        waitforclick = true;
        while(waitforclick){
          Thread.sleep(10);
        }
      }
    }catch(Exception e) {
      System.out.println("Ausführung vorzeitig beendet");
    }
  }

  public boolean getWaitforrepaint() {
    return waitforrepaint;
  }

  public void setWaitforrepaint(boolean waitforrepaintNeu) {
    waitforrepaint = waitforrepaintNeu;
  }

  public boolean getWaitforclick() {
    return waitforclick;
  }

  public void setWaitforclick(boolean waitforclickNeu) {
    waitforclick = waitforclickNeu;
  }
  
  public void setStepping(boolean stepping) {
    this.stepping = stepping;
  }

  public void setSpeed(int delay) {
    this.speed = delay;
  }
  
  public void run()
  {
    if(!inArbeit)
    {
      System.out.println("Algorithmus gestartet");
      inArbeit = true;
      fuehreAlgorithmusAus();
      System.out.println("Algorithmus beendet");
      inArbeit = false;
      return;
    }
    else
    {
      return;
    }
  }
  // Ende Methoden
  
  public void setStartKnoten(Knoten k) {
    startKnoten = k;
    }
  
  public Knoten getStartKnoten() {
    if (startKnoten != null) {
      return startKnoten;
    } else {
      return g.getKnoten(0);
    } // end of if-else
  }
  
  public abstract void fuehreAlgorithmusAus();
  
  public String getInfo() {
      return "";
  }
  
  public abstract String getBezeichnung();
  
  public Path getBspPath() {
    return null;
  }


}

