package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_Kruskal extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_Kruskal(GraphPlotter gp) {
    super(gp);
  }
  
  public String getBezeichnung() {
    return "Kruskal-MST";
  }

  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","03_minimalspanningtree");
  }
   // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    ArrayList<Kante> kantensortiert = new ArrayList<Kante>();
    for (Kante k : kanten) {
      int i = 0;
      while (i< kantensortiert.size() && k.getGewicht()> kantensortiert.get(i).getGewicht()) {
        i++;
      } // end of while
      kantensortiert.add(i,k);
      
    } // end of for
    
    for (Kante k: kantensortiert) {
      k.getStart().setMarkiert(true);
      k.getZiel().setMarkiert(true);
      if(!findeWeg(k.getStart(), k.getZiel())){
        k.setMarkiert(true);
        g.initialisiereAlleKnoten();
        step();
      } else {
        k.setGeloescht(true);
      }
      g.initialisiereAlleKnoten();
    }
    step();
  } // end of for
  

  
  /**
  * Hilfsmethode zum kurzsichtigen Algorithmus.
  * Findet die minimale Kante von einem gegebenen StartKnoten.
  *
     * @param  Knoten startKnoten  Der StartKnoten, von dem aus die Adjazenzliste durchlaufen wird
  * @return  Kante   Die gesuchte minimale Kante
  */
  public boolean findeWeg(Knoten s, Knoten z) {
    if(s==z) return true;
    
    boolean gefunden = false;
    s.setBesucht(true);
    step();
    ArrayList<Kante> kanten = g.getAusgehendeKanten(s);
    for (Kante k: kanten) {
      if(k.isMarkiert()) { // Nur markierte Kanten zaehlen als Weg
        if(!k.getAnderesEnde(s).isBesucht()) {
          if(findeWeg(k.getAnderesEnde(s), z)) return true;
        }
      }
    } // end of for
    return false;
  }
  // Ende Methoden
  
}

