package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_TSPGreedy extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_TSPGreedy(GraphPlotter gp) {
    super(gp);
  }
  
  public String getBezeichnung() {
    return "TSP-Greedy";
  }

  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","05_travelingsalesman");
  }
   // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
     Knoten start = this.getStartKnoten();
     Knoten akt = start;
     Kante min;
     do{
     ArrayList<Kante> kanten = g.getAusgehendeKanten(akt);
     min = null;
     double mindist = Double.MAX_VALUE;
     for(Kante k: kanten) {
        if(!k.getAnderesEnde(akt).isMarkiert()) {
            if(min == null || mindist > k.getGewicht()) {
                min = k;
                mindist = k.getGewicht();
            }
        }
     }
     akt.setMarkiert(true);
     if(min != null) {
       min.setMarkiert(true);
       akt = min.getAnderesEnde(akt);
     }
     step();
    }while (min!=null);
    g.getKante(akt,start).setMarkiert(true);
    step(); 
  } // end of for
  
  public String getInfo() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    double laenge = 0;
    int anz =0;
    for(Kante k:kanten) {
        if(k.isMarkiert()) {
            laenge+=k.getGewicht();
            anz++;
        }
    }
    
    return "Weglänge ("+anz+" von "+g.getAnzahlKnoten()+" Kanten): "+laenge+" km.";
}
  
  // Ende Methoden
  
}

