package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_TSPGreedy_Opt extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_TSPGreedy_Opt(GraphPlotter gp) {
    super(gp);
  }
  
  public String getBezeichnung() {
    return "TSP-GreedyOpt";
  }

  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","05_travelingsalesman");
  }
   // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
     Knoten start = this.getStartKnoten();
     Knoten akt = start;
     ArrayList<Knoten> reihung = new ArrayList<Knoten>();
     reihung.add(start);
     Kante min;
     do{
     ArrayList<Kante> kanten = g.getAusgehendeKanten(akt);
     min = null;
     double mindist = Double.MAX_VALUE;
     for(Kante k: kanten) {
        if(!k.getAnderesEnde(akt).isMarkiert()) {
            if(min == null || mindist > k.getGewicht()) {
                min = k;
                mindist = k.getGewicht();
            }
        }
     }
     akt.setMarkiert(true);
     if(min != null) {
       min.setMarkiert(true);
       akt = min.getAnderesEnde(akt);
       reihung.add(akt);
     }
     step();
    }while (min!=null);
    g.getKante(akt,start).setMarkiert(true);
    step();
    // Versuch der Optimierung
    for(int o=0; o<5 ; o++)
    for(Knoten kn : g.getAlleKnoten()) {
      ArrayList<Kante> markierteKanten = new ArrayList<Kante>();
      for(Kante k: g.getAusgehendeKanten(kn)){
        if(k.isMarkiert()) {
            markierteKanten.add(k);
            k.setMarkiert(false);
        }
      }
      g.getKante(markierteKanten.get(0).getAnderesEnde(kn),markierteKanten.get(1).getAnderesEnde(kn)).setMarkiert(true);
      double laengeBest = Double.MAX_VALUE;
      Kante kanteBest = null;
      for(Kante k2: g.getAlleKanten()) {
        if(k2.isMarkiert()) {
          double laengeNeu = g.getKante(k2.getStart(),kn).getGewicht()+g.getKante(k2.getZiel(),kn).getGewicht()-k2.getGewicht() ;
          if(laengeBest > laengeNeu) {
              laengeBest = laengeNeu;
              kanteBest = k2;
            }
        }
      }
      kanteBest.setMarkiert(false);
      g.getKante(kanteBest.getStart(),kn).setMarkiert(true);
      g.getKante(kanteBest.getZiel(),kn).setMarkiert(true); 
      step();
    }
    step(); 
  } // end of for
  
  public double getLaenge() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    double laenge = 0;
    for(Kante k:kanten) {
        if(k.isMarkiert()) laenge+=k.getGewicht();
    }
    return laenge;
}
      
  public String getInfo() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    double laenge = 0;
    int anz =0;
    for(Kante k:kanten) {
        if(k.isMarkiert()) {
            laenge+=k.getGewicht();
            anz++;
        }
    }
    
    return "Weglänge ("+anz+" von "+g.getAnzahlKnoten()+" Kanten): "+laenge+" km.";
}
  // Ende Methoden
  
}

