package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;
/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_Coloring extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_Coloring(GraphPlotter gp) {
    super(gp);
  }
  
  
  public  String getBezeichnung() {
    return "Greedy-Coloring";
  }
  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","01_mapcoloring");
  }
  // Ende Attribute
  
  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
    ArrayList<Knoten> knoten = g.getAlleKnoten();
    for (Knoten aktuellerKnoten: knoten ) {
      // Liste in der die Farben der adjazenten Knoten abgehakt werden. Die Farben
      // sind von 1 bis n (# Knoten) kodiert und werden spaeter in Farben decodiert 
      boolean[] farbenliste = new boolean[g.getAnzahlKnoten()+1];
      ArrayList<Knoten> nachbarn = g.getNachbarKnoten(aktuellerKnoten);
      
      // speichere alle Farben in dem Array farbenliste[], die in der Adjazenzliste vom Knoten k als Wert vorkommen
      for (Knoten k : nachbarn){
        farbenliste[k.getFarbe()]=true;
      }
      
      // faerbe den Knoten k (setze den Farbwert des Knotens) mit der niedrigst-moeglichen Farbe (kleinster Index > 0 in der farbenliste)
      for (int i=1; i<farbenliste.length; i++){
        if (!farbenliste[i]) {
          aktuellerKnoten.setFarbe(i);
          break;
        }
      }
      step();
    } // end of for
  }
  
  // Ende Methoden
  
}

