package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;


import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_Dijkstra extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_Dijkstra(GraphPlotter gp) {
    super(gp);
  }

  public  String getBezeichnung() {
    return "Dijkstra";
  }
  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","04_routenplanung");
  }  // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
    if (g.getAnzahlKnoten()==0) {
      return;
    } 
    getStartKnoten().setBesucht(true);
    for (Knoten k=findeKleinstenKnoten(); k!=null; k=findeKleinstenKnoten()) { 
      k.setMarkiert(true);
      System.out.println("Werte Knoten "+g.getAlleKnoten().indexOf(k)+" aus");
      ArrayList<Kante> kanten = g.getAusgehendeKanten(k);
      for (Kante e: kanten) {
        Knoten z = e.getAnderesEnde(k);
        System.out.println("Untersuche Kante zu Knoten "+g.getAlleKnoten().indexOf(z)+" aus");
        if (!z.isMarkiert()) {
          if (z.getDoubleWert()== Double.NaN || z.getDoubleWert()==0.0 || z.getDoubleWert() > k.getDoubleWert()+e.getGewicht()) {
            for (Kante e2: g.getEingehendeKanten(z) ) {
              if(e2.isMarkiert()) e2.setGeloescht(true);
            } // end of for
            e.setMarkiert(true);
            z.setWert(k.getDoubleWert()+e.getGewicht());
            z.setBesucht(true);
            System.out.println("Neuer bester Wert");
          } else {
            e.setGeloescht(true);
          }
        } else {
          if(!e.isMarkiert()) e.setGeloescht(true);
        }
      } // end of for
      step();
    } // end of while
    
  } // end of for
  

  
  /**
  * Hilfsmethode zum Dijkstra Algorithmus.
  * Findet den Knoten, der die kleinste Entfernung vom Start hat und noch nicht markiert ist
  *
  * @return  Knoten   Der gesuchte minimale Knoten
  */
  public Knoten findeKleinstenKnoten() {
    Knoten minKnoten = null;
    ArrayList<Knoten> knoten = g.getAlleKnoten();
    for (Knoten k: knoten) {
      if (!k.isMarkiert() && k.isBesucht() && (minKnoten == null || minKnoten.getDoubleWert() > k.getDoubleWert())) {
        minKnoten = k;
      } // end of if-else
    } // end of for
    return minKnoten;
  }
  // Ende Methoden
  
}

