package algorithmen;

import java.util.ArrayList;


import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_Kurzsichtig extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_Kurzsichtig(GraphPlotter gp) {
    super(gp);
  }
  
  public  String getBezeichnung() {
    return "Greedy-MST";
  }

  // Ende Attribute
  
  //    Knoten k = gp.getGraph().getKnoten("K"+stepFaerber);
//    if(k!=null) {
//      gp.faerbeKnoten(k, "lightgreen");
//      k.setMarkiert(true);
//      gp.faerbeMinimaleKanteVonKnoten(k);
//      jTextArea1.setText(gp.getGraph().toString());
//    }
//    else {
//      jTextArea1.setText("Alle Knoten wurden bereits durchlaufen!\nDie Summe der Kantengewichte betraegt: "+gp.getSummeDerKantengewichte());
//    }
//    jPanel1.repaint();
  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
    ArrayList<Knoten> knoten = g.getAlleKnoten();
    for (Knoten aktuellerKnoten: knoten ) {
      aktuellerKnoten.setMarkiert(true);
      
      Kante e = findeMinimaleKanteVonKnoten(aktuellerKnoten);
      if (e!=null && !e.isMarkiert()) {
        e.setMarkiert(true);
      }
      step();
    } // end of for
  }
  
  /**
     * Hilfsmethode zum kurzsichtigen Algorithmus.
     * Findet die minimale Kante von einem gegebenen StartKnoten.
     *
     * @param  Knoten startKnoten  Der StartKnoten, von dem aus die Adjazenzliste durchlaufen wird
     * @return  Kante   Die gesuchte minimale Kante
     */
    public Kante findeMinimaleKanteVonKnoten (Knoten startKnoten) {
        ArrayList<Kante> kanten = g.getAusgehendeKanten(startKnoten);
        if (kanten.size()==0) return null;
        else {
            double min = Double.MAX_VALUE;
      
            Kante minKante = null;
            for (Kante k: kanten) {
                if (k.getGewicht() < min) {
                  min = k.getGewicht();  
                  minKante = k;
                }
            }
            return minKante;
        }
    }
  // Ende Methoden
  
}

