package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_Prim extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_Prim(GraphPlotter gp) {
    super(gp);
  }
  
  // Ende Attribute
    public  String getBezeichnung() {
    return "Prim-MST";
  }

   public Path getBspPath() {
    return Paths.get("beispielgraphen","03_minimalspanningtree");
  }

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
    ArrayList<Knoten> knoten = g.getAlleKnoten();
    if(knoten.size()==0) return;
    knoten.get(0).setMarkiert(true);
    step();
    
    for (int i=0; i< knoten.size()-1; i++) {
      Kante e = findeMinimaleKanteVonMarkiertZuUnmarkiert();
      if (e!=null) {
        e.setMarkiert(true);
        e.getStart().setMarkiert(true);
        e.getZiel().setMarkiert(true);
      }
      step();
    } // end of for
  }
  
  /**
     * Hilfsmethode zum kurzsichtigen Algorithmus.
     * Findet die minimale Kante von einem gegebenen StartKnoten.
     *
     * @param  Knoten startKnoten  Der StartKnoten, von dem aus die Adjazenzliste durchlaufen wird
     * @return  Kante   Die gesuchte minimale Kante
     */
    public Kante findeMinimaleKanteVonMarkiertZuUnmarkiert () {
        ArrayList<Kante> kanten = g.getAlleKanten();
        if (kanten.size()==0) return null;
        else {
            double min = Double.MAX_VALUE;
      
            Kante minKante = null;
            for (Kante k: kanten) {
                if (k.getGewicht() < min && k.getStart().isMarkiert()!= k.getZiel().isMarkiert()) {
                  min = k.getGewicht();  
                  minKante = k;
                }
            }
            return minKante;
        }
    }
  // Ende Methoden
  
}

