package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_TSPGreedy2 extends GraphAlgo {

  // Anfang Attribute
  public GraphAlgo_TSPGreedy2(GraphPlotter gp) {
    super(gp);
  }
  
  public String getBezeichnung() {
    return "TSP-Greedy 2";
  }

  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","05_travelingsalesman");
  }
   // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
     Knoten start = this.getStartKnoten();
     
     ArrayList<Kante> kanten = g.getAlleKanten();
     ArrayList<Kante> kantenSortiert = new ArrayList<Kante>();
     for(Kante k: kanten){
       int i;
       for(i=0; i< kantenSortiert.size(); i++) {
          if(k.getGewicht() <= kantenSortiert.get(i).getGewicht()) break;
       }
       kantenSortiert.add(i, k);
     }
     
     for(Kante k: kantenSortiert) {
        for (Knoten v: g.getAlleKnoten()) v.setBesucht(false);
       if(!findeWeg(k.getStart(), k.getZiel()) && bestimmeGrad(k.getStart())!=2 && bestimmeGrad(k.getZiel())!=2) {
         k.setMarkiert(true);
       } else {
         k.setMarkiert(true);
         boolean alleZwei=true;
         for(Knoten v: g.getAlleKnoten()) {
           if(bestimmeGrad(v) != 2) {
               alleZwei = false;
           }
        }
        if(alleZwei) {
            break;
        }
        k.setMarkiert(false);
       }
       step(); 
     } // end of for
     step();
    }
    
    
   private int bestimmeGrad(Knoten k) {
       ArrayList<Kante> kantenV = g.getAusgehendeKanten(k);
       int anzM = 0;
        for(Kante k2: kantenV) {
            if(k2.isMarkiert()) anzM++;
         }
         return anzM;
        }

    /**
  * Hilfsmethode zum kurzsichtigen Algorithmus.
  * Findet die minimale Kante von einem gegebenen StartKnoten.
  *
     * @param  Knoten startKnoten  Der StartKnoten, von dem aus die Adjazenzliste durchlaufen wird
  * @return  Kante   Die gesuchte minimale Kante
  */
  public boolean findeWeg(Knoten s, Knoten z) {
    if(s==z) return true;
    
    boolean gefunden = false;
    s.setBesucht(true);
    ArrayList<Kante> kanten = g.getAusgehendeKanten(s);
    for (Kante k: kanten) {
      if(k.isMarkiert()) { // Nur markierte Kanten zaehlen als Weg
        if(!k.getAnderesEnde(s).isBesucht()) {
          if(findeWeg(k.getAnderesEnde(s), z)) return true;
        }
      }
    } // end of for
    return false;
  }
     
     
  public String getInfo() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    double laenge = 0;
    int anz =0;
    for(Kante k:kanten) {
        if(k.isMarkiert()) {
            laenge+=k.getGewicht();
            anz++;
        }
    }
    
    return "Weglänge ("+anz+" von "+g.getAnzahlKnoten()+" Kanten): "+laenge+" km.";
}
  
  
  // Ende Methoden
  
}

