package algorithmen;

import java.util.ArrayList;
import java.nio.file.*;

import graph.*;

/**
  *
  * description
  *
  * @version 1.0 from 26.04.2019
  * @author 
  */

public class GraphAlgo_TSPVollstaendig extends GraphAlgo {

  private ArrayList<Kante> besteLoesung = null;
  private double besteStrecke = Double.MAX_VALUE;
  private Knoten start;
    
  // Anfang Attribute
  public GraphAlgo_TSPVollstaendig(GraphPlotter gp) {
    super(gp);
  }
  
  public String getBezeichnung() {
    return "TSP-Vollständig";
  }

  
  public Path getBspPath() {
    return Paths.get("beispielgraphen","05_travelingsalesman");
  }
   // Ende Attribute
  

  // Anfang Methoden
  public void fuehreAlgorithmusAus() {
     start = this.getStartKnoten();
     probiere(start);
     for(Kante k: besteLoesung) {
         k.setMarkiert(true);
      }
      step();
  } // end of for
  
  public void probiere(Knoten akt) {
     boolean fertig = true;
     akt.setMarkiert(true);
     step();

     for(Knoten k: g.getAlleKnoten()) {
       if(!k.isMarkiert()) {
         fertig = false;
        }
     }
     if(fertig) {
      
       g.getKante(akt,start).setMarkiert(true);
       step();
       ArrayList<Kante> kanten = g.getAlleKanten();
       ArrayList<Kante> gewaehlteKanten = new ArrayList<Kante>();
       double laenge = 0;
       for(Kante k:kanten) {
          if(k.isMarkiert()) {
              laenge+=k.getGewicht();
              gewaehlteKanten.add(k);
            }
       }   
       if(laenge < besteStrecke) {
           besteStrecke = laenge;
           besteLoesung = gewaehlteKanten;
       }
       g.getKante(akt,start).setMarkiert(false);
       akt.setMarkiert(false);
       step();
       return;
    }
           
    
     ArrayList<Kante> kanten = g.getAusgehendeKanten(akt);
     for(Kante k: kanten) {
        if(!k.getAnderesEnde(akt).isMarkiert()) {
          k.setMarkiert(true);
          probiere(k.getAnderesEnde(akt));
          k.setMarkiert(false);
        }
     }
     
     akt.setMarkiert(false);
     step(); 
     return;
    
      
    
  }
  
  public String getInfo() {
    ArrayList<Kante> kanten = g.getAlleKanten();
    double laenge = 0;
    int anz =0;
    for(Kante k:kanten) {
        if(k.isMarkiert()) {
            laenge+=k.getGewicht();
            anz++;
        }
    }
    
    return "Weglänge ("+anz+" von "+g.getAnzahlKnoten()+" Kanten): "+laenge+" km. Bisher beste Gesamtlösung "+this.besteStrecke+" km";
}
  
  
  // Ende Methoden
  
}

