package algorithmen;

import java.awt.*;
import java.awt.event.*;
import java.util.Arrays;
import javax.swing.*;
import javax.swing.event.*;
import java.io.File;
import java.nio.file.*;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.handler.mxKeyboardHandler;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource.mxIEventListener;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxMultiplicity;

import graph.*;



/**
 *  Die Coloring-Algorith-Test-GUI
 * 
 * @author Dirk Zechnall
 * @version 23.10.2015 (v4.0)
 */
public class GraphenalgorithmenGUI extends JFrame {
    // Anfang Attribute
  private GraphPlotter gp;
  private JScrollPane gpScrollPane = new JScrollPane(gp);
  private ArrayList<Class> algos;
  private GraphAlgo aktAlgo=null;
  private JLabel jLCopyright = new JLabel();
  private JLabel jBCopyright2 = new JLabel();

  private String guiTitle;


  private JFileChooser jFileChooser1 = new JFileChooser();
 
  private JButton jButtonDateiEinlesen = new JButton();
  private JComboBox jCBAlgorithmus = new JComboBox();
  private JComboBox jCBFiles = new JComboBox();
  private JButton jButtonStep = new JButton();
  private JButton jButtonDo = new JButton();
  private JButton jButtonReset = new JButton();
  private JSlider jSSpeed = new JSlider();

  private JToggleButton jToggleButtonBild = new JToggleButton();

  
  private Path   dateiName;
  private String dateiTitel;
  private Path   workingDirectory;
    // Ende Attribute

  public GraphenalgorithmenGUI() { 
    // Frame-Initialisierung
    super("Graphenalgorithmen");
    guiTitle = this.getTitle();
    int frameWidth = 1000; 
    int frameHeight = 602;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(true);
    Container cp = getContentPane();
    cp.setLayout(new BorderLayout());
    
    // Graphkomponenten
    
    gp = new GraphPlotter();
    gp.setFarben(new String[]{"lightgrey","red","green","yellow", "blue", "purple", "pink", "darkgrey"});
    gp.setBildAnzeigen(true);
    
    gp.getGraphComponent().getGraphControl().addMouseListener(new MouseAdapter()
    {
    public void mouseReleased(MouseEvent e)
    {
    graphPlotter_mouseReleased(e);
    }
    });
    gp.setPreferredSize(new Dimension(500,340));
    gp.setOpaque(true);
    gp.setVisible(true);
    gp.setBackground(new Color(0xC0C0C0));
    gp.setBounds(8, 8, 521, 353);
    gp.setBorder(BorderFactory.createEmptyBorder(3,3,3,3));
    gpScrollPane.setBounds(8, 8, 521, 353);
    cp.add(gp,BorderLayout.CENTER);
    
    
    // Meldungen und Copyright
    JPanel bottom = new JPanel();
    bottom.setBorder(BorderFactory.createEmptyBorder(2,3,2,3));
    bottom.setLayout(new BoxLayout(bottom,  BoxLayout.  Y_AXIS));
    
    
    jLCopyright.setText("(CC3.0 BY-NC-SA) Fobi RP-KA (D. Zechnall) / ZPG IMP (T. Schaller) - V2.0");
    jLCopyright.setToolTipText("CC-Lizenz-Info: https://creativecommons.org/licenses/by/3.0/de/");
    jLCopyright.setFont(new Font("Dialog", Font.PLAIN, 10));
    jLCopyright.setOpaque(true);
    jLCopyright.setAlignmentX(Component.CENTER_ALIGNMENT);
    bottom.add(jLCopyright);
    jBCopyright2.setText("unter Verwendung der JGraph-Bibliothek (Lizenzinformation)");
    jBCopyright2.setToolTipText("für Lizenzinformationen bitte anklicken");
    jBCopyright2.setFont(new Font("Dialog", Font.PLAIN, 10));
    jBCopyright2.setOpaque(true);
    jBCopyright2.setAlignmentX(Component.CENTER_ALIGNMENT);
    jBCopyright2.addMouseListener(new MouseListener() { 
    public void mouseClicked(MouseEvent e) { 
    jButtonLicence_ActionPerformed(e);
    }
    public void mouseExited(MouseEvent e) { }
    public void mouseEntered(MouseEvent e) { }
    public void mousePressed(MouseEvent e) { }
    public void mouseReleased(MouseEvent e) { }

    });
    bottom.add(jBCopyright2);
    cp.add(bottom,BorderLayout.PAGE_END);
    
    // Buttonsleiste rechts
    JPanel buttonBox = new JPanel();
    buttonBox.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 20));
    GridBagLayout gl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.insets = new Insets(10,0,0,0);
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.weightx = 1.0;
    buttonBox.setLayout(gl);
    
    // Algorithmus wählen
    JLabel l1 = new JLabel();
    l1.setText("Algorithmus:");
    buttonBox.add(l1,gbc);
    
    jCBAlgorithmus.addItemListener(new ItemListener() {
    public void itemStateChanged(ItemEvent evt) {
    jCBAlgorithmus_ItemStateChanged(evt);
    }
    });
    gbc.gridy = 1;
    buttonBox.add(jCBAlgorithmus,gbc);
    gbc.gridy = 2;
    buttonBox.add(Box.createRigidArea(new Dimension(10,30)),gbc);
    
    
    // Beispieldatei
    l1 = new JLabel();
    l1.setText("Beispielgraph:");
    gbc.gridy = 3;
    buttonBox.add(l1,gbc);
    
    jButtonDateiEinlesen.setText("Verzeichnis wählen ...");
    jButtonDateiEinlesen.setToolTipText("Verzeichnis wählen");
    jButtonDateiEinlesen.setMargin(new Insets(2, 2, 2, 2));
    jButtonDateiEinlesen.addActionListener(new ActionListener() { 
    public void actionPerformed(ActionEvent evt) { 
    jButtonDateiEinlesen_ActionPerformed(evt);
    }
    });
    gbc.gridy =4;
    buttonBox.add(jButtonDateiEinlesen,gbc);
    
    jCBFiles.addItemListener(new ItemListener() {
    public void itemStateChanged(ItemEvent evt) {
    jCBFiles_ItemStateChanged(evt);
    }
    });
    gbc.gridy =5;
    buttonBox.add(jCBFiles,gbc);
    
    gbc.gridy =6;
    buttonBox.add(Box.createRigidArea(new Dimension(10,20)),gbc);
    
    
    jToggleButtonBild.setBounds(567, 150, 90, 25);
    jToggleButtonBild.setText("Bild an/aus");
    jToggleButtonBild.setSelected(true);
    jToggleButtonBild.setBackground(Color.GRAY);
    jToggleButtonBild.setFont(new Font("Dialog", Font.BOLD, 10));
    jToggleButtonBild.addActionListener(new ActionListener() {
    public void actionPerformed(ActionEvent evt) {
    jToggleButtonBild_ActionPerformed(evt);
    }
    });
    gbc.gridy =7;
    buttonBox.add(jToggleButtonBild,gbc);
    gbc.gridy = 8;
    buttonBox.add(Box.createRigidArea(new Dimension(10,20)),gbc);
    
    // Ausfürhungsbefehle
    l1 = new JLabel();
    l1.setText("Ausführung:");
    gbc.gridy = 9;
    buttonBox.add(l1,gbc);
    jButtonStep.setBounds(544, 240, 113, 25);
    jButtonStep.setText("Schritt");
    jButtonStep.setMargin(new Insets(2, 2, 2, 2));
    jButtonStep.addActionListener(new ActionListener() { 
    public void actionPerformed(ActionEvent evt) { 
    jButtonStep_ActionPerformed(evt);
    }
    });
    gbc.gridy =10;
    
    buttonBox.add(jButtonStep,gbc);
    
    jButtonDo.setBounds(544, 270, 113, 25);
    jButtonDo.setText("Ausführen");
    jButtonDo.setMargin(new Insets(2, 2, 2, 2));
    jButtonDo.addActionListener(new ActionListener() { 
    public void actionPerformed(ActionEvent evt) { 
    jButtonDo_ActionPerformed(evt);
    }
    });
    gbc.gridy =11;
    
    buttonBox.add(jButtonDo,gbc);    
    
    
    jButtonReset.setBounds(544, 300, 113, 25);
    jButtonReset.setText("Reset");
    jButtonReset.setMargin(new Insets(2, 2, 2, 2));
    jButtonReset.addActionListener(new ActionListener() { 
    public void actionPerformed(ActionEvent evt) { 
    jButtonReset_ActionPerformed(evt);
    }
    });
    gbc.gridy =12;
    buttonBox.add(jButtonReset,gbc);
    
    gbc.weighty =1.0;
    gbc.gridy = 13;
    buttonBox.add(Box.createGlue(), gbc);   
    
    jSSpeed.setMinimum(0);
    jSSpeed.setMaximum(500);
    jSSpeed.setValue(100);
    jSSpeed.setMinorTickSpacing(25);
    jSSpeed.setMajorTickSpacing(100);
    jSSpeed.setPaintTicks(true);
    jSSpeed.setPaintLabels(true);
    jSSpeed.addChangeListener(new ChangeListener() { 
    public void stateChanged(ChangeEvent evt) { 
    jSSpeed_StateChanged(evt);
    }
    });

    
    gbc.gridy = 14;
    gbc.weighty = 0.0;
    buttonBox.add(jSSpeed,gbc);
    
    
    cp.add(buttonBox,BorderLayout.LINE_END); 
    
    
    // Ende Komponenten
    workingDirectory = Paths.get("beispielgraphen");
    
    
    String[] entries = new File( "algorithmen" ).list();
    this.algos = new ArrayList<Class>();
    try     {
      for (String name : entries) {
        if (name.startsWith("GraphAlgo_") && name.endsWith(".class")){
          algos.add(Class.forName("algorithmen."+name.split(Pattern.quote("."))[0]));
          GraphAlgo a = ((GraphAlgo)(algos.get(algos.size()-1)).getDeclaredConstructor(GraphPlotter.class).newInstance(gp));       
          
          System.out.println("Algorithmus: "+a.getBezeichnung()+" geladen.");     
          jCBAlgorithmus.addItem(a.getBezeichnung());
        }
      } // end of for
    } catch(Exception e)   
    {
      System.out.println("Exception " + e);
    } 
    
    this.aktAlgo = null;
    
    
    jFileChooser1.setCurrentDirectory(workingDirectory.toFile());
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setVisible(true);
  } // end of public GraphGUI

    // Anfang Methoden
    //Testzwecke
  public GraphPlotter getGraphPlotter(){
    return gp;
  }

  public void ladeDatei (Path name, String title) {
    if(gp.csvDateiEinlesen(name)) {
      this.setTitle(guiTitle+" - "+title);
      reset();
      gp.updateMxGraph();
      gp.setInfoText("Datei erfolgreich eingelesen!");
      dateiName = name;
      dateiTitel = title;
    }
    else gp.setInfoText("Fehler beim Einlesen der Datei!");
  }

  
  public void graphPlotter_mouseReleased(MouseEvent e) {
    if (gp.getSelectedKante()!= null)
    {
      gp.setInfoText("Kante mit Gewicht "+gp.getSelectedKante().getGewicht()+" ist selektiert!\n");
    }
    if (gp.getSelectedKnoten()!= null)
    {
      gp.setInfoText("Knoten Nr. "+gp.getGraph().getNummer(gp.getSelectedKnoten())+" mit Wert "+gp.getSelectedKnoten().getDoubleWert()+" ist selektiert!\n");
    }
  }

  private void reset() {
    if(aktAlgo != null && aktAlgo.isAlive()) aktAlgo.stop();  
    gp.getGraph().initialisiereAlleKnoten();
    gp.getGraph().initialisiereAlleKanten();
    gp.updateMxGraph();
    gp.setInfoText(gp.getGraph().toString());
    jButtonStep.setEnabled(true);
    jButtonDo.setEnabled(true);
    this.aktAlgo = null;
  }



  public void jButtonDateiEinlesen_ActionPerformed(ActionEvent evt) {
    readDirectory(jFileChooser1_openFile().toPath());
  } // end of jButtonDateiEinlesen_ActionPerformed

  public File jFileChooser1_openFile() {
    jFileChooser1.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    jFileChooser1.setAcceptAllFileFilterUsed(false);
    if (jFileChooser1.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
      return jFileChooser1.getSelectedFile();
    } else {
      return null;
    }
  }



  public void jButtonStep_ActionPerformed(ActionEvent evt) {
    if (aktAlgo == null ) {
      System.out.println("null");
      if(jCBAlgorithmus.getSelectedIndex() >= 0) {
        try{
          aktAlgo = ((GraphAlgo)(algos.get(jCBAlgorithmus.getSelectedIndex()).getDeclaredConstructor(GraphPlotter.class).newInstance(gp))); 
          aktAlgo.setStartKnoten(gp.getSelectedKnoten());
          aktAlgo.setSpeed(510-jSSpeed.getValue());
        } catch( Exception e) {
          System.out.println(e);
        }
        aktAlgo.start();
      }
    } else {
      if(aktAlgo.isAlive()) {
        
        aktAlgo.setWaitforclick(false);
        gp.setInfoText(aktAlgo.getInfo());
        
      } else {
        gp.setInfoText("Algorithmus ist beendet. "+aktAlgo.getInfo());
        jButtonStep.setEnabled(false);
        jButtonDo.setEnabled(false);
      } // end of if-else
    } // end of if-else
    try{
      Thread.sleep(100);
    } catch(Exception e) {}
    
    if (!aktAlgo.isAlive()) {
      gp.setInfoText("Algorithmus ist beendet"+aktAlgo.getInfo());
      jButtonStep.setEnabled(false);
      jButtonDo.setEnabled(false);
    }
  } // end of jButtonStepColoring_ActionPerformed

  public void jButtonDo_ActionPerformed(ActionEvent evt) {
    if (aktAlgo == null ) {
      if(jCBAlgorithmus.getSelectedIndex() >= 0) {
        try{
          aktAlgo = ((GraphAlgo)(algos.get(jCBAlgorithmus.getSelectedIndex()).getDeclaredConstructor(GraphPlotter.class).newInstance(gp )));       
          aktAlgo.setStartKnoten(gp.getSelectedKnoten());
          aktAlgo.setSpeed(510-jSSpeed.getValue());
        } catch( Exception e) {
          System.out.println(e);
        }
        
        aktAlgo.setStepping(false);
        aktAlgo.start();
      }
    } else {
      if(aktAlgo.isAlive()) {
        aktAlgo.setStepping(false);
        aktAlgo.setWaitforclick(false);
        gp.setInfoText(aktAlgo.getInfo());
        
      } else {
        gp.setInfoText("Algorithmus ist beendet. "+aktAlgo.getInfo());
        jButtonStep.setEnabled(false);
        jButtonDo.setEnabled(false);
      } // end of if-else
    } // end of if-else
    
    gp.setInfoText(aktAlgo.getInfo());
    jButtonDo.setEnabled(false);
    jButtonStep.setEnabled(false);
    if (!aktAlgo.isAlive()) {
      gp.setInfoText("Algorithmus ist beendet. "+aktAlgo.getInfo());
      jButtonStep.setEnabled(false);
      jButtonDo.setEnabled(false);
    }
  } // end of jButtonStepColoring_ActionPerformed

  public void jButtonReset_ActionPerformed(ActionEvent evt) {
    if(jButtonDo.isEnabled() || aktAlgo == null || !aktAlgo.isAlive()){
      reset();
    } else {
      aktAlgo.setStepping(true);
      jButtonDo.setEnabled(true);
      jButtonStep.setEnabled(true);
    }
  } // end of jButtonReset_ActionPerformed


  public void jToggleButtonBild_ActionPerformed(ActionEvent evt) {
    gp.setBildAnzeigen(jToggleButtonBild.isSelected()); 
  } // end of jToggleButtonBild_ActionPerformed
  
  public void jCBAlgorithmus_ItemStateChanged(ItemEvent evt) {
    try     {
      GraphAlgo choosedAlgo = ((GraphAlgo)(algos.get(jCBAlgorithmus.getSelectedIndex()).getDeclaredConstructor(GraphPlotter.class).newInstance(gp ))); 
      Path bspDir = choosedAlgo.getBspPath();
      if(bspDir != null) readDirectory(bspDir); 
    } catch(Exception e)   
    {
      System.out.println("Exception " + e);
    } 
    
  }
  
  public void jSSpeed_StateChanged(ChangeEvent evt) {
      if(aktAlgo != null) 
        aktAlgo.setSpeed(510-jSSpeed.getValue());
    }
  
  private void readDirectory(Path dir) {
    System.out.println(dir.toString());
    workingDirectory = dir; 
    String[] entries = workingDirectory.toFile().list();
    jCBFiles.removeAllItems();
    try     {
      for (String name : entries) {
        if (name.endsWith(".csv")){
          jCBFiles.addItem(name);
        }
      } // end of for
    } catch(Exception e)   
    {
      System.out.println("Exception " + e + e.getStackTrace());
    } 
  }

  
  public void jCBFiles_ItemStateChanged(ItemEvent evt) {
    String filename = (String) jCBFiles.getSelectedItem();
    if(filename != null) {
      Path datei = Paths.get(workingDirectory.toString(),filename);
      ladeDatei(datei, filename);
    }
    
  }  
  
  
  public void jButtonLicence_ActionPerformed(MouseEvent evt) {
    LicenceInfo i = new LicenceInfo();
}

    // Ende Methoden
  
  public static void main(String[] arg) {
    new GraphenalgorithmenGUI();
  }
    

} // end of class SimulatorGUI
