package graph;

/**
 * Die Klasse Kante beschreibt die Datenstruktur einer Kante, bestehend aus Startknoten, Gewicht und Zielknoten.
 * Da Kanten innerhalb von Adjazenzlisten und -Matrizen repraesentiert werden, ist diese Klasse eigentlich unnoetig!
 * Sie wurde zum Zweck der Vereinfachung - sozusagen als Zwischenspeicher von Kanten - eingefuehrt.
 * Auch soll sie das Kantengewicht verwalten und Aufschluss darueber geben, ob sie gefaerbt ist oder nicht.
 * 
 * In der Datei "LI1_Hintergrund.odt" werden didaktische Ueberlegungen zu dieser Klasse gefuehrt.
 * 
 * @author  Dirk Zechnall
 * @version 23.10.2015 (v4.0)
 */
public class Kante
{
    private Knoten start;
    private Knoten ziel;
    private double gewicht;
    private boolean markiert = false;
    private boolean geloescht = false;
    private int farbe = -1;

    /**
     * Der Konstruktor erstellt eine neue Kante mit Start- und Zielknoten und Kantengewicht.
     * Die Kante ist zu Beginn ungefaerbt.
     *
     * @param  Knoten neuerStart  Der neue Startknoten
     * @param  Knoten neuerZiel  Der neue Zielknoten
     * @param  double neuesGewicht  Das neue Kantengewicht
     */
    public Kante (Knoten neuerStart, Knoten neuerZiel, double neuesGewicht) {
        gewicht = neuesGewicht;
        start = neuerStart;
        ziel = neuerZiel;
    }

    /**
     * Die Methode init initialisiert die Kantenfaerbung (auf unmarkiert)
     */
    protected void init() {
        markiert = false;
        geloescht = false;
    }

    /**
     * Setzt das Gewicht der Kante
     *
     * @param  double neuesGewicht  Das neu zu setzende Gewicht
     */
    public void setGewicht(double neuesGewicht) {
        gewicht = neuesGewicht;
    }

    /**
     * Gibt das Gewicht der Kante zurueck
     * 
     * @return  double
     */
    public double getGewicht() {
        return gewicht;
    }

    /**
     * Setzt den Startknoten der Kante
     *
     * @param  Knoten neuerSatrtKnoten  Der neu zu setzende Startknoten
     */
    public void setStart(Knoten neuerSatrtKnoten) {
        start = neuerSatrtKnoten;
    }

    /**
     * Gibt den Startknoten der Kante zurueck
     * 
     * @return  Knoten
     */
    public Knoten getStart() {
        return start;
    }

    /**
     * Setzt den Zielknoten der Kante
     *
     * @param  Knoten neuerZielKnoten  Der neu zu setzende Zielknoten
     */
    public void setZiel(Knoten neuerZielKnoten) {
        ziel = neuerZielKnoten;
    }

    /**
     * Gibt den Zielknoten der Kante zurueck
     * 
     * @return  Knoten
     */
    public Knoten getZiel() {
        return ziel;
    }
  
  
    /**
     * Gibt Knoten am anderen Ende der Kante zurueck
     * @param Knoten k Knoten am ersten Ende der Kante
     * @return  Knoten
     */
    public Knoten getAnderesEnde(Knoten k) {
      if (k == start) return ziel;
      if (k == ziel) return start;
      return null;
    }

    /**
     * Setzt das GefaerbtAttribut der Kante
     *
     * @param  boolean wert  Der neu zu setzende GefaerbtWert
     */
    public void setMarkiert(boolean wert) {
        markiert = wert;
    }

    /**
     * Gibt den GefaerbtWert der Kante zurueck
     * 
     * @return  boolean
     */
    public boolean isMarkiert() {
        return markiert;
    }
  
  
    /**
     * Setzt das GefaerbtAttribut der Kante
     *
     * @param  boolean wert  Der neu zu setzende GefaerbtWert
     */
    public void setGeloescht(boolean wert) {
        geloescht = wert;
    }

    /**
     * Gibt den GefaerbtWert der Kante zurueck
     * 
     * @return  boolean
     */
    public boolean isGeloescht() {
        return geloescht;
    }

    /**
     * Gibt zurueck, in welcher Farbe die Kante gezeichnet werden soll.
     * Ist die Farbe nicht gesetzt, dann wird eine unmarkierte Kante in Farbe 1 
     * und eine markierte in Farbe 2 gezeichnet.
     * @return int 
     */
    public int getFarbe() {
      if(farbe == -1) {
        if(geloescht) return 2;
        if(markiert) return 1;
        return 0;
      }
      return farbe;
    }
  
    /**
   * Setzt die Farbe auf einen bestimmten Farbindex
   * @param int farbe Index der Farbe (0-19)
   */
    public void setFarbe(int farbe) {
      if(farbe>=0 && farbe < 20)
        this.farbe = farbe;
    }
  
    /**
   * Setzt die Farbe auf die Standardfarbgebung zur�ck
   */
  
    public void setStandardFarbe() {
      farbe = -1;
    }

    /**
     * Die Methode ueberschreibt die Methode toString() und gibt die String-Raepraesentation einer Kante zurueck
     * 
     * @return      String-Raepraesentation der Kante
     */
    @Override
    public String toString() {
        return " --("+gewicht+")--> ";
    }
}
