package graph;

/**
 * Diese Klasse Knoten definiert einen Knoten.
 * Knoten haben einen Namen, einen Wert fuer Farb- oder sonstige Codierungszwecke
 * und weitere Attribute die Markierungen (istBesucht, ...) speichern.
 * 
 * @author Dirk Zechnall
 * @version 23.10.2015 (v4.0)
 */
public class Knoten
{
    private double wert; // wird z.B. fuer den Colorierungs-Algorithmus verwendet - speichert da die Farben (codiert als Zahlen)
    private boolean istMarkiert = false;
    private boolean istBesucht = false; //wird fuer die Tiefensuche benoetigt
    private boolean istBeendet = false; //wird fuer die Tiefensuche benoetigt
    private int x;
    private int y;
    private int farbe = -1;
    /**
     * Der Konstruktor erstellt einen neuen Knoten mit einem neuen Namen
     *
     * @param  String neuerName  Der neue Knotenname
     */
    public Knoten(int x, int y) {
        this.x = x;
        this.y = y;
        wert = 0;
    }

    /**
     * Der Konstruktor erstellt einen neuen Knoten mit einem neuen Namen
     *
     * @param  String neuerName  Der neue Knotenname 
     * @param  int neuerWert  Der neue Wert des Knotens (Farbcodierung, ...)
     */
    public Knoten(int x, int y, double neuerWert) {
        this.x = x;
        this.y = y;
        wert = neuerWert;
    }

    /**
     * Die Methode init initialisiert alle Attribute - außer dem Knotennamen
     */
    protected void init() {
        wert = 0.0;
        farbe = -1;
        istMarkiert = false;
        istBesucht = false;
        istBeendet = false;
    }

    /**
     * Setzt den Wert beim Knoten
     *
     * @param  int neuerWert  Der neu zu setzende Wert
     */
    public void setWert(double neuerWert) {
        wert = neuerWert;
    }

    /**
     * Gibt den Wert vom Knoten zurueck
     * 
     * @return  int
     */
    public int getIntWert() {
        return (int) wert;
    }
    
    public double getDoubleWert() {
        return wert;
    }



    /**
     * Setzt das Markiertattribut vom Knoten
     *
     * @param  boolean markiert  Der neu zu setzende Markiertwert
     */
    public void setMarkiert(boolean markiert) {
        istMarkiert = markiert;
    }

    /**
     * Gibt den Markiertwert vom Knoten zurueck
     * 
     * @return  boolean
     */
    public boolean isMarkiert() {
        return istMarkiert;
    }

    /**
     * Setzt das Besuchtattribut vom Knoten
     *
     * @param  boolean markiert  Der neu zu setzende Besuchtwert
     */
    public void setBesucht(boolean markiert) {
        istBesucht = markiert;
    }

    /**
     * Gibt den Besuchtwert vom Knoten zurueck
     * 
     * @return  boolean
     */
    public boolean isBesucht() {
        return istBesucht;
    }

    /**
     * Setzt das Beendetattribut vom Knoten
     *
     * @param  boolean markiert  Der neu zu setzende Beendetwert
     */
    public void setBeendet(boolean markiert) {
        istBeendet = markiert;
    }

    /**
     * Gibt den Beendetwert vom Knoten zurueck
     * 
     * @return  boolean
     */
    public boolean isBeendet() {
        return istBeendet;
    }
  
    /**
   * Gibt den Index der Farbe des Knoten zurück.
   * Standardmäßig hängt die Farbe von den Attributen markiert, besucht und beendet ab.
   * Durch Setzen der Farbe kann die Farbe gezielt gesetzt werden.
   * @return int
   */
    public int getFarbe() {
      if (farbe == -1) {
        int f = 0;
        if(istMarkiert) {
          f += 1;
        }
        if(istBesucht) {
          f += 2;
        }
        if(istBeendet) {
          f += 4;
        }
        return f;
      }
      return farbe;
    }
  
  /**
   * Setzt den Index der Farbe des Knoten.
   * Standardmäßig hängt die Farbe von den Attributen markiert, besucht und beendet ab.
   * Durch Setzen der Farbe kann die Farbe gezielt gesetzt werden.
   * @param int farbe Index der Farbe (0-19)
   */
    
    public void setFarbe(int farbe) {
      this.farbe = farbe;
    }

    public int getX() {
        return x;
    }
    public int getY() {
        return y;
    }
    public void setX(int x) {
        this.x = x;
    }
    public void setY(int y) {
        this.y = y;
    }

    /**
     * Die Methode ueberschreibt die Methode toString() und gibt die String-Raepraesentation eines Knotens zurueck
     * 
     * @return      String-Raepraesentation des Knotens
     */
    @Override
    public String toString() {
        return "["+wert+","+istMarkiert+","+istBesucht+","+istBeendet+"]";
    }
}
