/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

class Bild
extends JComponent {
    Datei file;
    BMPHexEditor parent;
    Image image;
    int zoom = 100;
    int posx = 2;
    int posy = 2;

    public Bild(BMPHexEditor p) {
        this.parent = p;
        this.file = null;
        this.image = null;
        this.addMouseListener(new myMouseListener());
    }

    @Override
    public void paint(Graphics g) {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        if (this.file != null && this.image != null) {
            g.drawImage(this.image, 10, 10, this);
            g.drawRect(9, 9, this.image.getWidth(this) + 2, this.image.getHeight(this) + 2);
            if (this.posx >= 0 && this.posy >= 0) {
                g.setColor(Color.red);
                g.fillRect((this.posx + 1) * this.zoom / 100 + 10, (this.posy - 1) * this.zoom / 100 + 10, 4 * this.zoom / 100, this.zoom / 100);
                g.fillRect((this.posx - 1) * this.zoom / 100 + 10, (this.posy + 1) * this.zoom / 100 + 10, this.zoom / 100, 4 * this.zoom / 100);
                g.fillRect((this.posx - 6) * this.zoom / 100 + 10, (this.posy - 1) * this.zoom / 100 + 10, 4 * this.zoom / 100, this.zoom / 100);
                g.fillRect((this.posx - 1) * this.zoom / 100 + 10, (this.posy - 6) * this.zoom / 100 + 10, this.zoom / 100, 4 * this.zoom / 100);
            }
        }
    }

    public void setDatei(Datei file) {
        this.file = file;
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(file.getByteArray()));
            this.image = this.image.getScaledInstance(this.image.getWidth(this) * this.zoom / 100, this.image.getHeight(this) * this.zoom / 100, 1);
        }
        catch (Exception e) {
            this.image = null;
        }
    }

    public void setZoom(int z) {
        this.zoom = z;
        this.setDatei(this.file);
    }

    public void setPos(int x, int y) {
        this.posx = x;
        this.posy = y;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.file == null || this.image == null) {
            return new Dimension(300, 200);
        }
        return new Dimension(this.image.getWidth(this) + 20, this.image.getHeight(this) + 20);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    class myMouseListener
    implements MouseListener {
        myMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Bild.this.setPos((e.getX() - 10) * 100 / Bild.this.zoom + 1, (e.getY() - 10) * 100 / Bild.this.zoom + 1);
            Bild.this.parent.posClicked(Bild.this.posx, Bild.this.posy);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

