/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class Datei {
    int ib = 0;
    int iLength = 0;
    byte[] buffer = new byte[10000000];
    byte[] searchBuffer = new byte[10000000];
    String dateiname = "";
    String pfad = "";

    public Datei() {
        this.dateiname = "unbenannt.txt";
    }

    public Datei(File file) {
        try {
            FileInputStream inFile = new FileInputStream(file);
            this.iLength = inFile.read(this.buffer);
            for (int i = 0; i < this.iLength; ++i) {
                this.searchBuffer[i] = 0;
            }
            inFile.close();
            this.dateiname = file.getName();
            this.pfad = file.getAbsolutePath();
        }
        catch (Exception ex) {
            System.out.println("Fehler beim Datei\u00f6ffnen");
        }
    }

    public void saveFile(File file) {
        try {
            FileOutputStream outFile = new FileOutputStream(file);
            outFile.write(this.buffer, 0, this.iLength);
            outFile.close();
            this.dateiname = file.getName();
            this.pfad = file.getAbsolutePath();
        }
        catch (Exception ex) {
            System.out.println("Fehler beim Datei\u00f6ffnen");
        }
    }

    public String getFileName() {
        return this.dateiname;
    }

    public String getPathName() {
        return this.dateiname;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public String getByteBinary(int i) {
        String s = "";
        if (i < this.iLength) {
            byte c = this.buffer[i];
            s = Integer.toBinaryString(c);
            String p = "00000000";
            if (s.length() == 32) {
                s = s.substring(24);
            }
            s = p.substring(0, 8 - s.length()) + s;
        }
        return s;
    }

    public void setByteBinary(int i, String s) {
        if (i < this.iLength) {
            this.buffer[i] = (byte)Integer.parseInt(s, 2);
        }
    }

    public String getByteHex(int i) {
        String s = "";
        if (i < this.iLength) {
            byte c = this.buffer[i];
            s = Integer.toHexString(c);
            if ((s = s.toUpperCase()).length() < 2) {
                s = "0" + s;
            }
            if (s.length() == 8) {
                s = s.substring(6);
            }
        }
        return s;
    }

    public void setByteHex(int i, String s) {
        if (i < this.iLength) {
            this.buffer[i] = (byte)Integer.parseInt(s, 16);
        }
    }

    public String getByteChar(int i) {
        String s = "";
        if (i < this.iLength) {
            int j = 0xFF & this.buffer[i];
            s = "" + (char)j;
        }
        return s;
    }

    public void setByteChar(int i, char c) {
        if (i < this.iLength) {
            this.buffer[i] = (byte)c;
        }
    }

    public byte getByte(int i) {
        if (i < this.iLength) {
            return this.buffer[i];
        }
        return 0;
    }

    public int getUnsignedInt(int i) {
        return (this.buffer[i] & 0x7F) + (this.buffer[i] < 0 ? 128 : 0);
    }

    public int getDWORD(int i) {
        return this.getUnsignedInt(i) + 256 * (this.getUnsignedInt(i + 1) + 256 * (this.getUnsignedInt(i + 2) + 256 * this.getUnsignedInt(i + 3)));
    }

    public int getWORD(int i) {
        return this.getUnsignedInt(i) + 256 * this.getUnsignedInt(i + 1);
    }

    public byte getSearchByte(int i) {
        return this.searchBuffer[i];
    }

    public String getBinary() {
        String s = "";
        for (int i = 0; i < this.iLength; ++i) {
            s = s + this.getByteBinary(i);
        }
        return s;
    }

    public String getHex() {
        String s = "";
        for (int i = 0; i < this.iLength; ++i) {
            s = s + this.getByteHex(i);
        }
        return s;
    }

    public int getLength() {
        return this.iLength;
    }

    public void insertByte(int pos) {
        for (int i = this.iLength; i >= pos; --i) {
            this.buffer[i + 1] = this.buffer[i];
        }
        this.buffer[pos] = 0;
        ++this.iLength;
    }

    public void deleteByte(int pos) {
        for (int i = pos; i < this.iLength; ++i) {
            this.buffer[i] = this.buffer[i + 1];
        }
        this.buffer[this.iLength] = 0;
        --this.iLength;
    }

    public int search(String s, int modus) {
        int treffer;
        int i;
        byte[] searchBytes = new byte[50];
        int searchLength = 0;
        int laenge = 0;
        for (i = 0; i < this.iLength; ++i) {
            this.searchBuffer[i] = 0;
        }
        i = 0;
        if (modus == 1) {
            laenge = 8;
        }
        if (modus == 2) {
            laenge = 2;
        }
        if (modus == 3) {
            laenge = 1;
        }
        while (s.length() >= laenge) {
            if (modus == 1) {
                searchBytes[i] = (byte)Integer.parseInt(s.substring(0, 8), 2);
            }
            if (modus == 2) {
                searchBytes[i] = (byte)Integer.parseInt(s.substring(0, 2), 16);
            }
            if (modus == 3) {
                searchBytes[i] = (byte)s.charAt(0);
            }
            s = s.length() > laenge ? s.substring(laenge) : "";
            ++i;
        }
        searchLength = i;
        if (s.length() == 0) {
            treffer = 0;
            for (int j = 0; j < this.iLength - searchLength; ++j) {
                boolean gefunden = true;
                for (i = 0; i < searchLength && gefunden; ++i) {
                    if (this.buffer[j + i] == searchBytes[i]) continue;
                    gefunden = false;
                }
                if (!gefunden) continue;
                for (i = 0; i < searchLength; ++i) {
                    this.searchBuffer[j + i] = 1;
                }
                ++treffer;
            }
        } else {
            treffer = -1;
        }
        return treffer;
    }

    public int compare(File file) {
        int cLength = 0;
        byte[] cbuffer = new byte[10000000];
        int unterschiede = 0;
        for (int i = 0; i < this.iLength; ++i) {
            this.searchBuffer[i] = 0;
        }
        try {
            FileInputStream inFile = new FileInputStream(file);
            cLength = inFile.read(cbuffer);
            inFile.close();
            if (this.iLength < cLength) {
                cLength = this.iLength;
            }
            for (int i = 0; i < cLength; ++i) {
                if (this.buffer[i] == cbuffer[i]) continue;
                this.searchBuffer[i] = 1;
                ++unterschiede;
            }
        }
        catch (Exception ex) {
            System.out.println("Fehler beim Datei\u00f6ffnen");
            unterschiede = -1;
        }
        return unterschiede;
    }
}

