/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JComponent;

class Edit
extends JComponent {
    Datei file;
    int pos;
    int subpos;
    int modus;
    int ueberschreiben = 1;
    int breite;
    int hoehe;
    int proZeile;
    int luecke;
    int anzahl;
    String searchString = "";
    int searchPos = -1;
    BMPHexEditor parent;

    public Edit(BMPHexEditor p) {
        this.parent = p;
        this.file = null;
        this.pos = 0;
        this.subpos = 0;
        this.addKeyListener(new myKeyListener());
        this.addMouseListener(new myMouseListener());
        this.modus = 1;
    }

    public void adjustTextMetrics() {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        Graphics g = this.getGraphics();
        g.setFont(new Font("Monospaced", 0, 12));
        FontMetrics fm = g.getFontMetrics(g.getFont());
        this.hoehe = fm.getHeight();
        switch (this.modus) {
            case 1: {
                this.breite = fm.stringWidth("01010101") + 4;
                this.luecke = 4;
                this.anzahl = 8;
                break;
            }
            case 2: {
                this.breite = fm.stringWidth("FF") + 4;
                this.luecke = 4;
                this.anzahl = 2;
                break;
            }
            default: {
                this.breite = fm.stringWidth("F");
                this.luecke = 0;
                this.anzahl = 1;
            }
        }
        this.proZeile = iWidth / this.breite;
    }

    @Override
    public void paint(Graphics g) {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        Rectangle r = this.getVisibleRect();
        this.adjustTextMetrics();
        g.setFont(new Font("Monospaced", 0, 12));
        g.setColor(Color.black);
        if (this.file != null) {
            String info;
            int bilddaten = this.file.getDWORD(10);
            int bbreite = this.file.getDWORD(18);
            int bhoehe = this.file.getDWORD(22);
            int farbtiefe = this.file.getWORD(28);
            int compression = 0;
            int min = 0;
            int max = -1;
            int xx = -1;
            int yy = -1;
            switch (this.pos) {
                case 0: 
                case 1: {
                    info = "Byte 1+2 immer 'BM' zur Kennzeichnung eines BMP-Bildes";
                    min = 0;
                    max = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int i = this.file.getDWORD(2);
                    info = "Byte 3-6 Dateigr\u00f6\u00dfe: " + i + " Bytes (unsicher)";
                    min = 2;
                    max = 5;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    info = "Byte 7-10 reservierte Bytes (keine Bedeutung)";
                    min = 6;
                    max = 9;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    info = "Byte 11-14 Bilddaten beginnen bei Byte Nr. " + bilddaten;
                    min = 10;
                    max = 13;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    int i = this.file.getDWORD(14);
                    info = "Byte 15-18 Gr\u00f6\u00dfe des Headers: " + i + " Byte";
                    min = 14;
                    max = 17;
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    info = "Byte 19-22 Breite des Bildes: " + bbreite + " Pixel";
                    min = 18;
                    max = 21;
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    info = bhoehe < 0 ? "Byte 23-26 H\u00f6he des Bildes: " + -bhoehe + " Pixel und Top-Down-Bitmap" : "Byte 23-26 H\u00f6he des Bildes: " + bhoehe + " Pixel und Bottum-Up-Bitmap";
                    min = 22;
                    max = 25;
                    break;
                }
                case 28: 
                case 29: {
                    info = farbtiefe <= 8 ? "Byte 29+30: Farbtiefe " + farbtiefe + " Bit pro Pixel mit Farbpalette" : "Byte 29+30: Farbtiefe " + farbtiefe + " Bit pro Pixel ohne Farbpalette";
                    min = 28;
                    max = 29;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    compression = this.file.getDWORD(30);
                    info = compression == 0 ? "Byte 31-34: Komprimierung: Die Bilddaten sind unkomprimiert" : "Byte 31-34: Komprimierung: Die Bilddaten sind RunLength komprimiert";
                    min = 30;
                    max = 33;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    int i = this.file.getDWORD(34);
                    info = "Byte 35-38 Gr\u00f6\u00dfe der Bilddaten: " + i + " Byte (kann auch 0 sein)";
                    min = 34;
                    max = 37;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int i = this.file.getDWORD(38);
                    info = "Byte 39-42 Horizontale Aufl\u00f6sung " + i + " Pixel pro Meter (meist 0 gesetzt)";
                    min = 38;
                    max = 41;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int i = this.file.getDWORD(42);
                    info = "Byte 43-46 Vertikale Aufl\u00f6sung " + i + " Pixel pro Meter (meist 0 gesetzt)";
                    min = 42;
                    max = 45;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    int i = this.file.getDWORD(38);
                    info = "Byte 47-50 Anzahl der Farben in der Palette " + i + " (0 = maximale Anzahl)";
                    min = 46;
                    max = 49;
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    int i = this.file.getDWORD(38);
                    info = "Byte 51-54 Anzahl der benutzten Farben im Bild " + i + " (0 = alle Farben)";
                    min = 50;
                    max = 53;
                    break;
                }
                default: {
                    info = "sonstige Daten";
                    if (this.pos >= 54 && this.pos < bilddaten) {
                        min = max = this.pos;
                        min -= (this.pos - 54) % 4;
                        max = max + 3 - (this.pos - 54) % 4;
                        info = "Byte " + (this.pos + 1) + " Farbe Nr. " + (this.pos - 54) / 4 + " der Palette ";
                        if ((this.pos - 54) % 4 == 0) {
                            info = info + " (Blauanteil)";
                        }
                        if ((this.pos - 54) % 4 == 1) {
                            info = info + " (Gr\u00fcnanteil)";
                        }
                        if ((this.pos - 54) % 4 == 2) {
                            info = info + " (Rotanteil)";
                        }
                        if ((this.pos - 54) % 4 == 3) {
                            info = info + " (immer 0)";
                        }
                    }
                    if (this.pos < bilddaten) break;
                    min = max = this.pos;
                    int bbreite_angepasst = bbreite * farbtiefe / 8 + 3;
                    bbreite_angepasst -= bbreite_angepasst % 4;
                    yy = (this.pos - bilddaten) / bbreite_angepasst + 1;
                    int pos_in_zeile = this.pos - bilddaten - (yy - 1) * bbreite_angepasst;
                    xx = pos_in_zeile * 8 / farbtiefe + 1;
                    if (bhoehe > 0) {
                        yy = bhoehe - yy + 1;
                    }
                    if (farbtiefe == 1) {
                        info = "Byte " + (this.pos + 1) + " Farbenummer des Pixels an Pos (" + xx + "/" + yy + ") und der n\u00e4chsten 7 Pixel";
                    }
                    if (farbtiefe == 2) {
                        info = "Byte " + (this.pos + 1) + " Farbenummer des Pixels an Pos (" + xx + "/" + yy + ") und der n\u00e4chsten 3 Pixel";
                    }
                    if (farbtiefe == 4) {
                        info = "Byte " + (this.pos + 1) + " Farbnummer des Pixels an Pos (" + xx + "/" + yy + ") und des n\u00e4chsten Pixels";
                    }
                    if (farbtiefe == 8) {
                        info = "Byte " + (this.pos + 1) + " Farbnummer des Pixels an Pos (" + xx + "/" + yy + ")";
                    }
                    if (farbtiefe > 8) {
                        info = "Byte " + (this.pos + 1) + " Farbe des Pixels an Pos (" + xx + "/" + yy + ")";
                        if (pos_in_zeile % 3 == 0) {
                            info = info + " (Blauanteil)";
                        }
                        if (pos_in_zeile % 3 == 1) {
                            info = info + " (Gr\u00fcnanteil)";
                        }
                        if (pos_in_zeile % 3 == 2) {
                            info = info + " (Rotanteil)";
                        }
                        min -= pos_in_zeile % 3;
                        max = max + 2 - pos_in_zeile % 3;
                    }
                    if (xx > bbreite) {
                        info = "Byte " + (this.pos + 1) + " keine Bedeutung";
                        min = max = this.pos;
                    }
                    this.parent.posChanged(xx, yy);
                }
            }
            int laenge = this.file.getLength();
            int zeile = 0;
            int spalte = 0;
            int start = (int)(r.getY() / (double)this.hoehe) * this.proZeile;
            int ende = ((int)((r.getY() + r.getHeight()) / (double)this.hoehe) + 1) * this.proZeile;
            zeile = (int)(r.getY() / (double)this.hoehe);
            spalte = 0;
            for (int i = start; i < ende && i < laenge; ++i) {
                String s;
                if (this.file.getSearchByte(i) == 1) {
                    g.setColor(Color.red);
                    g.fillRect(spalte * this.breite + this.luecke / 2 - 1, 4 + zeile * this.hoehe - 1, this.breite - this.luecke / 2 + 1, this.hoehe + 2);
                    g.setColor(Color.black);
                }
                if (i >= min && i <= max) {
                    g.setColor(Color.lightGray);
                    g.fillRect(spalte * this.breite + this.luecke / 2, 4 + zeile * this.hoehe, this.breite - this.luecke / 2 - 1, this.hoehe);
                    g.setColor(Color.black);
                }
                if (i == this.pos) {
                    g.setColor(Color.yellow);
                    g.fillRect(spalte * this.breite + this.luecke / 2, 4 + zeile * this.hoehe, this.breite - this.luecke / 2 - 1, this.hoehe);
                    if (this.subpos != 0) {
                        g.setColor(Color.red);
                        g.fillRect(spalte * this.breite + this.subpos * (this.breite - this.luecke) / this.anzahl + this.luecke / 2, 4 + zeile * this.hoehe, (this.breite - this.luecke / 2) / this.anzahl - 1, this.hoehe);
                    }
                    g.setColor(Color.black);
                }
                switch (this.modus) {
                    case 1: {
                        s = this.file.getByteBinary(i);
                        break;
                    }
                    case 2: {
                        s = this.file.getByteHex(i);
                        break;
                    }
                    default: {
                        s = this.file.getByteChar(i);
                    }
                }
                g.drawString(s, spalte * this.breite + this.luecke / 2, this.hoehe + zeile * this.hoehe);
                if (++spalte < this.proZeile) continue;
                ++zeile;
                spalte = 0;
            }
            if (this.pos < ende && this.pos == laenge) {
                g.setColor(Color.lightGray);
                g.fillRect(spalte * this.breite + this.luecke / 2, 4 + zeile * this.hoehe, this.breite - this.luecke / 2 - 1, this.hoehe);
                g.setColor(Color.black);
            }
            this.parent.showLabels(this.file.getByteBinary(this.pos), this.file.getByteHex(this.pos), this.file.getByteChar(this.pos), info);
        }
    }

    public void setDatei(Datei file) {
        this.file = file;
        this.pos = 0;
        this.subpos = 0;
    }

    public Datei getDatei() {
        return this.file;
    }

    @Override
    public Dimension getPreferredSize() {
        this.adjustTextMetrics();
        if (this.file == null) {
            return new Dimension(300, 200);
        }
        int laenge = this.file.getLength();
        int komponentenhoehe = this.hoehe + laenge / this.proZeile * this.hoehe + 5;
        if (komponentenhoehe < 200) {
            komponentenhoehe = 200;
        }
        return new Dimension(300, komponentenhoehe);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMode(int i) {
        this.modus = i;
        this.subpos = 0;
        this.repaint();
    }

    public void setUeberschreiben(int i) {
        this.ueberschreiben = i;
    }

    public int getUeberschreiben() {
        return this.ueberschreiben;
    }

    public void movePos(int i) {
        if (this.file != null) {
            this.subpos = 0;
            this.pos += i;
            if (this.pos < 0) {
                this.pos = 0;
            }
            if (this.pos > this.file.getLength()) {
                this.pos = this.file.getLength();
            }
            this.repaint();
        }
    }

    public void moveToMousePos(int x, int y) {
        if (this.file != null) {
            this.pos = y / this.hoehe * this.proZeile + x / this.breite;
            this.subpos = 0;
            if (this.pos < 0) {
                this.pos = 0;
            }
            if (this.pos > this.file.getLength()) {
                this.pos = this.file.getLength();
            }
            this.repaint();
        }
    }

    public void moveToPos(int x, int y) {
        int bilddaten = this.file.getDWORD(10);
        int bbreite = this.file.getDWORD(18);
        int bhoehe = this.file.getDWORD(22);
        int farbtiefe = this.file.getWORD(28);
        this.pos = bhoehe > 0 ? (bhoehe - y) * bbreite + x - 1 : (y - 1) * bbreite + x - 1;
        this.pos = this.pos * farbtiefe / 8;
        this.pos += bilddaten;
        this.parent.scrollTo(0, this.pos / this.proZeile * this.hoehe - 100);
        this.repaint();
    }

    public int compare(File vergleichDatei) {
        int gefunden = -1;
        if (this.file != null) {
            gefunden = this.file.compare(vergleichDatei);
        }
        this.repaint();
        return gefunden;
    }

    public int search(String s) {
        int gefunden = -1;
        if (this.file != null) {
            String s2 = "";
            for (int i = 0; i < s.length(); ++i) {
                char b = s.charAt(i);
                if (this.modus == 1 && (b == '0' || b == '1')) {
                    s2 = s2 + b;
                }
                if (this.modus == 2 && (b >= '0' && b <= '9' || b >= 'A' && b <= 'F' || b >= 'a' && b <= 'f')) {
                    s2 = s2 + b;
                }
                if (this.modus != 3) continue;
                s2 = s2 + b;
            }
            if (this.modus == 2) {
                s2 = s2.toUpperCase();
            }
            if (s2.length() > 0) {
                gefunden = this.file.search(s2, this.modus);
            }
        }
        this.repaint();
        return gefunden;
    }

    public void delete(int i) {
        if (this.file != null && this.pos + i > 0 && this.pos + i < this.file.getLength()) {
            this.file.deleteByte(this.pos + i);
            this.subpos = 0;
            this.pos += i;
            if (this.pos > this.file.getLength()) {
                --this.pos;
            }
        }
        this.repaint();
    }

    public void modifyByte(char c) {
        if (this.file != null) {
            int maxSubpos;
            String s;
            if (this.pos == this.file.getLength() || this.subpos == 0 && this.ueberschreiben != 1) {
                this.file.insertByte(this.pos);
            }
            switch (this.modus) {
                case 1: {
                    s = this.file.getByteBinary(this.pos);
                    break;
                }
                case 2: {
                    s = this.file.getByteHex(this.pos);
                    break;
                }
                default: {
                    s = this.file.getByteChar(this.pos);
                }
            }
            s = s.substring(0, this.subpos) + c + s.substring(this.subpos + 1);
            ++this.subpos;
            switch (this.modus) {
                case 1: {
                    maxSubpos = 7;
                    this.file.setByteBinary(this.pos, s);
                    break;
                }
                case 2: {
                    maxSubpos = 1;
                    this.file.setByteHex(this.pos, s);
                    break;
                }
                default: {
                    maxSubpos = 0;
                    this.file.setByteChar(this.pos, c);
                }
            }
            if (this.subpos > maxSubpos) {
                this.subpos = 0;
                this.movePos(1);
            }
            this.repaint();
            this.parent.fileChanged();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    class myMouseListener
    implements MouseListener {
        myMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent m) {
            Edit.this.moveToMousePos(m.getX(), m.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class myKeyListener
    implements KeyListener {
        myKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent k) {
            int iHeight = Edit.this.getSize().height;
            if (k.getKeyCode() == 8) {
                Edit.this.delete(-1);
            }
            if (k.getKeyCode() == 127) {
                Edit.this.delete(0);
            }
            if (k.getKeyCode() == 37) {
                Edit.this.movePos(-1);
            }
            if (k.getKeyCode() == 39) {
                Edit.this.movePos(1);
            }
            if (k.getKeyCode() == 38) {
                Edit.this.movePos(-Edit.this.proZeile);
            }
            if (k.getKeyCode() == 40) {
                Edit.this.movePos(Edit.this.proZeile);
            }
            if (k.getKeyCode() == 33) {
                Edit.this.movePos(-Edit.this.proZeile * (iHeight / Edit.this.hoehe));
            }
            if (k.getKeyCode() == 34) {
                Edit.this.movePos(Edit.this.proZeile * (iHeight / Edit.this.hoehe));
            }
        }

        @Override
        public void keyReleased(KeyEvent k) {
        }

        @Override
        public void keyTyped(KeyEvent k) {
            switch (Edit.this.modus) {
                case 1: {
                    if (k.getKeyChar() < '0' || k.getKeyChar() > '1') break;
                    Edit.this.modifyByte(k.getKeyChar());
                    break;
                }
                case 2: {
                    if (k.getKeyChar() >= '0' && k.getKeyChar() <= '9') {
                        Edit.this.modifyByte(k.getKeyChar());
                    }
                    if (k.getKeyChar() >= 'a' && k.getKeyChar() <= 'f') {
                        Edit.this.modifyByte(k.getKeyChar());
                    }
                    if (k.getKeyChar() < 'A' || k.getKeyChar() > 'F') break;
                    Edit.this.modifyByte(k.getKeyChar());
                    break;
                }
                default: {
                    if (k.getKeyCode() == 127) break;
                    Edit.this.modifyByte(k.getKeyChar());
                }
            }
        }
    }
}

