/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JComponent;

class Edit
extends JComponent {
    Datei file;
    int pos;
    int subpos;
    int modus;
    int ueberschreiben = 1;
    int breite;
    int hoehe;
    int proZeile;
    int luecke;
    int anzahl;
    String searchString = "";
    int searchPos = -1;
    HexEditor parent;

    public Edit(HexEditor p) {
        this.parent = p;
        this.file = null;
        this.pos = 0;
        this.subpos = 0;
        this.addKeyListener(new myKeyListener());
        this.addMouseListener(new myMouseListener());
        this.modus = 1;
    }

    public void adjustTextMetrics() {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        Graphics g = this.getGraphics();
        g.setFont(new Font("Monospaced", 0, 12));
        FontMetrics fm = g.getFontMetrics(g.getFont());
        this.hoehe = fm.getHeight();
        switch (this.modus) {
            case 1: {
                this.breite = fm.stringWidth("01010101") + 4;
                this.luecke = 4;
                this.anzahl = 8;
                break;
            }
            case 2: {
                this.breite = fm.stringWidth("FF") + 4;
                this.luecke = 4;
                this.anzahl = 2;
                break;
            }
            default: {
                this.breite = fm.stringWidth("F");
                this.luecke = 0;
                this.anzahl = 1;
            }
        }
        this.proZeile = iWidth / this.breite;
    }

    @Override
    public void paint(Graphics g) {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        Rectangle r = this.getVisibleRect();
        this.adjustTextMetrics();
        g.setFont(new Font("Monospaced", 0, 12));
        g.setColor(Color.black);
        if (this.file != null) {
            int laenge = this.file.getLength();
            int start = (int)(r.getY() / (double)this.hoehe) * this.proZeile;
            int ende = ((int)((r.getY() + r.getHeight()) / (double)this.hoehe) + 1) * this.proZeile;
            int zeile = (int)(r.getY() / (double)this.hoehe);
            int spalte = 0;
            for (int i = start; i < ende && i < laenge; ++i) {
                String s;
                if (this.file.getSearchByte(i) == 1) {
                    g.setColor(Color.red);
                    g.fillRect(spalte * this.breite + this.luecke / 2 - 1, 4 + zeile * this.hoehe - 1, this.breite - this.luecke / 2 + 1, this.hoehe + 2);
                    g.setColor(Color.black);
                }
                if (i == this.pos) {
                    g.setColor(Color.lightGray);
                    g.fillRect(spalte * this.breite + this.luecke / 2, 4 + zeile * this.hoehe, this.breite - this.luecke / 2 - 1, this.hoehe);
                    if (this.subpos != 0) {
                        g.setColor(Color.GRAY);
                        g.fillRect(spalte * this.breite + this.subpos * (this.breite - this.luecke) / this.anzahl + this.luecke / 2, 4 + zeile * this.hoehe, (this.breite - this.luecke / 2) / this.anzahl - 1, this.hoehe);
                    }
                    g.setColor(Color.black);
                }
                switch (this.modus) {
                    case 1: {
                        s = this.file.getByteBinary(i);
                        break;
                    }
                    case 2: {
                        s = this.file.getByteHex(i);
                        break;
                    }
                    default: {
                        s = this.file.getByteChar(i);
                    }
                }
                g.drawString(s, spalte * this.breite + this.luecke / 2, this.hoehe + zeile * this.hoehe);
                if (++spalte < this.proZeile) continue;
                ++zeile;
                spalte = 0;
            }
            if (this.pos < ende && this.pos == laenge) {
                g.setColor(Color.lightGray);
                g.fillRect(spalte * this.breite + this.luecke / 2, 4 + zeile * this.hoehe, this.breite - this.luecke / 2 - 1, this.hoehe);
                g.setColor(Color.black);
            }
            this.parent.showLabels(this.file.getByteBinary(this.pos), this.file.getByteHex(this.pos), this.file.getByteChar(this.pos), this.pos + 1);
        }
    }

    public void setDatei(Datei file) {
        this.file = file;
        this.pos = 0;
        this.subpos = 0;
    }

    public Datei getDatei() {
        return this.file;
    }

    @Override
    public Dimension getPreferredSize() {
        this.adjustTextMetrics();
        if (this.file == null) {
            return new Dimension(300, 200);
        }
        int laenge = this.file.getLength();
        int komponentenhoehe = this.hoehe + laenge / this.proZeile * this.hoehe + 5;
        if (komponentenhoehe < 200) {
            komponentenhoehe = 200;
        }
        return new Dimension(300, komponentenhoehe);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMode(int i) {
        this.modus = i;
        this.subpos = 0;
        this.repaint();
    }

    public void setUeberschreiben(int i) {
        this.ueberschreiben = i;
    }

    public int getUeberschreiben() {
        return this.ueberschreiben;
    }

    public void movePos(int i) {
        if (this.file != null) {
            this.subpos = 0;
            this.pos += i;
            if (this.pos > this.file.getLength()) {
                this.pos = this.file.getLength();
            }
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.repaint();
        }
    }

    public void moveToMousePos(int x, int y) {
        if (this.file != null) {
            this.pos = y / this.hoehe * this.proZeile + x / this.breite;
            this.subpos = 0;
            if (this.pos > this.file.getLength()) {
                this.pos = this.file.getLength();
            }
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.repaint();
        }
    }

    public int compare(File vergleichDatei) {
        int gefunden = -1;
        if (this.file != null) {
            gefunden = this.file.compare(vergleichDatei);
        }
        this.repaint();
        return gefunden;
    }

    public int search(String s) {
        int gefunden = -1;
        if (this.file != null) {
            String s2 = "";
            for (int i = 0; i < s.length(); ++i) {
                char b = s.charAt(i);
                if (this.modus == 1 && (b == '0' || b == '1')) {
                    s2 = s2 + b;
                }
                if (this.modus == 2 && (b >= '0' && b <= '9' || b >= 'A' && b <= 'F' || b >= 'a' && b <= 'f')) {
                    s2 = s2 + b;
                }
                if (this.modus != 3) continue;
                s2 = s2 + b;
            }
            if (this.modus == 2) {
                s2 = s2.toUpperCase();
            }
            if (s2.length() > 0) {
                gefunden = this.file.search(s2, this.modus);
            }
        }
        this.repaint();
        return gefunden;
    }

    public void delete(int i) {
        if (this.file != null && this.pos + i > 0 && this.pos + i < this.file.getLength()) {
            this.file.deleteByte(this.pos + i);
            this.subpos = 0;
            this.pos += i;
            if (this.pos > this.file.getLength()) {
                --this.pos;
            }
        }
        this.repaint();
    }

    public void modifyByte(char c) {
        if (this.file != null) {
            int maxSubpos;
            String s;
            if (this.pos == this.file.getLength() || this.subpos == 0 && this.ueberschreiben != 1) {
                this.file.insertByte(this.pos);
            }
            switch (this.modus) {
                case 1: {
                    s = this.file.getByteBinary(this.pos);
                    break;
                }
                case 2: {
                    s = this.file.getByteHex(this.pos);
                    break;
                }
                default: {
                    s = this.file.getByteChar(this.pos);
                }
            }
            s = s.substring(0, this.subpos) + c + s.substring(this.subpos + 1);
            ++this.subpos;
            switch (this.modus) {
                case 1: {
                    maxSubpos = 7;
                    this.file.setByteBinary(this.pos, s);
                    break;
                }
                case 2: {
                    maxSubpos = 1;
                    this.file.setByteHex(this.pos, s);
                    break;
                }
                default: {
                    maxSubpos = 0;
                    this.file.setByteChar(this.pos, c);
                }
            }
            if (this.subpos > maxSubpos) {
                this.subpos = 0;
                this.movePos(1);
            }
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    class myMouseListener
    implements MouseListener {
        myMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent m) {
            Edit.this.moveToMousePos(m.getX(), m.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class myKeyListener
    implements KeyListener {
        myKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent k) {
            int iHeight = Edit.this.getSize().height;
            if (k.getKeyCode() == 8) {
                Edit.this.delete(-1);
            }
            if (k.getKeyCode() == 127) {
                Edit.this.delete(0);
            }
            if (k.getKeyCode() == 37) {
                Edit.this.movePos(-1);
            }
            if (k.getKeyCode() == 39) {
                Edit.this.movePos(1);
            }
            if (k.getKeyCode() == 38) {
                Edit.this.movePos(-Edit.this.proZeile);
            }
            if (k.getKeyCode() == 40) {
                Edit.this.movePos(Edit.this.proZeile);
            }
            if (k.getKeyCode() == 33) {
                Edit.this.movePos(-Edit.this.proZeile * (iHeight / Edit.this.hoehe));
            }
            if (k.getKeyCode() == 34) {
                Edit.this.movePos(Edit.this.proZeile * (iHeight / Edit.this.hoehe));
            }
        }

        @Override
        public void keyReleased(KeyEvent k) {
        }

        @Override
        public void keyTyped(KeyEvent k) {
            switch (Edit.this.modus) {
                case 1: {
                    if (k.getKeyChar() < '0' || k.getKeyChar() > '1') break;
                    Edit.this.modifyByte(k.getKeyChar());
                    break;
                }
                case 2: {
                    if (k.getKeyChar() >= '0' && k.getKeyChar() <= '9') {
                        Edit.this.modifyByte(k.getKeyChar());
                    }
                    if (k.getKeyChar() >= 'a' && k.getKeyChar() <= 'f') {
                        Edit.this.modifyByte(k.getKeyChar());
                    }
                    if (k.getKeyChar() < 'A' || k.getKeyChar() > 'F') break;
                    Edit.this.modifyByte(k.getKeyChar());
                    break;
                }
                default: {
                    if (k.getKeyCode() == 127) break;
                    Edit.this.modifyByte(k.getKeyChar());
                }
            }
        }
    }
}

