/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HexEditor
extends JFrame {
    private JMenuBar mb = new JMenuBar();
    private JMenu fileMenu = new JMenu("Datei");
    private JMenu editMenu = new JMenu("Bearbeiten");
    private JMenu viewMenu = new JMenu("Ansicht");
    private JMenu infoMenu = new JMenu("Info");
    private static JFileChooser dateiauswahldialog = new JFileChooser(System.getProperty("user.dir"));
    private Edit eingabe = new Edit(this);
    private JScrollPane scrollPane = new JScrollPane(this.eingabe);
    private JPanel infoPane = new JPanel();
    private JLabel binLabel = new JLabel("        ");
    private JLabel hexLabel = new JLabel("        ");
    private JLabel ascLabel = new JLabel(" ");
    private JLabel posLabel = new JLabel(" ");
    private JLabel posTitle = new JLabel("Byte Nr.:");
    private JLabel binTitle = new JLabel("Bin\u00e4r:");
    private JLabel hexTitle = new JLabel("Hexadezimal:");
    private JLabel ascTitle = new JLabel("ASCII-Code:");
    private JPanel titelPane = new JPanel();
    private JLabel dateiname = new JLabel("");
    private JLabel modus = new JLabel("\u00dcberschreibmodus");
    private JMenuItem modeAction = new JMenuItem("Einf\u00fcgemodus w\u00e4hlen");

    public HexEditor(String title) {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        int frameWidth = 800;
        int frameHeight = 500;
        this.setSize(frameWidth, frameHeight);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - this.getSize().width) / 2;
        int y = (d.height - this.getSize().height) / 2;
        this.setLocation(x, y);
        Container cp = this.getContentPane();
        this.setLayout(new BorderLayout());
        this.setJMenuBar(this.mb);
        this.mb.add(this.fileMenu);
        this.mb.add(this.editMenu);
        this.mb.add(this.viewMenu);
        this.mb.add(this.infoMenu);
        JMenuItem newAction = new JMenuItem("Neu");
        JMenuItem openAction = new JMenuItem("\u00d6ffnen");
        JMenuItem saveAction = new JMenuItem("Speichern");
        JMenuItem saveasAction = new JMenuItem("Speichern unter");
        JMenuItem exitAction = new JMenuItem("Beenden");
        JMenuItem searchAction = new JMenuItem("Suchen");
        JMenuItem compareAction = new JMenuItem("Dateivergleich");
        JMenuItem binAction = new JMenuItem("Bin\u00e4rdarstellung");
        JMenuItem hexAction = new JMenuItem("Hexadezimaldarstellung");
        JMenuItem ascAction = new JMenuItem("ASCII-Darstellung");
        JMenuItem infoAction = new JMenuItem("Info");
        this.fileMenu.add(newAction);
        this.fileMenu.add(openAction);
        this.fileMenu.add(saveAction);
        this.fileMenu.addSeparator();
        this.fileMenu.add(exitAction);
        this.editMenu.add(searchAction);
        this.editMenu.add(compareAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.modeAction);
        this.viewMenu.add(binAction);
        this.viewMenu.add(hexAction);
        this.viewMenu.add(ascAction);
        this.infoMenu.add(infoAction);
        newAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HexEditor.this.eingabe.setDatei(new Datei());
                HexEditor.this.dateiname.setText("unbenannt.txt");
                HexEditor.this.pack();
                HexEditor.this.repaint();
            }
        });
        openAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.openFile();
            }
        });
        saveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.saveFile();
            }
        });
        exitAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        searchAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.suchen();
            }
        });
        compareAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.vergleiche();
            }
        });
        this.modeAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.changeUeberschreiben();
            }
        });
        binAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.eingabe.setMode(1);
                HexEditor.this.scrollPane.getViewport().setView(HexEditor.this.eingabe);
            }
        });
        hexAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.eingabe.setMode(2);
                HexEditor.this.scrollPane.getViewport().setView(HexEditor.this.eingabe);
            }
        });
        ascAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditor.this.eingabe.setMode(3);
                HexEditor.this.scrollPane.getViewport().setView(HexEditor.this.eingabe);
            }
        });
        infoAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(null, "Autor: T. Schaller  Version: April 2013", "Information", 1);
            }
        });
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setPreferredSize(new Dimension(800, 450));
        this.scrollPane.setBorder(BorderFactory.createEtchedBorder());
        cp.add((Component)this.scrollPane, "Center");
        this.infoPane.setLayout(new BoxLayout(this.infoPane, 2));
        this.infoPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 3, 5));
        this.infoPane.add(this.posTitle);
        this.infoPane.add(Box.createRigidArea(new Dimension(3, 0)));
        this.infoPane.add(this.posLabel);
        this.infoPane.add(Box.createRigidArea(new Dimension(30, 0)));
        this.infoPane.add(this.binTitle);
        this.infoPane.add(Box.createRigidArea(new Dimension(3, 0)));
        this.infoPane.add(this.binLabel);
        this.infoPane.add(Box.createRigidArea(new Dimension(30, 0)));
        this.infoPane.add(this.hexTitle);
        this.infoPane.add(Box.createRigidArea(new Dimension(3, 0)));
        this.infoPane.add(this.hexLabel);
        this.infoPane.add(Box.createRigidArea(new Dimension(30, 0)));
        this.infoPane.add(this.ascTitle);
        this.infoPane.add(Box.createRigidArea(new Dimension(3, 0)));
        this.infoPane.add(this.ascLabel);
        cp.add((Component)this.infoPane, "Last");
        this.titelPane.setLayout(new BoxLayout(this.titelPane, 2));
        this.titelPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 5));
        this.titelPane.add(this.dateiname);
        this.titelPane.add(Box.createHorizontalGlue());
        this.titelPane.add(this.modus);
        cp.add((Component)this.titelPane, "First");
        this.setResizable(true);
        this.setVisible(true);
        this.pack();
        this.eingabe.requestFocus();
    }

    public void showLabels(String bin, String hex, String asc, int pos) {
        this.binLabel.setText(bin);
        this.hexLabel.setText(hex);
        this.ascLabel.setText(asc);
        this.posLabel.setText("" + pos);
    }

    public void openFile() {
        int ergebnis = dateiauswahldialog.showOpenDialog(this);
        if (ergebnis != 0) {
            return;
        }
        Datei file = new Datei(dateiauswahldialog.getSelectedFile());
        this.eingabe.setDatei(file);
        this.dateiname.setText(file.getFileName());
        this.scrollPane.getViewport().setView(this.eingabe);
        this.repaint();
    }

    public void saveFile() {
        Datei file = this.eingabe.getDatei();
        if (file != null) {
            file = this.eingabe.getDatei();
            dateiauswahldialog.setSelectedFile(new File(file.getPathName()));
            int ergebnis = dateiauswahldialog.showSaveDialog(this);
            if (ergebnis != 0) {
                return;
            }
            file.saveFile(dateiauswahldialog.getSelectedFile());
            this.dateiname.setText(file.getFileName());
            this.repaint();
        }
    }

    public void changeUeberschreiben() {
        if (this.eingabe.getUeberschreiben() == 1) {
            this.eingabe.setUeberschreiben(0);
            this.modeAction.setText("\u00dcberschreibemodus w\u00e4hlen");
            this.modus.setText("Einf\u00fcgemodus");
        } else {
            this.eingabe.setUeberschreiben(1);
            this.modeAction.setText("Einf\u00fcgemodus w\u00e4hlen");
            this.modus.setText("\u00dcberschreibemodus");
        }
    }

    public void suchen() {
        String s = JOptionPane.showInputDialog("Geben Sie bitte die gesuchten Bytes ein.");
        if (s != null) {
            int erg = this.eingabe.search(s);
            if (erg == -1) {
                JOptionPane.showMessageDialog(this, "Fehler bei der Suche. Es muss eine Datei ge\u00f6ffnet sein und es k\u00f6nnen immer nur ganze Bytes gesucht werden.");
            }
            if (erg == 0) {
                JOptionPane.showMessageDialog(this, "Gesuchte Bytes wurden nicht gefunden.");
            }
            if (erg > 0) {
                JOptionPane.showMessageDialog(this, "Gesuchte Bytes wurden " + erg + " mal gefunden.");
            }
        }
    }

    public void vergleiche() {
        int ergebnis = dateiauswahldialog.showOpenDialog(this);
        if (ergebnis != 0) {
            return;
        }
        int erg = this.eingabe.compare(dateiauswahldialog.getSelectedFile());
        this.repaint();
        if (erg == -1) {
            JOptionPane.showMessageDialog(this, "Fehler beim Vergleich. Es muss eine Datei ge\u00f6ffnet sein.");
        }
        if (erg == 0) {
            JOptionPane.showMessageDialog(this, "Keine Unterschiede gefunden.");
        }
        if (erg > 0) {
            JOptionPane.showMessageDialog(this, "" + erg + " Bytes unterscheiden sich.");
        }
    }

    public static void main(String[] args) {
        new HexEditor("HexEditor");
    }
}

