PImage img;
int[] xwerte;
int[] ywerte;
int anz;

public void setup() {
  xwerte = new int[1000];
  ywerte = new int[1000];
  anz = 0;
  
  size(700,700);  
  ladeBild("hai.png");
  bestimmeStuetzpunkte(40,10,4,7);
}

/** Findet den y-Wert des ersten nicht transparenten Pixels 
  * in der Zeile Spalte x
  */
public int getBorder(int x) {
  int y = 0;
  while(alpha(img.get(x,y)) < 200 && y<600) y++;
  return y;
}

/** lädt ein Bild mit Dateiname name 
*/
public void ladeBild(String name) {
    img = loadImage(name);
    img.loadPixels();
}


/** Rekursive Methode zum Verfeinern der Stützstellen
  * @param x1 linke Grenze
  * @param x2 rechte Grenze
  * @param diffmax maximale zulässige Differenz der y-Werte
  * @param tmin minimale zulässige Differenz der x-Werte
  */
public void verfeinere(int x1, int x2, int diffmax, int tmin) {
  int mitte = (x1+x2)/2;
  int y1 = getBorder(x1);
  int y2 = getBorder(x2);
  int ym = getBorder(mitte);
  if(mitte-x1 > tmin && Math.abs(ym-y1) > diffmax) verfeinere(x1, mitte, diffmax, tmin);
  xwerte[anz] = mitte;
  ywerte[anz] = ym;
  System.out.println(""+xwerte[anz]+" "+ywerte[anz]);
  anz++;
  if(x2-mitte > tmin && Math.abs(y2-ym) > diffmax) verfeinere(mitte,x2, diffmax, tmin);
}

/** Bestimmung der Stützstellen. Bei Überschreitung der maximalen Differenz
  * der y-Werte, werden zusätzliche Zwischenwerte mit Hilfe
  * der rekursiven Verfeinere-Methode generiert. Bei Unterschreitung
  * werden vorherige Stützstellen entfernt.
  * @param t0 Startpunkt
  * @param diffmin minimale zulässige Differenz der y-Werte 
  * @param diffmax maximale zulässige Differenz der y-Werte
  * @param tmin minimale zulässige Differenz der x-Werte
  */
public void bestimmeStuetzpunkte(int t0, int diffmax, int tmin, int diffmin) {
  xwerte[0] = 0;
  ywerte[0] = getBorder(0);
 
  anz = 1;
  for(int xpos=t0; xpos < img.width; xpos+=t0) {
    int y = getBorder(xpos);
    if(Math.abs(y-ywerte[anz-1])>diffmax) {
      verfeinere(xwerte[anz-1], xpos, diffmax, tmin);
    }
    if(anz>1 && Math.abs(ywerte[anz-1]-y) < diffmin && Math.abs(ywerte[anz-2]-ywerte[anz-1])< diffmin && Math.abs(ywerte[anz-2]-y) < diffmin) {
      anz--;
    }
    xwerte[anz] = xpos;
    ywerte[anz] = y;
    System.out.println(""+xwerte[anz]+" "+ywerte[anz]);
    anz++;
  }
  redraw();
}

/** Bestimmung der Stützstellen. Bei Überschreitung der maximalen Differenz
  * der y-Werte, wird der aktuelle Punkt verworfen und die Schrittweite halbiert.
  * Bei Unterschreitung werden vorherige Stützstellen entfernt.
  * @param t0 Startpunkt
  * @param diffmin minimale zulässige Differenz der y-Werte 
  * @param diffmax maximale zulässige Differenz der y-Werte
  * @param tmin minimale zulässige Differenz der x-Werte
  */
public void bestimmeStuetzpunkte2(int t0, int diffmax, int tmin, int diffmin) {
  xwerte[0] = 0;
  ywerte[0] = getBorder(0);
 
  anz = 1;
  for(int xpos=0; xpos+t0 < img.width; ) { //<>//
    int t = t0;
    while(t > tmin && Math.abs(getBorder(xpos+t)-ywerte[anz-1])>diffmax) { t = t/2; }
    if(t <tmin) t = tmin;
    xpos += t;
    int y = getBorder(xpos);
    if(anz>1 && Math.abs(ywerte[anz-1]-y) < diffmin && Math.abs(ywerte[anz-2]-ywerte[anz-1])< diffmin && Math.abs(ywerte[anz-2]-y) < diffmin) {
      anz--;
    }
    xwerte[anz] = xpos;
    ywerte[anz] = y;
    System.out.println(""+xwerte[anz]+" "+ywerte[anz]);
    anz++;
  }
  redraw();
}


void draw() {
  image(img, 0, 0);
  fill(255,0,0);
  for(int i=0; i<anz; i++) {
    ellipse(xwerte[i], ywerte[i],7,7);
  }
  noFill();
  beginShape();
  // Startpunkt ist 1. Kurvenpunkt
  curveVertex(xwerte[0], ywerte[0]);
  for(int i=0; i<anz; i++) {
    curveVertex(xwerte[i], ywerte[i]);
  }
  // Endpunkt ist letzter Kurvenpunkt
  curveVertex(xwerte[anz-1], ywerte[anz-1]);
  endShape();
}
