import imp.*;
import java.awt.Font;

/**
 * Beschreiben Sie hier die Klasse Balkendiagramm.
 * 
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Balkendiagramm extends Picture
{
    // Schriften
    public Font kleineSchrift;  
    public Font grosseSchrift;
    
    // Liste mit allen Werten //<>//
    int[]    zahlen;    
    String[] namen;

    // Hilfsvariablen für die Suche
    int akt_maximum=-1;    // aktuell groesstes Element
    int akt=-1;            // aktuell untersuchtes Element
    int verzoegerung=1000;  // 1000 - Geschwindigkeit der Ausführung

    public Balkendiagramm() {
        size(800, 600);
        background(0);
        kleineSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 12 );
        grosseSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 20 );
        showInFrame();
        // CSV-Datei laden und anzeigen
        ladeTabelle("punkte.csv");
        zeichneBalken(true);
    }

    public void ladeTabelle(String name) {
        // Tabelle aus CSV-Datei laden
        Table csv =  new Table(name,"header",',','"');

        // Initialisiere Arrays, in die alle Zeilen der Tabelle passen
        zahlen = new int[csv.getRowCount()];
        namen = new String[csv.getRowCount()];

        // Fuelle die Arrays mit Werten aus der Tabelle
        for (int i = 0; i < zahlen.length; i++) {
            // Lies Wert aus der i. Zeile und der Spalte "Punkte" bzw. "Name"
            zahlen[i] = csv.getInt(i,"Punkte");
            namen[i] = csv.getString(i,"Name");
        }
    }

    public void zeichneBalken(boolean vorherLoeschen) {
        if (vorherLoeschen) {
            akt = -1;
            akt_maximum = -1;
            clear();
        }
        // Überschrift
        fill(255,255,255);
        textFont(grosseSchrift);
        text("Punkte", 2, 20);
        textFont(kleineSchrift);  
        // Alle Eintraege darstellen
        if (zahlen != null) {
            for (int i = 0; i< zahlen.length; i++) {
                setAutoRefresh(false);
                fill(20,25,165);
                // aktuelle Elemente farblich hervorheben
                if (i == akt) {
                    fill(140,230,20);
                } 
                if (i == akt_maximum) {
                    fill(230,60,140);
                } 
                // Balkendiagramm zeichnen
                if (zahlen[i]>=0) rect(120, 25+i*15, zahlen[i]+1, 13);
                // Beschriftung
                fill(255,255,255);
                text(namen[i], 2, 35+i*15);
                text(""+zahlen[i], 70, 35+i*15);
                setAutoRefresh(true);
                forceRepaint();
            }
        }
    }

    public int maximumsuche() {
        // Sind überhaupt Daten da?
        if(zahlen.length==0 ) { //<>//
            return -1;
        }

        // Startwerte setzen
        akt_maximum = 0;
        akt = 1;

        // Alle Arrayelemente untersuchen
        while (akt < zahlen.length) {
            // Neu zeichnen, da akt neu gesetzt wurde 
            zeichneBalken(false);
            delay(verzoegerung);
            // Neues größtes Element??
            if (zahlen[akt]> zahlen[akt_maximum]) {
                // Dann merke dir das neue 
                akt_maximum = akt;
                // Zeichne Balken neu, da neues größtes Element
                zeichneBalken(false);
                delay(verzoegerung);
            }
            akt = akt + 1;
        }
        zeichneBalken(false);
        delay(verzoegerung);
        akt = -1;
        zeichneBalken(false);
        // Gib Position des größten Elements zurück
        return akt_maximum;
    }
}
