import imp.*;

public class Kaffeehaus extends Picture
{
    
    public Kaffeehaus () {
        setup();
        showInFrame();
    }
    
    // globale Variablen
    int s = 40; // Seitenlänge der Quadrate bzw. Abstand der Parallelen

    int[] abstaende = {10, 20, 30, 20}; // Abstände des 1. Quadrates nach links

    void setup(){
        size(655, 406);
        background(255); // Hintergrund weiß
        setAutoRefresh(false);
        parallelen(10);  // Aufruf der Methode zum Zeichnen der Parallelen
        zeichneAlleQuadrate(); // Aufruf der Methode zum Zeichnen der Quadrate
        forceRepaint();
    }
    
    void empty() {
        super.clear();
    }

    void parallelen(int anzahl){ // zeichnet 10 graue Parallelen
        stroke(125); // Linienfarbe Graustufe
        for (int i=0; i<anzahl; i++){
            line(0,5+i*s, 640, 5+i*s);
        }
    }

    void zeichneQuadratZeile(int zeilenNummer) {
        for (int i=0; i<8; i++){
            // rect(10+2*s*i,5+zeilenNummer*s,s,s);  // Abstand bei allen Reihen gleich: d=10
            rect(abstaende[zeilenNummer%4]+2*s*i, 5+zeilenNummer*s, s, s);  // Abstand wird jeweils aus dem Feld gelesen mod 4
        }
    }

    void zeichneAlleQuadrate(){
        fill(0); // Füllfarbe schwarz
        for (int j=0; j<9; j++){
            zeichneQuadratZeile(j);
        }
    }
}
