import java.awt.Font;

/**
 * Balkendiagramm für int-Array, Zahlen werden aus CSV-Datei gelesen, Minimum der Werte wird bestimmt.
 * Hinweis zur Benutzung: 
 * Start des Algorithmus: Klicke den Button Maximumsuche an.
 * Start des automatischen Tests: Klicke den Button Testen an. Die Ausgabe erfolgt in der Konsole.
 * 
 * @author Schaller 
 * @version 29.11.18
 */
public class Balkendiagramm extends Picture

{
// Liste mit allen Werten
  int[]    zahlen;    
  String[] namen;


// Hilfsvariablen für die Suche
    int akt_minimum=-1;    // aktuell kleinstes Element
   int akt=-1;            // aktuell untersuchtes Element
  int verzoegerung=1000;  // Geschwindigkeit der Ausführung

    // Schriften
  Font kleineSchrift;  
  Font grosseSchrift;

  public Balkendiagramm() {
    size(1000, 700);
    background(0);
    kleineSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 12 );
    grosseSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 20 );
    
    // Deaktiviere die automatische Neudarstellung nach einem Zeichenbefehl
    setAutoRefresh(false);

    // CSV-Datei laden und anzeigen
    ladeTabelle("punkte.csv");
    
    zeichneBalken();
  }
  


  public void ladeTabelle(String name) {
    // Tabelle aus CSV-Datei laden //<>//
    Table csv = new Table(name, "header", ',', '"');
    
    if (csv != null  && csv.getColumnCount()==2) {
      
      // Initialisiere Arrays, in die alle Zeilen der Tabelle passen
      zahlen = new int[csv.getRowCount()];
      namen = new String[csv.getRowCount()];
      
      // Fülle die Arrays mit Werten aus der Tabelle
      for (int i = 0; i < zahlen.length; i++) {
        // Lies Wert aus der i. Zeile und der Spalte "Punkte" bzw. "Name"
        zahlen[i] = csv.getInt(i, "Punkte");
        namen[i] = csv.getString(i, "Name");
      }
    }
  }
  
  public void zeichneBalken() {
    
      clear();

        // Überschrift
        fill(255,255,255);
        textFont(grosseSchrift);
        text("Punkte", 2, 20);
        textFont(kleineSchrift);  

        // Alle Einträge darstellen
        if (zahlen != null) {
            for (int i = 0; i< zahlen.length; i++) {

                fill(20,25,165);
                // aktuelle Elemente farblich hervorheben
                if (i == akt) {
                    fill(140,230,20);
                } 
                if (i == akt_minimum) {
                    fill(230,60,140);
                } 

                // Balkendiagramm zeichnen
                if (zahlen[i]>=0) rect(120, 25+i*15, zahlen[i]+1, 13);

                // Beschriftung
                fill(255,255,255);
                text(namen[i], 2, 35+i*15);
                text(""+zahlen[i], 70, 35+i*15);
            }
        }
		refresh();
  }
  
  
   public int minimumsuche() {
        // Sind überhaupt Daten da?
        if(zahlen.length==0 ) { //<>//
            return -1;
        }

        // Startwerte setzen
        akt_minimum = 0;
        akt = 1;

        // Alle Arrayelemente untersuchen
        while (akt < zahlen.length) {
            // Neu zeichnen, da akt neu gesetzt wurde 
            zeichneBalken();
            delay(verzoegerung);
            // Neues kleinstes Element??
            if (zahlen[akt] < zahlen[akt_minimum]) {
                // Dann merke dir das neue 
                akt_minimum = akt;
                // Zeichne Balken neu, da neues kleinstes Element
                zeichneBalken();
                delay(verzoegerung);
            }
            akt = akt + 1;
        }
        zeichneBalken();
        delay(verzoegerung);
        akt=-1;
        zeichneBalken();
        delay(verzoegerung);
        // Gib Position des kleinsten Elements zurück
        return akt_minimum;
    }
  
    public boolean testen() {
        boolean allesBestanden = true;
        // Testfall 1
        verzoegerung = 0; //<>//
        ladeTabelle("testfall1.csv");
        int m1 = minimumsuche();
        if (m1 == 0) {
            System.out.println("Minimum korrekt gefunden. In Datei testfall1.csv ist der größte Wert "+ zahlen[m1]+" von "+namen[m1]+" an Position "+m1);

        } else {
            System.out.println("Minimum in testfall.csv nicht gefunden. Du ermittelst "+m1+" richtig wäre 12");
            allesBestanden = false;
        }
        // Testfall 2: negative Zahlen
        ladeTabelle("testfall2.csv");
        int m2 = minimumsuche();
        if (m2 == 12) {
            System.out.println("Minimum korrekt gefunden. In Datei testfall2.csv ist der größte Wert "+ zahlen[m2]+" von "+namen[m2]+" an Position "+m2);
        } else {
            System.out.println("Minimum in testfall2.csv nicht gefunden. Du ermittelst "+m2+" richtig wäre 3");
            allesBestanden = false;
        }
        // Testfall 3: Nur 1 Element
        ladeTabelle("testfall3.csv");
        int m3 = minimumsuche();
        if (m3 == 0) {
            System.out.println("Minimum korrekt gefunden. In Datei testfall3.csv ist der größte Wert "+ zahlen[m3]+" von "+namen[m3]+" an Position "+m3);
        } else {
            System.out.println("Minimum in testfall3.csv nicht gefunden. Du ermittelst "+m3+" richtig wäre 0");
            allesBestanden = false;
        }
        // Testfall 4: Leere Liste
        ladeTabelle("testfall4.csv");
        int m4 = minimumsuche();
        if (m4 == -1) {
            System.out.println("Minimum korrekt gefunden. Da die Datei keine Spieler enthält wird -1 zurückgegeben.");
        } else {
            System.out.println("Minimum in testfall4.csv nicht gefunden. Du ermittelst "+m4+" richtig wäre -1, da die Datei leer ist.");
            allesBestanden = false;
        } 
        return allesBestanden;
    }
  
  
  
  
}
