import java.awt.Font;

/**
 * XY-Diagramm für Schalldruckpegel, Zahlen werden aus CSV-Datei gelesen.
 * 
 * @author Schaller 
 * @version 29.11.18
 */

public class XYDiagramm extends Picture

{
    // Liste mit allen Werten
    double[] x_werte;    
    double[] y_werte;    

    // Hilfsvariablen für die Suche
    int akt_maximum=-1;    // aktuell groesstes Element
    int akt=-1;            // aktuell untersuchtes Element
    int verzoegerung=0;    // Geschwindigkeit der Ausführung

    // Schriften
  Font kleineSchrift;  
  Font grosseSchrift;

  public XYDiagramm() {
    size(1000, 700);
    background(0);
    kleineSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 12 );
    grosseSchrift = new Font( Font.SANS_SERIF, Font.PLAIN, 20 );
    
    // CSV-Datei laden und anzeigen
    ladeTabelle("Amplitudes.csv");
    stroke(250,250,200);   
    zeichneXYDiagramm();
  }
  


  public void ladeTabelle(String name) {
   // Tabelle aus CSV-Datei laden
        Table csv = new Table(name, "header",',','"');

        if (csv != null  && csv.getColumnCount()==2) {

            // Initialisiere Arrays, in die alle Zeilen der Tabelle passen
            x_werte = new double[csv.getRowCount()];
            y_werte = new double[csv.getRowCount()];

            // Fülle die Arrays mit Werten aus der Tabelle
            for (int i = 0; i < x_werte.length; i++) {  //x_werte.length; i++) {
                // Lies Wert aus der i. Zeile und der Spalte "Punkte" bzw. "Name"
                x_werte[i] = csv.getDouble(i, "Zeit");
                y_werte[i] = csv.getDouble(i, "Laerm");
                System.out.println("Lade Zeile: "+i);
            }
        }
  }
  
  public void zeichneXYDiagramm() {
    
        // Überschrift
        fill(255,255,255);
        textFont(grosseSchrift);
        text("Lärmpegel", 2, 20);
        textFont(kleineSchrift);  

        // Alle Einträge darstellen
        if (x_werte != null) {
            for (int i = 0; i< x_werte.length; i++) {

                fill(20,25,165);

                // XY-Punktdiagramm zeichnen
                int x = (int) x_werte[i];
                int y = (int) y_werte[i];
                point(x,y);
                System.out.println("Zeichne Punkt: "+i);

            }
        }

    }

 
      public int sucheMaximum(double[] zahlen) {
        // Sind überhaupt Daten da?
        if (zahlen.length==0 ) {
            return -1;
        }

        // Startwerte setzen
        akt_maximum = 0;
        akt = 1;

        // Alle Arrayelemente untersuchen
        while (akt < zahlen.length) {

            // Neues größtes Element??
            if (zahlen[akt]> zahlen[akt_maximum]) {
                // Dann merke dir das neue 
                akt_maximum = akt;

            }
            akt = akt + 1;
        }
        // Gib Position des größten Elements zurück
        return akt_maximum;
    }
  
  
}
