/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import logicsim.AND;
import logicsim.BININ;
import logicsim.CLK;
import logicsim.DFlipFlop;
import logicsim.DRFlipFlop;
import logicsim.EQU;
import logicsim.Gate;
import logicsim.GateList;
import logicsim.I18N;
import logicsim.JKCFlipFlop;
import logicsim.JKMSFlipFlop;
import logicsim.LCD;
import logicsim.LED;
import logicsim.MonoFlop;
import logicsim.NAND;
import logicsim.NOR;
import logicsim.NOT;
import logicsim.OR;
import logicsim.OffDelay;
import logicsim.OnDelay;
import logicsim.RSFlipFlop;
import logicsim.SWITCH;
import logicsim.SevenSegment;
import logicsim.TFlipFlop;
import logicsim.TextLabel;
import logicsim.Wire;
import logicsim.XOR;

public class LSPanel
extends JPanel
implements Printable {
    public GateList gates;
    private Gate currentGate;
    private Wire drawingWire;
    private int movingPoint;
    private int currentAction;
    private JLabel statusBar;
    private Point lastWirePoint = new Point();
    private Point mousePos = new Point();
    public boolean simulationRunning = false;
    private int lastAction;
    private int lastActionInputNum;
    private Gate lastClickedGate = null;
    private boolean paintGrid = true;
    public boolean changed = false;
    private Dimension panelSize = new Dimension(1280, 1024);
    static final int ACTION_AND = 1;
    static final int ACTION_NAND = 2;
    static final int ACTION_NOT = 3;
    static final int ACTION_SWITCH = 4;
    static final int ACTION_LED = 5;
    static final int ACTION_RSFF = 6;
    static final int ACTION_JKFFC = 7;
    static final int ACTION_JKMSFF = 8;
    static final int ACTION_OR = 9;
    static final int ACTION_NOR = 10;
    static final int ACTION_XOR = 11;
    static final int ACTION_EQU = 12;
    static final int ACTION_CLK = 13;
    static final int ACTION_CONNECT = 14;
    static final int ACTION_DRAWWIRE = 15;
    static final int ACTION_ADDPOINT = 16;
    static final int ACTION_DELPOINT = 17;
    static final int ACTION_MODULE = 18;
    static final int ACTION_BININ = 19;
    static final int ACTION_LCD = 20;
    static final int ACTION_TFF = 21;
    static final int ACTION_MONOFLOP = 22;
    static final int ACTION_DFF = 23;
    static final int ACTION_INNORM = 24;
    static final int ACTION_INNEG = 25;
    static final int ACTION_INHIGH = 26;
    static final int ACTION_INLOW = 27;
    static final int ACTION_ONDELAY = 28;
    static final int ACTION_OFFDELAY = 29;
    static final int ACTION_TEXTLABEL = 30;
    static final int ACTION_SEVENSEGMENT = 31;
    static final int ACTION_DRFF = 32;

    public LSPanel(JLabel jLabel) {
        this.statusBar = jLabel;
        this.gates = new GateList();
        this.setSize(this.panelSize);
        this.setPreferredSize(this.panelSize);
        this.revalidate();
        this.setCursor(new Cursor(0));
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                LSPanel.this.myKeyPressed(keyEvent);
            }
        });
    }

    public void setAction(int n) {
        this.setAction(n, 2);
    }

    public void setAction(int n, int n2) {
        this.lastAction = n;
        this.lastActionInputNum = n2;
        Gate gate = null;
        switch (n) {
            case 1: {
                gate = new AND(n2);
                break;
            }
            case 2: {
                gate = new NAND(n2);
                break;
            }
            case 9: {
                gate = new OR(n2);
                break;
            }
            case 10: {
                gate = new NOR(n2);
                break;
            }
            case 11: {
                gate = new XOR(n2);
                break;
            }
            case 12: {
                gate = new EQU(n2);
                break;
            }
            case 3: {
                gate = new NOT();
                break;
            }
            case 4: {
                gate = new SWITCH();
                break;
            }
            case 5: {
                gate = new LED();
                break;
            }
            case 6: {
                gate = new RSFlipFlop();
                break;
            }
            case 7: {
                gate = new JKCFlipFlop();
                break;
            }
            case 8: {
                gate = new JKMSFlipFlop();
                break;
            }
            case 21: {
                gate = new TFlipFlop();
                break;
            }
            case 13: {
                gate = new CLK();
                break;
            }
            case 19: {
                gate = new BININ();
                break;
            }
            case 20: {
                gate = new LCD();
                break;
            }
            case 31: {
                gate = new SevenSegment();
                break;
            }
            case 22: {
                gate = new MonoFlop();
                break;
            }
            case 28: {
                gate = new OnDelay();
                break;
            }
            case 29: {
                gate = new OffDelay();
                break;
            }
            case 23: {
                gate = new DFlipFlop();
                break;
            }
            case 32: {
                gate = new DRFlipFlop();
                break;
            }
            case 30: {
                gate = new TextLabel();
                break;
            }
            case 24: {
                this.statusBar.setText(I18N.getString("STATUS_INPUTNORMAL"));
                break;
            }
            case 25: {
                this.statusBar.setText(I18N.getString("STATUS_INPUTINV"));
                break;
            }
            case 26: {
                this.statusBar.setText(I18N.getString("STATUS_INPUTHIGH"));
                break;
            }
            case 27: {
                this.statusBar.setText(I18N.getString("STATUS_INPUTLOW"));
                break;
            }
            case 16: {
                this.statusBar.setText(I18N.getString("STATUS_ADDPOINT"));
                break;
            }
            case 17: {
                this.statusBar.setText(I18N.getString("STATUS_REMOVEPOINT"));
            }
        }
        this.currentAction = n;
        if (gate != null) {
            this.gates.deactivateAll();
            this.currentGate = gate;
        }
    }

    public void setAction(int n, Gate gate) {
        this.currentAction = n;
        if (gate != null) {
            this.currentGate = gate;
        }
    }

    public void setPaintGrid(boolean bl) {
        this.paintGrid = bl;
    }

    public void draw(Graphics graphics) {
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate gate = this.gates.get(i);
            gate.draw(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.panelSize.width, this.panelSize.height);
        if (this.paintGrid) {
            graphics.setColor(Color.black);
            for (int i = 0; i < this.panelSize.width; i += 10) {
                for (int j = 0; j < this.panelSize.height; j += 10) {
                    graphics.drawLine(i, j, i, j);
                }
            }
        }
        this.draw(graphics);
        if (this.currentGate != null) {
            this.currentGate.draw(graphics);
        }
        if (this.drawingWire != null && this.movingPoint == 0) {
            this.drawingWire.draw(graphics);
            graphics.drawLine(this.lastWirePoint.x, this.lastWirePoint.y, this.mousePos.x, this.mousePos.y);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getModifiers();
        Graphics graphics = this.getGraphics();
        if (n == 506 || n == 503) {
            int n3;
            int n4;
            Polygon polygon;
            int n5 = mouseEvent.getPoint().x;
            int n6 = mouseEvent.getPoint().y;
            n5 = n5 / 10 * 10;
            n6 = n6 / 10 * 10;
            if (n2 == 1 && this.drawingWire != null && this.movingPoint == 0) {
                polygon = this.drawingWire.poly;
                n4 = polygon.xpoints[polygon.npoints - 1];
                n3 = polygon.ypoints[polygon.npoints - 1];
                if (Math.abs(n5 - n4) < Math.abs(n6 - n3)) {
                    n5 = n4;
                } else {
                    n6 = n3;
                }
            }
            if (this.drawingWire != null && this.movingPoint == 0) {
                polygon = this.drawingWire.poly;
                this.lastWirePoint.setLocation(polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]);
                this.mousePos.setLocation(n5, n6);
                this.changed = true;
                this.repaint();
            }
            if (this.drawingWire != null && this.movingPoint > 0) {
                int n7 = this.drawingWire.poly.xpoints[this.movingPoint];
                n4 = this.drawingWire.poly.ypoints[this.movingPoint];
                this.drawingWire.setPolyPoint(this.movingPoint, n5, n6);
                for (n3 = 0; n3 < this.gates.size(); ++n3) {
                    Gate gate = this.gates.get(n3);
                    for (int i = 0; i < gate.getNumInput(); ++i) {
                        int n8;
                        Wire wire = gate.getInput(i);
                        if (wire == null || (n8 = wire.hasPointAt(n7, n4)) <= 0 || wire.poly.xpoints[n8 - 1] != this.drawingWire.poly.xpoints[this.movingPoint - 1] || wire.poly.ypoints[n8 - 1] != this.drawingWire.poly.ypoints[this.movingPoint - 1]) continue;
                        wire.setPolyPoint(n8, n5, n6);
                        this.changed = true;
                    }
                }
                this.repaint();
            }
            if (this.currentGate != null) {
                this.currentGate.moveTo(n5, n6, this.gates);
                this.changed = true;
                this.repaint();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getPoint().x;
        int n3 = mouseEvent.getPoint().y;
        int n4 = mouseEvent.getModifiers();
        this.requestFocusInWindow();
        if (n == 501 && (n4 & 0x10) > 0) {
            if (this.currentAction == 16 && this.drawingWire == null) {
                block6: for (int i = 0; i < this.gates.size(); ++i) {
                    Gate gate = this.gates.get(i);
                    for (int j = 0; j < gate.getNumInput(); ++j) {
                        int n5;
                        Wire wire = gate.getInput(j);
                        if (wire == null || (n5 = wire.tryInsertPoint(n2, n3)) <= 0) continue;
                        this.drawingWire = wire;
                        wire.activate();
                        this.repaint();
                        this.movingPoint = n5;
                        this.changed = true;
                        continue block6;
                    }
                }
                this.statusBar.setText(" ");
                this.currentAction = 0;
            } else if (this.currentAction == 17 && this.drawingWire == null) {
                block8: for (int i = 0; i < this.gates.size(); ++i) {
                    Gate gate = this.gates.get(i);
                    for (int j = 0; j < gate.getNumInput(); ++j) {
                        Wire wire = gate.getInput(j);
                        if (wire == null || !wire.tryRemovePoint(n2, n3)) continue;
                        wire.activate();
                        this.repaint();
                        this.changed = true;
                        continue block8;
                    }
                }
                this.statusBar.setText(" ");
                this.currentAction = 0;
            } else if (this.drawingWire != null && this.movingPoint == 0) {
                n2 = n2 / 10 * 10;
                n3 = n3 / 10 * 10;
                for (int i = 0; i < this.gates.size(); ++i) {
                    Gate gate = this.gates.get(i);
                    if (gate.getNumInput() <= 0 || !gate.tryConnectInput(this.mousePos.x, this.mousePos.y, this.drawingWire)) continue;
                    this.drawingWire = null;
                    this.statusBar.setText(I18N.getString("STATUS_CONNECTED"));
                    this.repaint();
                    this.changed = true;
                }
                if (this.statusBar.getText() != I18N.getString("STATUS_CONNECTED")) {
                    this.drawingWire.addPoint(this.mousePos.x, this.mousePos.y);
                    this.drawingWire.draw(this.getGraphics());
                    this.changed = true;
                }
            } else if (this.currentAction == 25 || this.currentAction == 26 || this.currentAction == 27 || this.currentAction == 24) {
                int n6 = 0;
                switch (this.currentAction) {
                    case 25: {
                        n6 = 1;
                        break;
                    }
                    case 26: {
                        n6 = 2;
                        break;
                    }
                    case 27: {
                        n6 = 3;
                        break;
                    }
                    case 24: {
                        n6 = 0;
                    }
                }
                for (int i = 0; i < this.gates.size(); ++i) {
                    Gate gate = this.gates.get(i);
                    if (!gate.trySetInputType(n2, n3, n6)) continue;
                    this.repaint();
                    this.changed = true;
                    break;
                }
                this.statusBar.setText(" ");
                this.currentAction = 0;
            } else {
                int n7;
                Wire wire;
                int n8;
                Serializable serializable;
                int n9;
                Serializable serializable2;
                int n10;
                this.gates.deactivateAll();
                for (n10 = 0; n10 < this.gates.size(); ++n10) {
                    serializable2 = this.gates.get(n10);
                    if (!((Gate)serializable2).inside(n2, n3)) continue;
                    if (this.simulationRunning) {
                        ((Gate)serializable2).clicked(n2, n3);
                        this.lastClickedGate = serializable2;
                    } else {
                        this.currentGate = serializable2;
                        this.currentGate.activate();
                        this.changed = true;
                    }
                    this.repaint();
                    return;
                }
                if (this.currentGate == null) {
                    for (n10 = 0; n10 < this.gates.size(); ++n10) {
                        serializable2 = this.gates.get(n10).tryConnectOutput(n2, n3);
                        if (serializable2 == null) continue;
                        this.drawingWire = serializable2;
                        this.currentAction = 0;
                        this.statusBar.setText(I18N.getString("STATUS_SETINPUT"));
                        this.changed = true;
                        return;
                    }
                }
                if (this.drawingWire == null && (n4 & 1) == 0) {
                    for (n10 = 0; n10 < this.gates.size(); ++n10) {
                        serializable2 = this.gates.get(n10);
                        for (n9 = 0; n9 < ((Gate)serializable2).getNumInput(); ++n9) {
                            serializable = ((Gate)serializable2).getInput(n9);
                            if (serializable == null || (n8 = ((Wire)serializable).hasPointAt(n2, n3)) <= 0) continue;
                            this.drawingWire = serializable;
                            this.drawingWire.activate();
                            this.movingPoint = n8;
                            this.changed = true;
                            return;
                        }
                    }
                }
                if (this.drawingWire == null && (n4 & 1) == 1) {
                    for (n10 = 0; n10 < this.gates.size(); ++n10) {
                        serializable2 = this.gates.get(n10);
                        for (n9 = 0; n9 < ((Gate)serializable2).getNumInput(); ++n9) {
                            serializable = ((Gate)serializable2).getInput(n9);
                            if (serializable == null || (n8 = ((Wire)serializable).hasPointAt(n2, n3)) <= 0) continue;
                            ((Wire)serializable).setNode(n8);
                            this.drawingWire = (Wire)((Wire)serializable).clone();
                            this.drawingWire.setPolySize(n8 + 1);
                            this.drawingWire.activate();
                            this.movingPoint = 0;
                            Polygon polygon = this.drawingWire.poly;
                            this.statusBar.setText(" ");
                            this.changed = true;
                            return;
                        }
                    }
                }
                n10 = n2 / 10 * 10;
                int n11 = n3 / 10 * 10;
                if ((n4 & 1) == 1) {
                    for (n9 = 0; n9 < this.gates.size(); ++n9) {
                        serializable = this.gates.get(n9);
                        for (n8 = 0; n8 < ((Gate)serializable).getNumInput(); ++n8) {
                            wire = ((Gate)serializable).getInput(n8);
                            if (wire == null || (n7 = wire.tryInsertPoint(n10, n11)) <= 0) continue;
                            for (int i = 0; i < this.gates.size(); ++i) {
                                Gate gate = this.gates.get(i);
                                for (int j = 0; j < gate.getNumInput(); ++j) {
                                    int n12;
                                    Wire wire2 = gate.getInput(j);
                                    if (wire2 == null || (n12 = wire2.inside(n10, n11)) < 0 || wire2.hasPointAt(n10, n11) != -1) continue;
                                    wire2.insertPointAfter(n12, n10, n11);
                                    wire2.setNode(n12);
                                }
                            }
                            wire.setNode(n7);
                            this.drawingWire = (Wire)wire.clone();
                            this.drawingWire.setPolySize(n7 + 1);
                            this.drawingWire.activate();
                            this.movingPoint = 0;
                            Polygon polygon = this.drawingWire.poly;
                            this.statusBar.setText(" ");
                            this.repaint();
                            this.changed = true;
                            return;
                        }
                    }
                }
                if ((n4 & 2) == 2) {
                    for (n9 = 0; n9 < this.gates.size(); ++n9) {
                        serializable = this.gates.get(n9);
                        for (n8 = 0; n8 < ((Gate)serializable).getNumInput(); ++n8) {
                            wire = ((Gate)serializable).getInput(n8);
                            if (wire == null || (n7 = wire.tryInsertPoint(n2, n3)) <= 0) continue;
                            this.drawingWire = wire;
                            wire.activate();
                            this.repaint();
                            this.movingPoint = n7;
                            this.statusBar.setText(" ");
                            this.changed = true;
                            return;
                        }
                    }
                }
                for (n9 = 0; n9 < this.gates.size(); ++n9) {
                    serializable = this.gates.get(n9);
                    for (n8 = 0; n8 < ((Gate)serializable).getNumInput(); ++n8) {
                        wire = ((Gate)serializable).getInput(n8);
                        if (wire == null || wire.inside(n2, n3) < 0) continue;
                        wire.activate();
                        this.repaint();
                        this.changed = true;
                    }
                }
            }
        } else if (n == 502 && (n4 & 0x10) > 0) {
            if (this.currentGate != null) {
                if (!this.gates.gates.contains(this.currentGate)) {
                    this.gates.addGate(this.currentGate);
                }
                this.currentGate = null;
                this.currentAction = 0;
                this.changed = true;
            }
            if (this.movingPoint > 0) {
                this.drawingWire = null;
                this.movingPoint = 0;
            }
            if (this.simulationRunning && this.lastClickedGate != null) {
                this.lastClickedGate.mouseReleased();
            }
        }
    }

    protected void myKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyModifiersText(n2);
        if (n == 27) {
            if (this.currentGate != null) {
                this.currentGate = null;
            } else if (this.drawingWire != null) {
                if (this.drawingWire.removeLastPoint()) {
                    Polygon polygon = this.drawingWire.poly;
                    this.lastWirePoint.setLocation(polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]);
                } else {
                    this.drawingWire = null;
                }
            }
            this.statusBar.setText(I18N.getString("STATUS_ABORTED"));
            this.repaint();
        } else if (n == 127) {
            for (int i = 0; i < this.gates.size(); ++i) {
                Gate gate = this.gates.get(i);
                if (gate.active) {
                    this.gates.remove(i);
                    this.repaint();
                    this.changed = true;
                    break;
                }
                for (int j = 0; j < gate.getNumInput(); ++j) {
                    Wire wire = gate.getInput(j);
                    if (wire == null || !wire.active || gate.inputTypes[j] > 1) continue;
                    gate.setInput(j, null);
                    this.repaint();
                    this.changed = true;
                    return;
                }
            }
        } else if (n == 32) {
            this.setAction(this.lastAction, this.lastActionInputNum);
            this.changed = true;
            this.repaint();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        this.draw(graphics);
        return 0;
    }

    public void doPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

