/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.Vector;
import logicsim.Gate;

public class Wire
implements Serializable,
Cloneable {
    static final long serialVersionUID = -7554728800898882892L;
    public transient Gate gate;
    public transient int outNum;
    transient boolean active;
    Polygon poly;
    Vector nodes;

    public Wire(Gate gate, int n) {
        this.gate = gate;
        this.poly = new Polygon();
        this.nodes = new Vector();
        this.outNum = n;
        this.active = true;
    }

    public void addPoint(int n, int n2) {
        this.poly.addPoint(n, n2);
        this.nodes.setSize(this.poly.npoints);
        for (int i = 0; i < this.nodes.size(); ++i) {
            Boolean bl = (Boolean)this.nodes.get(i);
            if (bl != null) continue;
            this.nodes.setElementAt(new Boolean(false), i);
        }
    }

    public final void activate() {
        this.active = true;
    }

    public final void deactivate() {
        this.active = false;
    }

    public boolean removePoint(int n) {
        if (this.poly.npoints == 1) {
            return false;
        }
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.poly.npoints; ++i) {
            if (i == n) continue;
            polygon.addPoint(this.poly.xpoints[i], this.poly.ypoints[i]);
        }
        this.nodes.removeElementAt(n);
        this.poly = polygon;
        return true;
    }

    public boolean removeLastPoint() {
        if (this.poly.npoints == 1) {
            return false;
        }
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.poly.npoints - 1; ++i) {
            polygon.addPoint(this.poly.xpoints[i], this.poly.ypoints[i]);
        }
        this.poly = polygon;
        this.nodes.setSize(this.poly.npoints);
        return true;
    }

    public void setFirstPoint(int n, int n2) {
        if (this.poly == null) {
            return;
        }
        this.poly.xpoints[0] = n;
        this.poly.ypoints[0] = n2;
    }

    public void setLastPoint(int n, int n2) {
        if (this.poly == null || this.poly.npoints < 1) {
            return;
        }
        this.poly.xpoints[this.poly.npoints - 1] = n;
        this.poly.ypoints[this.poly.npoints - 1] = n2;
    }

    public int inside(int n, int n2) {
        for (int i = 0; i < this.poly.npoints - 1; ++i) {
            Line2D.Float float_ = new Line2D.Float(this.poly.xpoints[i], this.poly.ypoints[i], this.poly.xpoints[i + 1], this.poly.ypoints[i + 1]);
            if (!(float_.ptSegDist(n, n2) < 3.0)) continue;
            return i;
        }
        return -1;
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(Color.black);
        if (this.active) {
            graphics2D.setStroke(new BasicStroke(2.0f));
        } else if (this.getState()) {
            graphics.setColor(Color.red);
        }
        graphics.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (int i = 1; i < this.poly.npoints - 1; ++i) {
            if (this.active) {
                graphics2D.setColor(Color.darkGray);
                graphics2D.fillRect(this.poly.xpoints[i] - 2, this.poly.ypoints[i] - 2, 5, 5);
            }
            graphics2D.setColor(Color.black);
            Boolean bl = (Boolean)this.nodes.get(i);
            if (bl == null || !bl.booleanValue()) continue;
            graphics2D.fillRect(this.poly.xpoints[i] - 2, this.poly.ypoints[i] - 2, 5, 5);
        }
    }

    public boolean getState() {
        if (this.gate != null) {
            return this.gate.getOutput(this.outNum);
        }
        return false;
    }

    public int hasPointAt(int n, int n2) {
        for (int i = 1; i < this.poly.npoints - 1; ++i) {
            if (n <= this.poly.xpoints[i] - 3 || n >= this.poly.xpoints[i] + 3 || n2 <= this.poly.ypoints[i] - 3 || n2 >= this.poly.ypoints[i] + 3) continue;
            return i;
        }
        return -1;
    }

    public void setPolyPoint(int n, int n2, int n3) {
        this.poly.xpoints[n] = n2;
        this.poly.ypoints[n] = n3;
    }

    public void insertPointAfter(int n, int n2, int n3) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.poly.npoints; ++i) {
            polygon.addPoint(this.poly.xpoints[i], this.poly.ypoints[i]);
            if (i != n) continue;
            polygon.addPoint(n2, n3);
        }
        this.poly = polygon;
        this.nodes.setSize(this.poly.npoints);
    }

    public int tryInsertPoint(int n, int n2) {
        if (this.hasPointAt(n, n2) >= 0) {
            return -1;
        }
        for (int i = 0; i < this.poly.npoints - 1; ++i) {
            Line2D.Float float_ = new Line2D.Float(this.poly.xpoints[i], this.poly.ypoints[i], this.poly.xpoints[i + 1], this.poly.ypoints[i + 1]);
            if (!(float_.ptSegDist(n, n2) < 3.0)) continue;
            this.insertPointAfter(i, n, n2);
            return i + 1;
        }
        return -1;
    }

    public boolean tryRemovePoint(int n, int n2) {
        int n3 = this.hasPointAt(n, n2);
        if (n3 > 0) {
            return this.removePoint(n3);
        }
        return false;
    }

    public void setNode(int n) {
        if (n > 0 && n < this.poly.npoints) {
            this.nodes.setElementAt(new Boolean(true), n);
        }
    }

    public boolean trySetNode(int n, int n2) {
        int n3 = this.hasPointAt(n, n2);
        if (n3 > 0) {
            this.setNode(n3);
            return true;
        }
        return false;
    }

    public void printInfo() {
        System.out.println("This wire " + this.toString() + " is connected to to gate " + this.gate);
    }

    public Object clone() {
        Wire wire = null;
        try {
            wire = (Wire)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        wire.poly = new Polygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        wire.nodes = (Vector)this.nodes.clone();
        return wire;
    }

    public void setPolySize(int n) {
        if (this.poly.npoints == 1) {
            return;
        }
        Polygon polygon = new Polygon();
        for (int i = 0; i < n && i < this.poly.npoints; ++i) {
            polygon.addPoint(this.poly.xpoints[i], this.poly.ypoints[i]);
        }
        this.nodes.setSize(n);
        this.poly = polygon;
    }
}

