/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import logicsim.Gate;
import logicsim.I18N;

public class SWITCH
extends Gate {
    static final long serialVersionUID = 2459367526586913840L;
    boolean click = false;
    transient long clickCountDown = 0L;
    transient boolean mouseDown = false;

    public SWITCH() {
        this.out[0] = false;
        this.imagename = "Switch";
        this.onimagename = "Switch_on";
    }

    public int getNumInput() {
        return 0;
    }

    public int getNumOutput() {
        return 1;
    }

    public void setOutput(boolean bl) {
        this.out[0] = bl;
    }

    public void clicked(int n, int n2) {
        if (this.click) {
            this.out[0] = true;
            this.mouseDown = true;
            this.clickCountDown = 2L;
        } else {
            this.out[0] = !this.out[0];
        }
    }

    public void mouseReleased() {
        this.mouseDown = false;
    }

    public void simulate() {
        if (this.click) {
            if (this.clickCountDown > 0L) {
                --this.clickCountDown;
            }
            if (this.clickCountDown == 0L && !this.mouseDown) {
                this.out[0] = false;
            }
        }
    }

    public void draw(Graphics graphics) {
        if (this.onimage == null) {
            this.loadImage();
        }
        super.draw(graphics);
        if (this.out[0]) {
            graphics.drawImage(this.onimage, this.x + 3, this.y, null);
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public boolean showProperties(Component component) {
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        if (this.click) {
            jRadioButton2.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        EtchedBorder etchedBorder = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), I18N.getString("GATE_SWITCH_TYPE"));
        jRadioButton.setText(I18N.getString("GATE_SWITCH_TOGGLE"));
        jRadioButton2.setText(I18N.getString("GATE_SWITCH_CLICK"));
        jPanel.setBorder(titledBorder);
        jPanel.setBounds(new Rectangle(11, 11, 171, 150));
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)jRadioButton, "North");
        jPanel.add((Component)jRadioButton2, "Center");
        JOptionPane jOptionPane = new JOptionPane(jPanel);
        jOptionPane.setMessageType(3);
        jOptionPane.setOptions(new String[]{I18N.getString("BUTTON_USE"), I18N.getString("BUTTON_CANCEL")});
        JDialog jDialog = jOptionPane.createDialog(component, I18N.getString("GATE_SWITCH_TYPE"));
        jDialog.setResizable(true);
        jDialog.setSize(290, 180);
        jDialog.show();
        if (I18N.getString("BUTTON_USE").equals((String)jOptionPane.getValue())) {
            if (jRadioButton.isSelected()) {
                this.click = false;
            } else if (jRadioButton2.isSelected()) {
                this.click = true;
            }
            return true;
        }
        return false;
    }

    public void reset() {
    }
}

