/**
  * Die Klasse Spieler speichert die Daten eines Spielers fr das Spiel Craps.
  *
  * @version 1.0 vom 19.06.2012
  * @author Thomas Schaller
  */
  
public class Spieler {
  // Anfang Attribute
  private int guthaben; // Guthaben des Spielers
  private int einsatz = 0; // Betrag den der Spieler gesetzt hat

  private boolean shooter;
  // Ende Attribute

  /** Erzeugt einen Spieler mit einem bestimmten Startguthaben.
  * @param guthaben Startguthaben des Spielers
  */
  public Spieler(int guthaben) {
    this.guthaben = guthaben;
    this.einsatz = 0;
    this.shooter = false;
  }

  // Anfang Methoden
  
  /** Liefert das aktuelle Guthaben des Spielers.
  * @return Guthaben des Spielers
  */
  public int getGuthaben() {
    return guthaben;
  }

  /** Setzt den Einsatz fr das nchste Spiel.
  * @param betrag eingesetzter Betrag
  */
  public void setze(int betrag) {
    einsatz += betrag;
    guthaben -= betrag;
  }

  /** Rechnet den Gewinn des Spielers ab, da er gewonnen hat.
  */
  public void gewonnen() {
    guthaben += (2 * einsatz);
    einsatz = 0;
  }

  /** Da der Spieler verloren hat, ist der Einsatz verloren.
  */
  public void verloren() {
    einsatz = 0;
  }

  /** Meldet, ob der Spieler der Shooter ist.
   *  @return true, wenn der Spieler Shooter ist, false, wenn er Fader ist
  */
  public boolean getShooter() {
    return shooter;
  }
  
  /** Setze, ob der Spieler Shooter oder Fader ist
    * @param shooter true, wenn der Spieler Shooter werden soll, false, wenn der Spieler Fader werden soll.
    */
  public void setShooter(boolean shooter) {
    this.shooter = shooter;
  }

  // Ende Methoden
} // end of Spieler
