import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  * Stellt eine GUI fr das Spiel 6er-Wrfeln bereit. Es knnen zwei Spieler
  * gegeneinander spielen. Es startet immer Spieler 1. Dieser kann so lange
  * wrfeln wie er mchte, solange er keine 6 wrfelt. Danach werden die Buttons
  * fr Spieler 2 aktiviert.
  *
  * @version 1.0 vom 16.06.2012
  * @author Thomas Schaller
  */

public class SechserWuerfelnGUI extends JFrame {

  // Anfang Attribute

  // Wrfel fr das Spiel erzeugen
  private Wuerfel w = new Wuerfel();
  // Zwei Spieler erzeugen
  private Spieler sp1 = new Spieler();
  private Spieler sp2 = new Spieler();
  
  // Elemente der GUI
  private JPanel jPanel1 = new JPanel(null, true);
  private JLabel jLabel1 = new JLabel();
  private JNumberField jNFGesamtpunkte1 = new JNumberField();
  private JPanel jPanel3 = new JPanel(null, true);
  private JButton jBSpieler1Wuerfeln = new JButton();
  private JButton jBSpieler1Beenden = new JButton();
  private JLabel jLabel4 = new JLabel();
  private JLabel jLabel5 = new JLabel();
  private JNumberField jNFWuerfel1 = new JNumberField();
  private JNumberField jNFPunkte1 = new JNumberField();
  private JLabel jLabel3 = new JLabel();
  private WuerfelPanel wuerfelPanel1 = new WuerfelPanel(w);
  private JPanel jPanel11 = new JPanel(null, true);
  private JLabel jLabel11 = new JLabel();
  private JNumberField jNFGesamtpunkte2 = new JNumberField();
  private JPanel jPanel31 = new JPanel(null, true);
  private JButton jBSpieler2Wuerfeln = new JButton();
  private JButton jBSpieler2Beenden = new JButton();
  private JNumberField jNFWuerfel2 = new JNumberField();
  private JNumberField jNFPunkte2 = new JNumberField();
  private JLabel jLabel41 = new JLabel();
  private JLabel jLabel51 = new JLabel();
  private JLabel jLabel31 = new JLabel();
  // Ende Attribute
  
  /** Erzeugt die GUI
  * @param title Fenstertitel
  */
  public SechserWuerfelnGUI(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 536; 
    int frameHeight = 205;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jPanel1.setBounds(8, 8, 193, 161);
    jPanel1.setOpaque(true);
    jPanel1.setBackground(new Color(0xC0C0C0));
    cp.add(jPanel1);
    jLabel1.setBounds(8, 8, 110, 20);
    jLabel1.setText("Spieler 1");
    jPanel1.add(jLabel1);
    wuerfelPanel1.setBounds(216, 40, 97, 89);
    cp.add(wuerfelPanel1);
    jNFGesamtpunkte1.setBounds(120, 32, 51, 20);
    jNFGesamtpunkte1.setText("0");
    jNFGesamtpunkte1.setEditable(false);
    jNFGesamtpunkte1.setHorizontalAlignment(SwingConstants.RIGHT);
    jPanel1.add(jNFGesamtpunkte1);
    jPanel3.setBounds(8, 64, 177, 89);
    jPanel3.setOpaque(false);
    jPanel3.setBorder(BorderFactory.createEtchedBorder(1, new Color(0xC0C0C0), Color.DARK_GRAY));
    jPanel1.add(jPanel3);
    jLabel3.setBounds(8, 32, 94, 20);
    jLabel3.setText("Gesamtpunkte");
    jPanel1.add(jLabel3);
    jBSpieler1Wuerfeln.setBounds(8, 56, 75, 25);
    jBSpieler1Wuerfeln.setText("Wrfeln");
    jBSpieler1Wuerfeln.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Wuerfeln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler1Wuerfeln_ActionPerformed(evt);
      }
    });
    jPanel3.add(jBSpieler1Wuerfeln);
    jBSpieler1Beenden.setBounds(88, 56, 75, 25);
    jBSpieler1Beenden.setText("Sichern");
    jBSpieler1Beenden.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Beenden.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler1Beenden_ActionPerformed(evt);
      }
    });
    jPanel3.add(jBSpieler1Beenden);
    jLabel4.setBounds(8, 8, 88, 20);
    jLabel4.setText("aktueller Wurf:");
    jPanel3.add(jLabel4);
    jLabel5.setBounds(8, 32, 86, 20);
    jLabel5.setText("Punkte:");
    jPanel3.add(jLabel5);
    jNFWuerfel1.setBounds(112, 8, 51, 20);
    jNFWuerfel1.setText("");
    jNFWuerfel1.setEditable(false);
    jNFWuerfel1.setHorizontalAlignment(SwingConstants.CENTER);
    jPanel3.add(jNFWuerfel1);
    jNFPunkte1.setBounds(112, 32, 51, 20);
    jNFPunkte1.setText("");
    jNFPunkte1.setEditable(false);
    jNFPunkte1.setHorizontalAlignment(SwingConstants.CENTER);
    jPanel3.add(jNFPunkte1);
    jPanel11.setBounds(328, 8, 193, 161);
    jPanel11.setOpaque(true);
    jPanel11.setBackground(new Color(0xC0C0C0));
    cp.add(jPanel11);
    jLabel11.setBounds(8, 8, 110, 20);
    jLabel11.setText("Spieler 2");
    jPanel11.add(jLabel11);
    jNFGesamtpunkte2.setBounds(120, 32, 51, 20);
    jNFGesamtpunkte2.setText("0");
    jNFGesamtpunkte2.setEditable(false);
    jNFGesamtpunkte2.setHorizontalAlignment(SwingConstants.RIGHT);
    jPanel11.add(jNFGesamtpunkte2);
    jPanel31.setBounds(8, 64, 177, 89);
    jPanel31.setOpaque(false);
    jPanel31.setBorder(BorderFactory.createEtchedBorder(1, new Color(0xC0C0C0), Color.DARK_GRAY));
    jPanel11.add(jPanel31);
    jLabel31.setBounds(8, 32, 94, 20);
    jLabel31.setText("Gesamtpunkte");
    jPanel11.add(jLabel31);
    jBSpieler2Wuerfeln.setBounds(8, 56, 75, 25);
    jBSpieler2Wuerfeln.setText("Wrfeln");
    jBSpieler2Wuerfeln.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Wuerfeln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler2Wuerfeln_ActionPerformed(evt);
      }
    });
    jBSpieler2Wuerfeln.setEnabled(false);
    jPanel31.add(jBSpieler2Wuerfeln);
    jBSpieler2Beenden.setBounds(88, 56, 75, 25);
    jBSpieler2Beenden.setText("Sichern");
    jBSpieler2Beenden.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Beenden.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler2Beenden_ActionPerformed(evt);
      }
    });
    jBSpieler2Beenden.setEnabled(false);
    jPanel31.add(jBSpieler2Beenden);
    jNFWuerfel2.setBounds(112, 8, 51, 20);
    jNFWuerfel2.setText("");
    jNFWuerfel2.setEditable(false);
    jNFWuerfel2.setHorizontalAlignment(SwingConstants.CENTER);
    jPanel31.add(jNFWuerfel2);
    jNFPunkte2.setBounds(112, 32, 51, 20);
    jNFPunkte2.setText("");
    jNFPunkte2.setEditable(false);
    jNFPunkte2.setHorizontalAlignment(SwingConstants.CENTER);
    jPanel31.add(jNFPunkte2);
    jLabel41.setBounds(8, 8, 88, 20);
    jLabel41.setText("aktueller Wurf:");
    jPanel31.add(jLabel41);
    jLabel51.setBounds(8, 32, 86, 20);
    jLabel51.setText("Punkte:");
    jPanel31.add(jLabel51);
    // Ende Komponenten

    // Spieler ber den Wrfel informieren
    sp1.setWuerfel(w);
    sp2.setWuerfel(w);

    setVisible(true);
  } // end of public SechserWuerfelnGUI
  
  // Anfang Methoden
  /** Spieler 1 drckt den Button Wrfeln
  */
  public void jBSpieler1Wuerfeln_ActionPerformed(ActionEvent evt) {
    // wrfeln
    sp1.wuerfeln();

    // Anzeigen aktualisieren
    jNFPunkte1.setInt(sp1.getSumme());
    jNFWuerfel1.setInt(w.getWurf());
    wuerfelPanel1.repaint();

    // Bei einer 6 muss der Spieler aufhren und Spieler 2 ist dran
    if (w.getWurf() == 6) {
      jBSpieler1Beenden_ActionPerformed(evt);
    } // end of if
    
  } // end of jBSpieler1Wuerfeln_ActionPerformed
  
  /** Spieler 1 drckt Button Beenden
  */
  public void jBSpieler1Beenden_ActionPerformed(ActionEvent evt) {
    // Punkte sichern
    sp1.aufhoeren();

    // Anzeigen aktualisieren
    jNFGesamtpunkte1.setInt(sp1.getGesamtsumme());

    // Buttons aktivieren/deaktivieren
    jBSpieler1Wuerfeln.setEnabled(false);
    jBSpieler1Beenden.setEnabled(false);
    jBSpieler2Wuerfeln.setEnabled(true);
    jBSpieler2Beenden.setEnabled(true);
  } // end of jBSpieler1Beenden_ActionPerformed
  
  /** Spieler 2 drckt den Button Wrfeln
  */
  public void jBSpieler2Wuerfeln_ActionPerformed(ActionEvent evt) {
    // wrfeln
    sp2.wuerfeln();

    // Anzeigen aktualisieren
    jNFPunkte2.setInt(sp2.getSumme());
    jNFWuerfel2.setInt(w.getWurf());
    wuerfelPanel1.repaint();

    // Bei einer 6 muss der Spieler aufhren und Spieler 2 ist dran
    if (w.getWurf() == 6) {
      jBSpieler2Beenden_ActionPerformed(evt);
    } // end of if
  } // end of jBSpieler2Wuerfeln_ActionPerformed
  
  /** Spieler 1 drckt Button Beenden
  */
  public void jBSpieler2Beenden_ActionPerformed(ActionEvent evt) {
    // Punkte sichern
    sp2.aufhoeren();

    // Anzeigen aktualisieren
    jNFGesamtpunkte2.setInt(sp2.getGesamtsumme());

    // Buttons aktivieren/deaktivieren
    jBSpieler2Wuerfeln.setEnabled(false);
    jBSpieler2Beenden.setEnabled(false);
    jBSpieler1Wuerfeln.setEnabled(true);
    jBSpieler1Beenden.setEnabled(true);
  } // end of jBSpieler2Beenden_ActionPerformed
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new SechserWuerfelnGUI("SechserWuerfelnGUI");
  } // end of main
  
} // end of class SechserWuerfelnGUI
