import javax.swing.JPanel;
import java.awt.*;

/** Dies ist ein spezielles Panel, das in der Lage ist, die oben liegende Augenzahl
  * eines Wrfel-Objekt graphisch darzustellen.
  */

public class WuerfelPanel extends JPanel {
  
  // Anfang Attribute
  // Speichert die Bilder von Wrfeln mit der Augenzahl 1-6 oben.
  private Image[] bilder = new Image[6];
  // Speichert das Wrfel-Objekt, das im Panel visualisiert werden soll.
  private Wuerfel w;
  // Ende Attribute
  
  /** Erzeugt ein Wrfelpanel.
  * @param w Wrfel-Objekt, das visualisiert werden soll.
  */
  public WuerfelPanel(Wuerfel w) {
    this.w = w;
    // Laden der 6 Bilder wuerfel_1.gif - wuerfel_6.gif
    for (int i = 0; i <6  ; i++ ) {
      bilder[i] = Toolkit.getDefaultToolkit().getImage("wuerfel_"+(i+1)+".gif");
    } // end of for
    this.setBackground(Color.white);
  }
  
  /** Zeichnet das Panel neu. Das richtige Bild zur Augenzahl des Wrfels wird angezeigt. Diese
  * Methode wird automatisch von Java zum Zeichnen aufgerufen.
  * @param g ein Graphics-Objekt
  */
  public void paint(Graphics g) {
    // super.paint ist notwendig, damit der Hintergrund richtig gezeichnet wird.
    super.paint(g);
    g.drawImage(bilder[w.getWurf()-1],15,15,Color.white,this);
  }
  
} // end of WuerfelPanel
