/**
  * Zeichenflche fr geometrische Objekte;
  * verwaltet sowohl die Objektliste als
  * auch die Liste der selektierten Objekte
  * sowie die Reaktionen auf Mausklicks und
  * -bewegungen im Zeichenbereich.
  *
  * @version 1.1 vom 21.07.2012
  * @author Tom Schaller, Roland Mechling
  */
import javax.swing.JPanel;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;


public class Board extends JPanel implements MouseListener, MouseMotionListener {

  // Anfang Attribute
  protected ArrayList<GeoObject> geoObjects = new ArrayList<GeoObject>();
  private ArrayList<GPoint> selectedPts = new ArrayList<GPoint>();
  private GPoint dragPoint = null;
  // Ende Attribute
  
  // Konstruktor
  public Board() {
    super();
    addMouseListener(this);
    addMouseMotionListener(this);
    geoObjects.add(new GPoint(100, 100));
    geoObjects.add(new GPoint(140, 120));
    GPoint p3 = new GPoint(240, 120);
    geoObjects.add(p3);
    GPoint p4 = new GPoint(170, 130);
    geoObjects.add(p4);
    geoObjects.add(new GLine(p3, p4));
  }
  
  // MouseListener
  
  public void mousePressed(MouseEvent e) {
    dragPoint = null;
    for (GeoObject go : geoObjects) {
      if (go instanceof GPoint) {
        GPoint p = (GPoint) go;
        double d = p.abstandZu(e.getX(), e.getY());        
        if (d < 5) {
          dragPoint = p;
        } // end of if
      } // end of if
    } // end of for
    if (dragPoint == null) {
      GPoint newP = new GPoint(e.getX(), e.getY());
      geoObjects.add(newP);
      repaint();
    } else {
      if ((e.getModifiersEx() & e.SHIFT_DOWN_MASK) > 0) {
        if (dragPoint.getSelected()) {
          dragPoint.setSelected(false);
          selectedPts.remove(dragPoint);
        } else {
          dragPoint.setSelected(true);
          selectedPts.add(dragPoint);
        }// end of if
        repaint();
      } // end of if
    }// end of if
  }
  
  public void mouseReleased(MouseEvent e) {
    dragPoint = null;
  }
  
  public void mouseEntered(MouseEvent e) { }
  
  public void mouseExited(MouseEvent e) {  }
  
  public void mouseClicked(MouseEvent e) { }
  
  
  // MouseMotionListener
  
  public void mouseMoved(MouseEvent e) {  }
  
  public void mouseDragged(MouseEvent e) { 
    if (dragPoint != null) {
      if (Math.abs(dragPoint.getX()-e.getX())>0 || Math.abs(dragPoint.getY()-e.getY())>0) {
        dragPoint.setX(e.getX());
        dragPoint.setY(e.getY());
        repaint();
      } // end of if
    } // end of if
  }
  
  // Anfang Methoden
  
  public int getSelPtsCount() {
    return 0;
  }
  
  private void clearSelectedPts() {
    for (GPoint p: selectedPts) {
      p.setSelected(false);
    } // end of for
    selectedPts.clear();
  }
  
  public void addNewCircle() {
    if (selectedPts.size() == 2) {
      GCircle circle = new GCircle(selectedPts.get(0), selectedPts.get(1));
      geoObjects.add(circle);
    } // end of if
    clearSelectedPts();
    repaint();
  }
  
  public void addNewRect() {
    if (selectedPts.size() == 2) {
      GRectangle rectangle = new GRectangle(selectedPts.get(0), selectedPts.get(1));
      geoObjects.add(rectangle);
    } // end of if
    clearSelectedPts();
    repaint();
  }
  
  public void addNewLine() {
    if (selectedPts.size() == 2) {
      GLine line = new GLine(selectedPts.get(0), selectedPts.get(1));
      geoObjects.add(line);
    } // end of if
    clearSelectedPts();
    repaint();
  }
  
  public void addNewPolygon() {
    if (selectedPts.size() >= 3) {
      GPolygon neck = new GPolygon(selectedPts);
      geoObjects.add(neck);
    } // end of if
    clearSelectedPts();
    repaint();
  }
  
  public void setObjColor(Color newCol) {  }
  
  public void deleteObj() {  }
  
  public void paint(Graphics g) {
    super.paint(g);
    BasicStroke stroke2 = new BasicStroke(2.0f, BasicStroke.CAP_BUTT,
    BasicStroke.JOIN_MITER);
    ((Graphics2D) g).setStroke(stroke2);
    for (GeoObject go : geoObjects ) {
      go.draw(g);
    } // end of for
  }
  
  // Ende Methoden
  
} // end of Board
