import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  * GUI fr das Kartenspiel BlackJack
  * Die GUI ist fr vier Spieler realisiert. Jeder Spieler kann einen Betrag setzen.
  * Daraufhin erhlt er zwei Karten. Er kann weitere Karten ziehen oder aufhren.
  * Wenn alle Spieler fertig sind, bekommt der Dealer seine Karten und der
  * Gewinn wird ermittelt.
  *
  * @version 1.0 vom 20.06.2012
  * @author Thomas Schaller
  */

public class BlackJackGUI extends JFrame {
  // Anfang Attribute
  
  private Spielleitung spielleitung;    // Referenz auf den Spielleiter
  
  private JPanel jPSpieler1 = new JPanel(null, true);
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JNumberField jNFSpieler1Guthaben = new JNumberField();
  private JLabel jLabel3 = new JLabel();
  private JNumberField jNFSpieler1Einsatz = new JNumberField();
  private JButton jBSpieler1Setzen = new JButton();
  private KartenPanel kartenPanel1 = new KartenPanel();
  private JButton jBSpieler1Ziehe = new JButton();
  private JButton jBSpieler1Beende = new JButton();
  private JLabel jLSpieler1Punkte = new JLabel();
  private JPanel jPSpieler2 = new JPanel(null, true);
  private JLabel jLabel21 = new JLabel();
  private JNumberField jNFSpieler2Guthaben = new JNumberField();
  private JLabel jLabel31 = new JLabel();
  private JNumberField jNFSpieler2Einsatz = new JNumberField();
  private JButton jBSpieler2Setzen = new JButton();
  private JLabel jLabel11 = new JLabel();
  private KartenPanel kartenPanel2 = new KartenPanel();
  private JLabel jLSpieler2Punkte = new JLabel();
  private JButton jBSpieler2Ziehe = new JButton();
  private JButton jBSpieler2Beende = new JButton();
  private JLabel jLMeldung = new JLabel();
  private KartenPanel kartenPanelCroupier = new KartenPanel();
  private JButton jBAuswerten = new JButton();
  private JButton jBNeu = new JButton();
  private JPanel jPSpieler3 = new JPanel(null, true);
  private JLabel jLabel211 = new JLabel();
  private JNumberField jNFSpieler3Guthaben = new JNumberField();
  private JLabel jLabel311 = new JLabel();
  private JNumberField jNFSpieler3Einsatz = new JNumberField();
  private JButton jBSpieler3Setzen = new JButton();
  private JLabel jLabel111 = new JLabel();
  private KartenPanel kartenPanel3 = new KartenPanel();
  private JLabel jLSpieler3Punkte = new JLabel();
  private JButton jBSpieler3Ziehe = new JButton();
  private JButton jBSpieler3Beende = new JButton();
  private JPanel jPSpieler4 = new JPanel(null, true);
  private JLabel jLabel212 = new JLabel();
  private JNumberField jNFSpieler4Guthaben = new JNumberField();
  private JLabel jLabel312 = new JLabel();
  private JNumberField jNFSpieler4Einsatz = new JNumberField();
  private JButton jBSpieler4Setzen = new JButton();
  private JLabel jLabel112 = new JLabel();
  private KartenPanel kartenPanel4 = new KartenPanel();
  private JLabel jLSpieler4Punkte = new JLabel();
  private JButton jBSpieler4Ziehe = new JButton();
  private JButton jBSpieler4Beende = new JButton();
  private JButton jBStart = new JButton();
  // Ende Attribute
  
  public BlackJackGUI(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 831; 
    int frameHeight = 521;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    // SPIELER 1 GUI-----------------------------------------------------------------------
    
    jPSpieler1.setBounds(8, 8, 185, 305);
    jPSpieler1.setOpaque(true);
    jPSpieler1.setBackground(new Color(0xC0C0C0));
    cp.add(jPSpieler1);
    jLabel1.setBounds(8, 8, 110, 20);
    jLabel1.setText("Spieler 1");
    jPSpieler1.add(jLabel1);
    jLabel2.setBounds(8, 40, 70, 20);
    jNFSpieler1Guthaben.setBounds(86, 40, 75, 20);
    jLabel3.setBounds(8, 72, 70, 20);
    jNFSpieler1Einsatz.setBounds(86, 72, 75, 20);
    jBSpieler1Setzen.setBounds(48, 104, 75, 25);
    jLabel2.setText("Guthaben");
    jPSpieler1.add(jLabel2);
    jNFSpieler1Guthaben.setText("0");
    jNFSpieler1Guthaben.setEditable(false);
    jPSpieler1.add(jNFSpieler1Guthaben);
    jLabel3.setText("Einsatz");
    jPSpieler1.add(jLabel3);
    jNFSpieler1Einsatz.setText("0");
    jPSpieler1.add(jNFSpieler1Einsatz);
    jBSpieler1Setzen.setText("setzen");
    jBSpieler1Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Setzen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler1Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler1.add(jBSpieler1Setzen);
    kartenPanel1.setBounds(8, 144, 169, 97);
    kartenPanel1.setBackground(new Color(0x00A000));
    jPSpieler1.add(kartenPanel1);
    jBSpieler1Ziehe.setBounds(8, 272, 75, 25);
    jBSpieler1Ziehe.setText("Ziehen");
    jBSpieler1Ziehe.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Ziehe.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler1Ziehe_ActionPerformed(evt);
      }
    });
    jBSpieler1Ziehe.setEnabled(false);
    jPSpieler1.add(jBSpieler1Ziehe);
    jBSpieler1Beende.setBounds(96, 272, 75, 25);
    jBSpieler1Beende.setText("Fertig");
    jBSpieler1Beende.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Beende.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler1Beende_ActionPerformed(evt);
      }
    });
    jBSpieler1Beende.setEnabled(false);
    jPSpieler1.add(jBSpieler1Beende);
    jLSpieler1Punkte.setBounds(8, 240, 158, 20);
    jLSpieler1Punkte.setText("Sie haben 0 Punkte.");
    jLSpieler1Punkte.setHorizontalAlignment(SwingConstants.CENTER);
    jPSpieler1.add(jLSpieler1Punkte);
    
    // SPIELER 2 GUI-----------------------------------------------------------------------
    
    
    jPSpieler2.setBounds(200, 8, 201, 305);
    jPSpieler2.setOpaque(true);
    jPSpieler2.setBackground(new Color(0xC0C0C0));
    cp.add(jPSpieler2);
    jLabel21.setBounds(16, 40, 70, 20);
    jNFSpieler2Guthaben.setBounds(96, 40, 75, 20);
    jLabel31.setBounds(16, 72, 70, 20);
    jNFSpieler2Einsatz.setBounds(96, 72, 75, 20);
    jBSpieler2Setzen.setBounds(64, 104, 75, 25);
    jLabel21.setText("Guthaben");
    jPSpieler2.add(jLabel21);
    jNFSpieler2Guthaben.setText("0");
    jNFSpieler2Guthaben.setEditable(false);
    jPSpieler2.add(jNFSpieler2Guthaben);
    jLabel31.setText("Einsatz");
    jPSpieler2.add(jLabel31);
    jNFSpieler2Einsatz.setText("0");
    jPSpieler2.add(jNFSpieler2Einsatz);
    jBSpieler2Setzen.setText("setzen");
    jBSpieler2Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Setzen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler2Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler2.add(jBSpieler2Setzen);
    jLabel11.setBounds(8, 8, 110, 20);
    jLabel11.setText("Spieler 2");
    jPSpieler2.add(jLabel11);
    kartenPanel2.setBounds(8, 144, 185, 97);
    kartenPanel2.setBackground(new Color(0x00A000));
    jPSpieler2.add(kartenPanel2);
    jLSpieler2Punkte.setBounds(8, 240, 182, 20);
    jLSpieler2Punkte.setText("Sie haben 0 Punkte.");
    jLSpieler2Punkte.setHorizontalAlignment(SwingConstants.CENTER);
    jPSpieler2.add(jLSpieler2Punkte);
    jBSpieler2Ziehe.setBounds(8, 272, 83, 25);
    jBSpieler2Ziehe.setText("Ziehen");
    jBSpieler2Ziehe.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Ziehe.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler2Ziehe_ActionPerformed(evt);
      }
    });
    jPSpieler2.add(jBSpieler2Ziehe);
    jBSpieler2Beende.setBounds(104, 272, 83, 25);
    jBSpieler2Beende.setText("Fertig");
    jBSpieler2Beende.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Beende.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler2Beende_ActionPerformed(evt);
      }
    });
    jPSpieler2.add(jBSpieler2Beende);
    
    
    // SPIELER 3 GUI-----------------------------------------------------------------------
    
    jPSpieler3.setBounds(408, 8, 201, 305);
    jPSpieler3.setOpaque(true);
    jPSpieler3.setBackground(new Color(0xC0C0C0));
    cp.add(jPSpieler3);
    jLabel211.setBounds(16, 40, 70, 20);
    jLabel211.setText("Guthaben");
    jPSpieler3.add(jLabel211);
    jNFSpieler3Guthaben.setBounds(96, 40, 75, 20);
    jNFSpieler3Guthaben.setText("0");
    jNFSpieler3Guthaben.setEditable(false);
    jPSpieler3.add(jNFSpieler3Guthaben);
    jLabel311.setBounds(16, 72, 70, 20);
    jLabel311.setText("Einsatz");
    jPSpieler3.add(jLabel311);
    jNFSpieler3Einsatz.setBounds(96, 72, 75, 20);
    jNFSpieler3Einsatz.setText("0");
    jPSpieler3.add(jNFSpieler3Einsatz);
    jBSpieler3Setzen.setBounds(64, 104, 75, 25);
    jBSpieler3Setzen.setText("setzen");
    jBSpieler3Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler3Setzen.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler3Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler3.add(jBSpieler3Setzen);
    jLabel111.setBounds(8, 8, 110, 20);
    jLabel111.setText("Spieler 3");
    jPSpieler3.add(jLabel111);
    kartenPanel3.setBounds(8, 144, 185, 97);
    kartenPanel3.setBackground(new Color(0x00A000));
    jPSpieler3.add(kartenPanel3);
    jLSpieler3Punkte.setBounds(8, 240, 182, 20);
    jLSpieler3Punkte.setText("Sie haben 0 Punkte.");
    jLSpieler3Punkte.setHorizontalAlignment(SwingConstants.CENTER);
    jPSpieler3.add(jLSpieler3Punkte);
    jBSpieler3Ziehe.setBounds(8, 272, 83, 25);
    jBSpieler3Ziehe.setText("Ziehen");
    jBSpieler3Ziehe.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler3Ziehe.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler3Ziehe_ActionPerformed(evt);
      }
    });
    jPSpieler3.add(jBSpieler3Ziehe);
    jBSpieler3Beende.setBounds(104, 272, 83, 25);
    jBSpieler3Beende.setText("Fertig");
    jBSpieler3Beende.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler3Beende.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler3Beende_ActionPerformed(evt);
      }
    });
    jPSpieler3.add(jBSpieler3Beende);
    
    // SPIELER 4 GUI-----------------------------------------------------------------------
    
    jPSpieler4.setBounds(616, 8, 201, 305);
    jPSpieler4.setOpaque(true);
    jPSpieler4.setBackground(new Color(0xC0C0C0));
    cp.add(jPSpieler4);
    jLabel212.setBounds(16, 40, 70, 20);
    jLabel212.setText("Guthaben");
    jPSpieler4.add(jLabel212);
    jNFSpieler4Guthaben.setBounds(96, 40, 75, 20);
    jNFSpieler4Guthaben.setText("0");
    jNFSpieler4Guthaben.setEditable(false);
    jPSpieler4.add(jNFSpieler4Guthaben);
    jLabel312.setBounds(16, 72, 70, 20);
    jLabel312.setText("Einsatz");
    jPSpieler4.add(jLabel312);
    jNFSpieler4Einsatz.setBounds(96, 72, 75, 20);
    jNFSpieler4Einsatz.setText("0");
    jPSpieler4.add(jNFSpieler4Einsatz);
    jBSpieler4Setzen.setBounds(64, 104, 75, 25);
    jBSpieler4Setzen.setText("setzen");
    jBSpieler4Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler4Setzen.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler4Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler4.add(jBSpieler4Setzen);
    jLabel112.setBounds(8, 8, 110, 20);
    jLabel112.setText("Spieler 4");
    jPSpieler4.add(jLabel112);
    kartenPanel4.setBounds(8, 144, 185, 97);
    kartenPanel4.setBackground(new Color(0x00A000));
    jPSpieler4.add(kartenPanel4);
    jLSpieler4Punkte.setBounds(8, 240, 182, 20);
    jLSpieler4Punkte.setText("Sie haben 0 Punkte.");
    jLSpieler4Punkte.setHorizontalAlignment(SwingConstants.CENTER);
    jPSpieler4.add(jLSpieler4Punkte);
    jBSpieler4Ziehe.setBounds(8, 272, 83, 25);
    jBSpieler4Ziehe.setText("Ziehen");
    jBSpieler4Ziehe.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler4Ziehe.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler4Ziehe_ActionPerformed(evt);
      }
    });
    jPSpieler4.add(jBSpieler4Ziehe);
    jBSpieler4Beende.setBounds(104, 272, 83, 25);
    jBSpieler4Beende.setText("Fertig");
    jBSpieler4Beende.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler4Beende.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        jBSpieler4Beende_ActionPerformed(evt);
      }
    });
    jPSpieler4.add(jBSpieler4Beende);
    
    
    jLMeldung.setBounds(272, 312, 262, 28);
    jLMeldung.setText("Bitte machen Sie Ihre Einstze");
    jLMeldung.setHorizontalTextPosition(SwingConstants.CENTER);
    jLMeldung.setHorizontalAlignment(SwingConstants.CENTER);
    cp.add(jLMeldung);
    kartenPanelCroupier.setBounds(296, 344, 209, 97);
    kartenPanelCroupier.setBackground(new Color(0x00A000));
    cp.add(kartenPanelCroupier);
    
    jBAuswerten.setBounds(312, 456, 171, 25);
    jBAuswerten.setText("Auswerten");
    jBAuswerten.setMargin(new Insets(2, 2, 2, 2));
    jBAuswerten.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBAuswerten_ActionPerformed(evt);
      }
    });
    cp.add(jBAuswerten);
    jBNeu.setBounds(312, 456, 169, 25);
    jBNeu.setText("Neues Spiel");
    jBNeu.setMargin(new Insets(2, 2, 2, 2));
    jBNeu.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBNeu_ActionPerformed(evt);
      }
    });
    jBNeu.setVisible(false);
    cp.add(jBNeu);
    
    jBStart.setBounds(312, 456, 169, 25);
    jBStart.setText("Starten");
    jBStart.setMargin(new Insets(2, 2, 2, 2));
    jBStart.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBStart_ActionPerformed(evt);
      }
    });
    jBStart.setVisible(true);
    cp.add(jBStart);
    // Ende Komponenten
    // Rahmenbedingungen fr das Spiel schaffen  ------------------------------------------------------------
    
    spielleitung = new Spielleitung();
    
    // 4 Spieler mit Startguthaben 100 erzeugen
    Spieler sp1 = new Spieler(100);
    Spieler sp2 = new Spieler(100);
    Spieler sp3 = new Spieler(100);
    Spieler sp4 = new Spieler(100);
    
    // Spieler beim Spielleiter anmelden
    spielleitung.addSpieler(sp1);
    spielleitung.addSpieler(sp2);
    spielleitung.addSpieler(sp3);
    spielleitung.addSpieler(sp4);
    
    // Die Kartenpanels ber die Spieler, deren Kartenhand angezeigt werden soll informieren.
    kartenPanel1.setSpieler(sp1);
    kartenPanel2.setSpieler(sp2);
    kartenPanel3.setSpieler(sp3);
    kartenPanel4.setSpieler(sp4);
    kartenPanelCroupier.setSpieler(spielleitung.getCroupier());
    
    jBNeu_ActionPerformed(null);
    setVisible(true);
  } // end of public BlackJackGUI
  
  // Anfang Methoden
  /** Zeigt die Informationen (Guthaben und Kartenwert) ber die Spieler an.
  */
  public void showSpieler() {
    Spieler sp1 = spielleitung.getSpieler(1);
    Spieler sp2 = spielleitung.getSpieler(2);
    Spieler sp3 = spielleitung.getSpieler(3);
    Spieler sp4 = spielleitung.getSpieler(4);
    
    jNFSpieler1Guthaben.setInt(sp1.getGuthaben());
    jNFSpieler2Guthaben.setInt(sp2.getGuthaben());
    jNFSpieler3Guthaben.setInt(sp3.getGuthaben());
    jNFSpieler4Guthaben.setInt(sp4.getGuthaben());
    jLSpieler1Punkte.setText("Sie haben "+sp1.getKarten().getSumme()+" Punkte.");
    jLSpieler2Punkte.setText("Sie haben "+sp2.getKarten().getSumme()+" Punkte.");
    jLSpieler3Punkte.setText("Sie haben "+sp3.getKarten().getSumme()+" Punkte.");
    jLSpieler4Punkte.setText("Sie haben "+sp4.getKarten().getSumme()+" Punkte.");
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  }
  
  /** Aktion, wenn alle Spieler gesetzt haben und beim Dealer "Start" gedrckt wurde
  */
  public void jBStart_ActionPerformed(ActionEvent evt) {
    if (jNFSpieler1Einsatz.getInt()>0 && !jBSpieler1Setzen.isEnabled()) { // Spieler 1 hat gesetzt
      spielleitung.getSpieler(1).zieheKarte();                        // Spieler erhlt zwei Karten
      spielleitung.getSpieler(1).zieheKarte();
      jBSpieler1Ziehe.setEnabled(true);        // Spielerbuttons zum Ziehen und Beenden aktivieren
      jBSpieler1Beende.setEnabled(true);
      kartenPanel1.repaint();
    } // end of if
    
    if (jNFSpieler2Einsatz.getInt()>0 && !jBSpieler2Setzen.isEnabled()) { // Spieler 2 hat gesetzt
      spielleitung.getSpieler(2).zieheKarte();                        // Spieler erhlt zwei Karten
      spielleitung.getSpieler(2).zieheKarte();
      jBSpieler2Ziehe.setEnabled(true);        // Spielerbuttons zum Ziehen und Beenden aktivieren
      jBSpieler2Beende.setEnabled(true);
      kartenPanel2.repaint();
    } // end of if
    
    if (jNFSpieler3Einsatz.getInt()>0 && !jBSpieler3Setzen.isEnabled()) { // Spieler 3 hat gesetzt
      spielleitung.getSpieler(3).zieheKarte();                        // Spieler erhlt zwei Karten
      spielleitung.getSpieler(3).zieheKarte();
      jBSpieler3Ziehe.setEnabled(true);        // Spielerbuttons zum Ziehen und Beenden aktivieren
      jBSpieler3Beende.setEnabled(true);
      kartenPanel3.repaint();
    } // end of if
    
    if (jNFSpieler4Einsatz.getInt()>0 && !jBSpieler4Setzen.isEnabled()) { // Spieler 4 hat gesetzt
      spielleitung.getSpieler(4).zieheKarte();                        // Spieler erhlt zwei Karten
      spielleitung.getSpieler(4).zieheKarte();
      jBSpieler4Ziehe.setEnabled(true);        // Spielerbuttons zum Ziehen und Beenden aktivieren
      jBSpieler4Beende.setEnabled(true);
      kartenPanel4.repaint();
    } // end of if
    showSpieler();
    
    spielleitung.getCroupier().zieheKarte();      // Der Croupier erhlt seine erste Karte
    kartenPanelCroupier.repaint();
    
    jBStart.setVisible(false);
    jBAuswerten.setVisible(true);
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  } // end of jBStart_ActionPerformed
  
  /** Aktion, wenn der Auswerten-Button beim Dealer gedrckt wird.
  */
  public void jBAuswerten_ActionPerformed(ActionEvent evt) {
    spielleitung.auswerten();
    jNFSpieler1Einsatz.setInt(0);
    jNFSpieler2Einsatz.setInt(0);
    jNFSpieler3Einsatz.setInt(0);
    jNFSpieler4Einsatz.setInt(0);
    showSpieler();
    jLMeldung.setText("Der Dealer hat "+spielleitung.getCroupier().getKarten().getSumme()+" Punkte.");
    kartenPanelCroupier.repaint();
    jBNeu.setVisible(true);
    jBAuswerten.setVisible(false);
  } // end of jBAuswerten_ActionPerformed
  
  /** Aktion, wenn der "Neues Spiel"-Button beim Dealer gedrckt wird.
  */
  public void jBNeu_ActionPerformed(ActionEvent evt) {
    spielleitung.neueRunde();
    kartenPanel1.repaint();
    kartenPanel2.repaint();
    kartenPanel3.repaint();
    kartenPanel4.repaint();
    kartenPanelCroupier.repaint();
    showSpieler();
    jBNeu.setVisible(false);
    jBAuswerten.setVisible(true);
    jNFSpieler1Einsatz.setEditable(true);
    jNFSpieler2Einsatz.setEditable(true);
    jNFSpieler3Einsatz.setEditable(true);
    jNFSpieler4Einsatz.setEditable(true);
    jBSpieler1Setzen.setEnabled(true);
    jBSpieler2Setzen.setEnabled(true);
    jBSpieler3Setzen.setEnabled(true);
    jBSpieler4Setzen.setEnabled(true);
    jBSpieler1Ziehe.setEnabled(false);
    jBSpieler2Ziehe.setEnabled(false);
    jBSpieler3Ziehe.setEnabled(false);
    jBSpieler4Ziehe.setEnabled(false);
    jBSpieler1Beende.setEnabled(false);
    jBSpieler2Beende.setEnabled(false);
    jBSpieler3Beende.setEnabled(false);
    jBSpieler4Beende.setEnabled(false);
    jBStart.setVisible(true);
    jBAuswerten.setVisible(false);
    jBNeu.setVisible(false);
    
    jLMeldung.setText("Machen Sie ihre Einstze.");
  } // end of jBNeu_ActionPerformed
  
  /** Aktion, wenn Spieler 1 "Setzen" gedrckt hat
  */
  public void jBSpieler1Setzen_ActionPerformed(ActionEvent evt) {
    spielleitung.getSpieler(1).setze(jNFSpieler1Einsatz.getInt());  // setzen durchfhren
    jNFSpieler1Einsatz.setEditable(false);   // es darf jetzt nicht mehr gesetzt werden
    jBSpieler1Setzen.setEnabled(false);
    showSpieler();
  } // end of jBSpieler1Setzen_ActionPerformed
  
  /** Aktion, wenn Spieler 2 "Setzen" gedrckt hat
  */
  public void jBSpieler2Setzen_ActionPerformed(ActionEvent evt) {
    spielleitung.getSpieler(2).setze(jNFSpieler2Einsatz.getInt());  // setzen durchfhren
    jNFSpieler2Einsatz.setEditable(false);   // es darf jetzt nicht mehr gesetzt werden
    jBSpieler2Setzen.setEnabled(false);
    showSpieler();
  } // end of jBSpieler2Setzen_ActionPerformed
  
  /** Aktion, wenn Spieler 3 "Setzen" gedrckt hat
  */
  public void jBSpieler3Setzen_ActionPerformed(ActionEvent evt) {
    spielleitung.getSpieler(3).setze(jNFSpieler3Einsatz.getInt());  // setzen durchfhren
    jNFSpieler3Einsatz.setEditable(false);   // es darf jetzt nicht mehr gesetzt werden
    jBSpieler3Setzen.setEnabled(false);
    showSpieler();
  } // end of jBSpieler3Setzen_ActionPerformed
  
  /** Aktion, wenn Spieler 4 "Setzen" gedrckt hat
  */
  public void jBSpieler4Setzen_ActionPerformed(ActionEvent evt) {
    spielleitung.getSpieler(4).setze(jNFSpieler4Einsatz.getInt());  // setzen durchfhren
    jNFSpieler4Einsatz.setEditable(false);   // es darf jetzt nicht mehr gesetzt werden
    jBSpieler4Setzen.setEnabled(false);
    showSpieler();
  } // end of jBSpieler4Setzen_ActionPerformed
  
  /** Aktion, wenn Spieler 1 "Karten ziehen" gedrckt hat
  */
  public void jBSpieler1Ziehe_ActionPerformed(ActionEvent evt) {
    Spieler sp1 = spielleitung.getSpieler(1);
    sp1.zieheKarte();                       // Spieler erhlt eine Karte
    kartenPanel1.repaint();
    if (sp1.getKarten().getSumme()>21) {    // Hat sich Spieler berkauft
      jBSpieler1Ziehe.setEnabled(false);
      jBSpieler1Beende.setEnabled(false);
    } // end of if
    showSpieler();
  } // end of jBSpieler1Ziehe_ActionPerformed
  
  /** Aktion, wenn Spieler 2 "Karten ziehen" gedrckt hat
  */
  public void jBSpieler2Ziehe_ActionPerformed(ActionEvent evt) {
    Spieler sp2 = spielleitung.getSpieler(2);
    sp2.zieheKarte();                       // Spieler erhlt eine Karte
    kartenPanel2.repaint();
    if (sp2.getKarten().getSumme()>21) {    // Hat sich Spieler berkauft
      jBSpieler2Ziehe.setEnabled(false);
      jBSpieler2Beende.setEnabled(false);
    } // end of if
    showSpieler();
  } // end of jBSpieler2Ziehe_ActionPerformed
  
  /** Aktion, wenn Spieler 3 "Karten ziehen" gedrckt hat
  */
  public void jBSpieler3Ziehe_ActionPerformed(ActionEvent evt) {
    Spieler sp3 = spielleitung.getSpieler(3);
    sp3.zieheKarte();                       // Spieler erhlt eine Karte
    kartenPanel3.repaint();
    
    if (sp3.getKarten().getSumme()>21) {    // Hat sich Spieler berkauft
      jBSpieler3Ziehe.setEnabled(false);
      jBSpieler3Beende.setEnabled(false);
    } // end of if
    showSpieler();
  } // end of jBSpieler3Ziehe_ActionPerformed
  
  /** Aktion, wenn Spieler 4 "Karten ziehen" gedrckt hat
  */
  public void jBSpieler4Ziehe_ActionPerformed(ActionEvent evt) {
    Spieler sp4 = spielleitung.getSpieler(4);
    sp4.zieheKarte();                       // Spieler erhlt eine Karte
    kartenPanel4.repaint();
    if (sp4.getKarten().getSumme()>21) {    // Hat sich Spieler berkauft
      jBSpieler4Ziehe.setEnabled(false);
      jBSpieler4Beende.setEnabled(false);
    } // end of if
    showSpieler();
  } // end of jBSpieler4Ziehe_ActionPerformed
  
  /** Aktion, wenn Spieler 1 "Beenden" gedrckt hat
  */
  public void jBSpieler1Beende_ActionPerformed(ActionEvent evt) {
    jBSpieler1Ziehe.setEnabled(false);
    jBSpieler1Beende.setEnabled(false);
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  } // end of jBSpieler1Beende_ActionPerformed
  
  /** Aktion, wenn Spieler 2 "Beenden" gedrckt hat
  */
  public void jBSpieler2Beende_ActionPerformed(ActionEvent evt) {
    jBSpieler2Ziehe.setEnabled(false);
    jBSpieler2Beende.setEnabled(false);
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  } // end of jBSpieler2Beende_ActionPerformed
  
  /** Aktion, wenn Spieler 3 "Beenden" gedrckt hat
  */
  public void jBSpieler3Beende_ActionPerformed(ActionEvent evt) {
    jBSpieler3Ziehe.setEnabled(false);
    jBSpieler3Beende.setEnabled(false);
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  } // end of jBSpieler3Beende_ActionPerformed
  
  
  /** Aktion, wenn Spieler 4 "Beenden" gedrckt hat
  */
  public void jBSpieler4Beende_ActionPerformed(ActionEvent evt) {
    jBSpieler4Ziehe.setEnabled(false);
    jBSpieler4Beende.setEnabled(false);
    jBAuswerten.setEnabled(!jBSpieler1Beende.isEnabled() && !jBSpieler2Beende.isEnabled() && !jBSpieler3Beende.isEnabled() && !jBSpieler4Beende.isEnabled());
  } // end of jBSpieler4Beende_ActionPerformed
  
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new BlackJackGUI("Black Jack");
  } // end of main
  
} // end of class crapsGUI
