/**
  *
  * Speichert die Informationen ber eine Karte fr ein Kartenspiel.
  * Jede Karte ist ber eine Kartenfarbe und einen Kartenwert festgelegt.
  *
  * @version 1.0 vom 19.06.2012
  * @author Thomas Schaller
  */
  
public class Karte {
  
  // Anfang Attribute
  private int farbe;
  private int wert;
  // Ende Attribute
  
  /** Erzeugt eine Karte.
  * @param farbe Farbe (0=Kreuz, 1=Pik, 2=Herz, 3=Karo)
  * @param wert  Kartenwert (1=Ass, 2=Zwei,...,10=Zehn, 11=Bube, 12=Dame, 13=Knig)
  */
  public Karte(int farbe, int wert) {;
    this.farbe = farbe;
    this.wert = wert;
  }
  
  // Anfang Methoden
  /** Liefert den Wert der Karte
  * @return Kartenwert (1=Ass, 2=Zwei,...,10=Zehn, 11=Bube, 12=Dame, 13=Knig)
  */
  public int getWert() {
    return wert;
  }
  
  /** Liefert die Farbe der Karte
  * @return Kartenfarbe (0=Kreuz, 1=Pik, 2=Herz, 3=Karo)
  */
  public int getFarbe() {
    return farbe;
  }
  
  /** Liefert eine Textbeschreibung der Karte. Dies ist zum Testen der Klassen hilfreich.
  * @return Kartenbeschreibung (z.B. Kreuz 3)
  */
  public String toString() {
    String bezeichnung="";
    switch(farbe) {
      
      case 0:  bezeichnung = "Kreuz "; break;
      case 1:  bezeichnung = "Pik "; break;
      case 2:  bezeichnung = "Herz "; break;
      case 3:  bezeichnung = "Karo "; break;
    }
    switch (wert) {
      case 1: bezeichnung = bezeichnung + "As";  break;
      case 2: bezeichnung = bezeichnung + "2";  break;
      case 3: bezeichnung = bezeichnung + "3";  break;
      case 4: bezeichnung = bezeichnung + "4";  break;
      case 5: bezeichnung = bezeichnung + "5";  break;
      case 6: bezeichnung = bezeichnung + "6";  break;
      case 7: bezeichnung = bezeichnung + "7";  break;
      case 8: bezeichnung = bezeichnung + "8";  break;
      case 9: bezeichnung = bezeichnung + "9";  break;
      case 10: bezeichnung = bezeichnung + "10";  break;
      case 11: bezeichnung = bezeichnung + "Bube";  break;
      case 12: bezeichnung = bezeichnung + "Dame";  break;
      case 13: bezeichnung = bezeichnung + "Knig";  break;
      
    } // end of switch
    
    return bezeichnung;
  }
  
  // Ende Methoden
} // end of Wuerfel
