import javax.swing.JPanel;
import java.awt.*;

/**
  *
  * Panel zum Anzeigen der Kartenhand eines Spielers (fr BlackJack)
  * Angezeigt werden die Bilder im Unterverzeichnis bilder. Dabei mssen
  * die Karten von 10.png - 14.png (Ass Kreuz-Ass Karo) bis 130.png - 134.png
  * (Knig Kreuz - Knig Karo) benannt sein.
  *
  * @version 1.0 vom 16.06.2012
  * @author Thomas Schaller
  */

public class KartenPanel extends JPanel {
  
  // Anfang Attribute
  private Image[] bilder = new Image[52];
  private Spieler spieler = null;
  // Ende Attribute
  
  /** Erzeugt ein Panel zur Anzeige einer Kartenhand.
  */
  public KartenPanel() {;
    
    // Bilder laden von i = 0 (Ass) bis i=13 (Knig)
    for (int i = 0; i < 13; i++ ) {
      bilder[i] = Toolkit.getDefaultToolkit().getImage("bilder/"+(i+1)+"0.png");     // Kreuz
      bilder[13+i] = Toolkit.getDefaultToolkit().getImage("bilder/"+(i+1)+"1.png");  // Pik
      bilder[26+i] = Toolkit.getDefaultToolkit().getImage("bilder/"+(i+1)+"2.png");  // Herz
      bilder[39+i] = Toolkit.getDefaultToolkit().getImage("bilder/"+(i+1)+"3.png");  // Karo
    } // end of for
    
    this.setBackground(Color.white);
  }
  
  /** Setzt eine Referenz auf den Spieler, dessen Kartenhand angezeigt werden soll.
  * @param spieler Spieler, dessen Hand angezeigt werden soll.
  */
  public void setSpieler(Spieler spieler) {
    this.spieler = spieler;
  }
  
  /** Zeichnet die Karten auf einen gegebenen Grafikkontext. Es werden die Bilder
  * aus dem Unterverzeichnis bilder angezeigt.
  * @param g Grafikkontext, auf den gezeichnet werden soll.
  */
  public void paint(Graphics g) {
    super.paint(g);  // Aufruf der berlagerten paint-Methode, damit Hintergrund richtig gezeichnet wird.
    
    if (spieler != null) {  // Wenn Spieler-Referenz gesetzt ist

      // Zeichne alle Karten der Hand
      Kartenhand k = spieler.getKarten();
      for (int i=0; i < k.getAnzahl(); i++) {
        g.drawImage(bilder[(k.getKarte(i).getWert()-1)+k.getKarte(i).getFarbe()*13],15+i*25,15,Color.white,this);
      } // end of while
    } // end of if
    
    
  }
} // end of Board
