/**
  * Die Klasse Spieler speichert die Daten eines Spielers fr das Spiel BlackJack.
  * Der Dealer wird dabei auch als Spieler angesehen.
  *
  * @version 1.0 vom 19.06.2012
  * @author Thomas Schaller
  */

public class Spieler {

  // Anfang Attribute
  private int guthaben;          // Guthaben des Spielers
  private int einsatz = 0;       // Betrag den der Spieler gesetzt hat
  private Spielleitung spielleiter; // Referenz auf Spielleitung
  private Kartenhand karten;     // Referenz auf die Karten des Spielers
  // Ende Attribute
  
  /** Erzeugt einen Spieler mit einem bestimmten Startguthaben. Der Spieler
  * wird mit einer leeren Kartenhand erzeugt.
  * @param guthaben Startguthaben des Spielers
  */
  public Spieler(int guthaben) {
    this.guthaben = guthaben;
    this.einsatz = 0;
    this.spielleiter = null;
    this.karten = new Kartenhand();
  }
  
  // Anfang Methoden
  
  /** Referenz auf Spielleiter setzen.
  * @param spielleiter Referenz auf einen BlackJack-Spielleiter
  */
  public void setSpielleiter(Spielleitung spielleiter) {
    this.spielleiter = spielleiter;
  }
  
  /** Liefert das aktuelle Guthaben des Spielers.
  * @return Guthaben des Spielers
  */
  public int getGuthaben() {
    return guthaben;
  }
  
  /** Setzt den Einsatz fr das nchste Spiel.
  * @param betrag eingesetzter Betrag
  */
  public void setze(int betrag) {
    einsatz += betrag;
    guthaben -= betrag;
  }
  
  /** Rechnet den Gewinn des Spielers ab, da er gewonnen hat.
  * @param gewinnfaktor (0 falls verloren, 1 falls unentschieden, 2 bei normalem Gewinn, 2.5 bei Triple-7 oder Blackjack)
  */
  public void abrechnen(double gewinnfaktor) {
    guthaben += (int) (gewinnfaktor*einsatz);
    einsatz = 0;
  }
  
  
  /** Eine neue Runde wird begonnen. Daher bekommt der Spieler wieder eine leere Kartenhand.
  */
  public void neueRunde() {
    karten = new Kartenhand();
  }
  
  /** Liefert eine Referenz auf die Kartenhand.
  * @return Kartenhand
  */
  public Kartenhand getKarten() {
    return karten;
  }
  
  /** Der Spieler wnscht eine weitere Karte. Diese wird der Kartenhand hinzugefgt.
  */
  public void zieheKarte() {
    Karte k = spielleiter.getKarte();  // Karte beim Spielleiter anfordern
    karten.add(k);                     // Karte hinzufgen
  }
  
  // Ende Methoden
} // end of Spieler
