import java.util.ArrayList;

/**
  * Spielleiter fr das Wrfelspiel Spielleitung .
  * Es werden die Mitspieler verwaltet, der aktuelle Spieler gespeichert, die Wrfel erzeugt.
  *
  * @version 1.0 vom 20.06.2012
  * @author Thomas Schaller
  */

public class Spielleitung {

  // Anfang Attribute
  private ArrayList<Spieler> spieler;           // Referenz auf die Spieler
  private Wuerfel[] wuerfel = new Wuerfel[2];   // Referenz auf die Wrfel
  private int  amZug=0;                         // Nummer des Spielers der am Zug ist
  // Ende Attribute
  
  /** Erzeugt den Spielleiter fr Spielleitung. Es werden auch die notwendigen zwei Wrfel erzeugt.
  */
  public Spielleitung() {
    this.wuerfel[0] = new Wuerfel();             // Wrfel erzeugen
    this.wuerfel[1] = new Wuerfel();
    this.spieler  = new ArrayList<Spieler>();
  }
  
  // Anfang Methoden
  /** Meldet einen Spieler beim Spielleiter an. Der Spieler wird darber informiert, wer der Spielleiter ist.
  * @param s Spieler, der angemeldet werden soll.
  */
  public void addSpieler(Spieler s) {
    spieler.add(s);
  }
  
  /** Testet, ob die aktuelle Wrfelkombination ein Gewinnwurf ist.
  * @return true, wenn es sich um einen Gewinnwurf handelt, sonst false.
  */
  public boolean gewinnwurf () {
    if (wuerfel[0].getWurf()==6 && wuerfel[1].getWurf()==6) return true;
    if (wuerfel[0].getWurf()==5 && wuerfel[1].getWurf()==5) return true;
    if (wuerfel[0].getWurf()==3 && wuerfel[1].getWurf()==3) return true;
    if (wuerfel[0].getWurf()==6 && wuerfel[1].getWurf()==5) return true;
    if (wuerfel[0].getWurf()==5 && wuerfel[1].getWurf()==6) return true;
    return false;
  }
  
  /** Testet, ob die aktuelle Wrfelkombination ein Verlustwurf ist.
  * @return true, wenn es sich um einen Verlustwurf handelt, sonst false.
  */
  public boolean verlustwurf () {
    if (wuerfel[0].getWurf()==1 && wuerfel[1].getWurf()==1) return true;
    if (wuerfel[0].getWurf()==2 && wuerfel[1].getWurf()==2) return true;
    if (wuerfel[0].getWurf()==4 && wuerfel[1].getWurf()==4) return true;
    if (wuerfel[0].getWurf()==1 && wuerfel[1].getWurf()==2) return true;
    if (wuerfel[0].getWurf()==2 && wuerfel[1].getWurf()==1) return true;
    return false;
  }
  
  /** Wertet den letzten Wrfelwurf aus. Falls es ein Gewinn- oder Verlustwurf ist,
  * werden die Spieler ber ihren Sieg / Verlust informiert.
  * @return true, wenn es sich um einen Gewinn- oder Verlustwurf handelt und ein neuer Durchgang beginnen muss, sonst false.
  */
  public boolean auswerten() {
    if (gewinnwurf()) {
      for (int i = 0; i< spieler.size(); i++) {
        Spieler s = spieler.get(i);
        if (i == amZug) {                    // Wrfelnder Spieler gewinnt
          s.gewonnen();
        } else {
          s.verloren();
        }// end of if
      } // end of for
      return true;
    } // end of if
    if (verlustwurf()) {
      for (int i = 0; i< spieler.size(); i++) {
        Spieler s = spieler.get(i);
        if (i == amZug) {                    // Wrfelnder Spieler verliert
          s.verloren();
        } else {
          s.gewonnen();
        }// end of if
      } // end of for
    } // end of if
    amZug = (amZug+1)% spieler.size();         // der nchste Spieler wird aktueller Spieler
    
    return false;
  }
  
  /** liefert eine Referenz auf einen Wrfel
  * @param nr Nummer des gewnschten Wrfels
  * @return Referenz auf den Wrfel
  */
  public Wuerfel getWuerfel(int nr) {
    return wuerfel[nr]; 
  }
  
  /** liefert eine Referenz auf einen Spieler
  * @param nr Nummer des gewnschten Spielers
  * @return Referenz auf den Spieler
  */
  public Spieler getSpieler(int nr) {
    return spieler.get(nr);
  }
  
  /** liefert eine Referenz auf den Spieler der am Zug ist
  * @return Referenz auf den Spieler
  */
  public Spieler getSpielerAmZug() {
    return spieler.get(amZug);
  }
  
  
  // Ende Methoden
} // end of Spielleitung
