import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  * GUI fr das Wrfelspiel Barbudi
  * Zwei Spieler knnen einen Betrag setzen und dann abwechselnd wrfeln.
  * Wrfelt einer der Spieler einen Gewinnwurf gewinnt er, der andere verliert.
  * Bei einem Verlustwurf ist es umgekehrt.
  *
  * @version 1.0 vom 20.06.2012
  * @author Thomas Schaller
  */

public class BarbudiGUI extends JFrame {
  // Anfang Attribute
  private Spielleitung spielleitung;   // Verwaltung des Spiels
  
  
  private JPanel jPSpieler1 = new JPanel(null, true);
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JNumberField jNFSpieler1Guthaben = new JNumberField();
  private JLabel jLabel3 = new JLabel();
  private JNumberField jNFSpieler1Einsatz = new JNumberField();
  private JButton jBSpieler1Setzen = new JButton();
  private JPanel jPSpieler2 = new JPanel(null, true);
  private JLabel jLabel21 = new JLabel();
  private JNumberField jNFSpieler2Guthaben = new JNumberField();
  private JLabel jLabel31 = new JLabel();
  private JNumberField jNFSpieler2Einsatz = new JNumberField();
  private JButton jBSpieler2Setzen = new JButton();
  private JLabel jLabel11 = new JLabel();
  private JLabel jLMeldung = new JLabel();
  private WuerfelPanel wuerfelPanel1;
  // Ende Attribute
  
  public BarbudiGUI(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 653; 
    int frameHeight = 205;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jPSpieler1.setBounds(8, 8, 169, 161);
    jPSpieler1.setOpaque(true);
    
    
    cp.add(jPSpieler1);
    jLabel1.setBounds(8, 8, 110, 20);
    jLabel1.setText("Spieler 1");
    jPSpieler1.add(jLabel1);
    jLabel2.setBounds(8, 40, 70, 20);
    jNFSpieler1Guthaben.setBounds(86, 40, 75, 20);
    jLabel3.setBounds(8, 72, 70, 20);
    jNFSpieler1Einsatz.setBounds(86, 72, 75, 20);
    jBSpieler1Setzen.setBounds(48, 120, 75, 25);
    jLabel2.setText("Guthaben");
    jPSpieler1.add(jLabel2);
    jNFSpieler1Guthaben.setText("");
    jNFSpieler1Guthaben.setEditable(false);
    jPSpieler1.add(jNFSpieler1Guthaben);
    jLabel3.setText("Einsatz");
    jPSpieler1.add(jLabel3);
    jNFSpieler1Einsatz.setText("");
    jPSpieler1.add(jNFSpieler1Einsatz);
    jBSpieler1Setzen.setText("setzen");
    jBSpieler1Setzen.setMargin(new Insets(2, 2, 2, 2));
    jPSpieler1.add(jBSpieler1Setzen);
    jPSpieler2.setBounds(456, 8, 185, 161);
    jPSpieler2.setOpaque(true);
    cp.add(jPSpieler2);
    jLabel21.setBounds(16, 40, 70, 20);
    jNFSpieler2Guthaben.setBounds(96, 40, 75, 20);
    jLabel31.setBounds(16, 72, 70, 20);
    jNFSpieler2Einsatz.setBounds(96, 72, 75, 20);
    jBSpieler2Setzen.setBounds(64, 120, 75, 25);
    jLabel21.setText("Guthaben");
    jPSpieler2.add(jLabel21);
    jNFSpieler2Guthaben.setText("");
    jNFSpieler2Guthaben.setEditable(false);
    jPSpieler2.add(jNFSpieler2Guthaben);
    jLabel31.setText("Einsatz");
    jPSpieler2.add(jLabel31);
    jNFSpieler2Einsatz.setText("");
    jPSpieler2.add(jNFSpieler2Einsatz);
    jBSpieler2Setzen.setText("setzen");
    jBSpieler2Setzen.setMargin(new Insets(2, 2, 2, 2));
    jPSpieler2.add(jBSpieler2Setzen);
    jLabel11.setBounds(16, 8, 110, 20);
    jLabel11.setText("Spieler 2");
    jPSpieler2.add(jLabel11);
    jLMeldung.setBounds(184, 144, 262, 28);
    jLMeldung.setText("Bitte machen Sie Ihre Einstze");
    jLMeldung.setHorizontalTextPosition(SwingConstants.CENTER);
    jLMeldung.setHorizontalAlignment(SwingConstants.CENTER);
    cp.add(jLMeldung);
    
    // Ende Komponenten
    
    // Spielleitung Grundaufbau erzeugen (z.B. auch Wrfel)
    spielleitung = new Spielleitung();
    wuerfelPanel1= new WuerfelPanel(spielleitung.getWuerfel(0),spielleitung.getWuerfel(1));
    wuerfelPanel1.setBounds(216, 8, 204, 124);
    cp.add(wuerfelPanel1);
    
    
    // Informationen ber Spieler anzeigen
    
    setVisible(true);
  } // end of public BarbudiGUI
  
  // Anfang Methoden
  /** Informationen ber die Spieler werden angezeigt. Es werden das Guthaben angezeigt
  * und je nach dem, welche Spieler an der Reihe ist, der Hintergrund dunkler eingefrbt.
  * Auerdem wird angezeigt, welcher Spieler dran ist.
  */
  
  public void showSpieler() {
    
  }
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new BarbudiGUI("BarbudiGUI");
  } // end of main
  
} // end of class BarbudiGUI
