import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.JPanel;


/** AnzeigePanel fr eine 3D-Szene. Die Berechnung mit zwei Augenpunkten ermglicht eine Rot-Cyan-Darstellung
* des Bildes, die mit einer entsprechenden Brille einen echten rumlichen Eindruck vermittelt.
* ber einen MouseLisener wird auerdem die Drehung des Szene ermglicht.
*/
class Board3D extends JPanel {
  // Informationen ber die Szene
  private ArrayList<Strecke> szene = new ArrayList<Strecke>(); // Szene, die aus einer Liste von Strecken besteht
  private Punkt viewpoint = new Punkt(0, 0, -25);               // Ausgangspunkt fr die Berechnung des Bildes (zwischen den beiden Augenpunkten)
  
  
  /** Erzeugt neues 3D-Panel mit schwarzem Hintergrund und Mauslistenern
  */
  public Board3D() {
    super();
    this.setBackground(Color.BLACK);                   // Schwarzer Hintergrund, damit die Linien besser hervortreten.
  }
  
  /** Fgt eine Strecke der Szene hinzu
  * @param s Referenz auf die neue Strecke
  */
  public void addStrecke(Strecke s) {
    szene.add(s);
  }
  
  /** Zeichnet komplette Szene mit zwei Farben fr linkes und rechtes Auge.
  * @param g Grafikkontext
  */
  public void paint(Graphics g) {
    super.paint(g);
    
    Graphics2D g2 = (Graphics2D) g;
    
    // Dicke Linie in wei auswhlen
    BasicStroke dickeLinie = new BasicStroke(3.0f);
    g2.setStroke(dickeLinie);
    g2.setColor(Color.white);
    
    
    for (Strecke s: szene) {                   // Alle Strecken zeichnen
      s.draw(g, viewpoint);
    }
  }
  
  
}
