import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.FileReader;
import java.util.Scanner;
import java.io.IOException;
import java.util.ArrayList;

/**
  *
  * GUI zum Zeichnen einer 3D-Szene
  *
  * @version 1.0 vom 10.04.2012
  * @author  Thomas Schaller
  */

public class DrawIt3DGUI extends JFrame {
  // Anfang Attribute
  private Board3D board1 = new Board3D();
  

  // Ende Attribute

  public DrawIt3DGUI(String title)    {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 909; 
    int frameHeight = 731;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten

    board1.setBounds(0, 0, 900, 700);
    cp.add(board1);
    // Ende Komponenten
    
    Punkt p1 = new Punkt(-2,-3,2);
    Punkt p2 = new Punkt(2,-3,2);
    Punkt p3 = new Punkt(2,-3,-2);
    Punkt p4 = new Punkt(-2,-3,-2);
    Punkt p5 = new Punkt(-2,2,2);
    Punkt p6 = new Punkt(2,2,2);
    Punkt p7 = new Punkt(2,2,-2);
    Punkt p8 = new Punkt(-2,2,-2);
    Punkt p9 = new Punkt(0,6,0);
    board1.addStrecke(new Strecke(p1,p2));
    board1.addStrecke(new Strecke(p2,p3));
    board1.addStrecke(new Strecke(p3,p4));
    board1.addStrecke(new Strecke(p4,p1));
    board1.addStrecke(new Strecke(p5,p6));
    board1.addStrecke(new Strecke(p6,p7));
    board1.addStrecke(new Strecke(p7,p8));
    board1.addStrecke(new Strecke(p8,p5));
    board1.addStrecke(new Strecke(p1,p5));
    board1.addStrecke(new Strecke(p2,p6));
    board1.addStrecke(new Strecke(p3,p7));
    board1.addStrecke(new Strecke(p4,p8));
    board1.addStrecke(new Strecke(p5,p9));
    board1.addStrecke(new Strecke(p6,p9));
    board1.addStrecke(new Strecke(p7,p9));
    board1.addStrecke(new Strecke(p8,p9));

    p1 = new Punkt(2,-3,1.5);
    p2 = new Punkt(6,-3,1.5);
    p3 = new Punkt(6,-3,-1);
    p4 = new Punkt(2,-3,-1);
    p5 = new Punkt(2,0,1.5);
    p6 = new Punkt(6,0,1.5);
    p7 = new Punkt(6,0,-1);
    p8 = new Punkt(2,0,-1);
    board1.addStrecke(new Strecke(p1,p2));
    board1.addStrecke(new Strecke(p2,p3));
    board1.addStrecke(new Strecke(p3,p4));
    board1.addStrecke(new Strecke(p4,p1));
    board1.addStrecke(new Strecke(p5,p6));
    board1.addStrecke(new Strecke(p6,p7));
    board1.addStrecke(new Strecke(p7,p8));
    board1.addStrecke(new Strecke(p8,p5));
    board1.addStrecke(new Strecke(p1,p5));
    board1.addStrecke(new Strecke(p2,p6));
    board1.addStrecke(new Strecke(p3,p7));
    board1.addStrecke(new Strecke(p4,p8));
    
    cp.setBackground(Color.black);

    setResizable(false);
    setVisible(true);
  }

  // Anfang Methoden
  // Ende Methoden

  public static void main(String[] args) {
    new DrawIt3DGUI("DrawIt3DGUI");
  }
}
