/**
  * Speichert die Informationen ber eine Punkt im Raum.
  * Die Information ber die Lage des Punktes werden mit Hilfe eines Ortsvektors
  * gespeichert.
  *
  * @version 1.0 vom 11.4.2011
  * @author T. Schaller
  */

public class Punkt extends Vektor {

  
  /** Erzeugt einen neuen Punkt mit den Koordinaten (x|y|z)
    * @param x x-Koordinate
    * @param y y-Koordinate
    * @param z z-Koordinate
  */
  Punkt(double x, double y, double z) {
    super(x,y,z);
  }
  
  /** Verschiebt den Punkt um einen Vektor v. Dazu werden die Koordinaten
  * des Ortsvektors zu den Koordinaten des Schiebevektors addiert.
  * @param v Verschiebevektor
  */
  public void verschiebe(Vektor v) {
    super.add(v);
  }
  // Ende Methoden
}
