/**
  * Speichert die Information ber einen Vektor im dreidimensionalen Raum.
  *
  *
  * @version 1.0 vom 10.04.2011
  * @author T. Schaller
  */

public class Vektor {
  
    // Anfang Attribute
  private double x = 0;  // Koordinaten des Vektors
  private double y = 0;
  private double z = 0;
  // Ende Attribute
  
  // Anfang Methoden
  /** Erzeugt einen neuen Vektor mit den angegebenen Koordinaten
  * @param x x-Koordinate
  * @param y y-Koordinate
  * @param z z-Koordinate
  */
  public Vektor(double x, double y, double z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }
  
  // Anfang Methoden
  /** Addiert den bergebenen Vektor. Dazu werden die Koordinaten
  * der beiden Vektoren addiert.
  * @param v Vektor, der addiert werden soll.
  */
  public void add(Vektor v) {
    x += v.x; y += v.y; z += v.z;
  }
  
  /** Liefert die x-Koordinate des Vektors
  * @return x-Koordinate
  */
  public double getX() {
    return x;
  }
  
  /** Setzt die x-Koordinate des Vektors
  * @param x-Koordinate
  */
  public void setX(double x) {
    this.x = x;
  }
  
  /** Liefert die y-Koordinate des Vektors
  * @return y-Koordinate
  */
  public double getY() {
    return y;
  }
  
  /** Setzt die y-Koordinate des Vektors
  * @param y-Koordinate
  */
  public void setY(double y) {
    this.y = y;
  }
  
  
  /** Liefert die z-Koordinate des Vektors
  * @return z-Koordinate
  */
  public double getZ() {
    return z;
  }
  
  /** Setzt die z-Koordinate des Vektors
  * @param z z-Koordinate
  */
  public void setZ(double z) {
    this.z = z;
  }
  
  
  // Ende Methoden
}
