/**
  * Verwaltet einen Spieler fr das Spiel 6er-Wrfeln. Der Spieler hat
  * jeweils die Wahl zu Wrfeln oder Aufzuhren und die Punkte zu sichern.
  * Wrfelt er eine 6, verliert er die Punkte sofort. Dazu muss
  * dem Spieler ein Wrfel-Objekt bekannt sein.
  *
  * @version 1.0 vom 19.06.2012
  * @author Thomas Schaller
  */

public class Spieler {

  // Anfang Attribute
  // Summe der Augenzahlen des aktuelle Durchgangs
  private int summe = 0;
  // Gesamtsumme der Augenzahlen aller Durchgnge
  private int gesamtsumme = 0;
  // Wrfel-Objekt, das zum Wrfeln verwendet wird.
  private Wuerfel wuerfel = null;
  // Ende Attribute
  
  // Anfang Methoden
  /** Liefert die Summe der Augenzahlen des aktuellen Durchgangs.
    * @return Summe der Augenzahlen
    */
  public int getSumme() {
    return summe;
  }
  
  /** Liefert die Gesamtsumme aller Durchgnge. Dabei werden die Augenzahlen jedes
    * Durchgangs addiert, sobald die Methode Aufhren aufgerufen wird.
    * @return Gesamtsumme aller Durchgnge.
    */
  public int getGesamtsumme() {
    return gesamtsumme;
  }
  
  /** Der Spieler wrfelt 1x. Wirft er eine 6 verliert er die aktuell gesammelten
    * Augen, ansonsten wird die gewrfelte Zahl hinzuaddiert.
    * @return Summe der Augenzahlen des aktuellen Durchgangs
    */
  public int wuerfeln() {
    wuerfel.wuerfeln();
    if (wuerfel.getWurf()==6) {
      summe = 0;
    } else {
      summe = summe + wuerfel.getWurf();
    }// end of if
    return summe;
  }
  
  /** Der Spieler beendet den aktuellen Durchgang. Alle in diesem Durchgang gesammelten
    * Punkte werden zur Gesamtsumme hinzuaddiert.
    */
  public void aufhoeren() {
    gesamtsumme = gesamtsumme + summe;
    summe = 0;
  }
  
  /** Dem Spieler wird ein Wrfel-Objekt bergeben.
    * @param wuerfel Wrfel, den der Spieler benutzen soll.
    */
  public void setWuerfel(Wuerfel wuerfel) {
    this.wuerfel = wuerfel;
  }

  // Ende Methoden
} // end of Spieler
