/**
  * Zeichenflche fr geometrische Objekte;
  * verwaltet sowohl die Objektliste als
  * auch die Liste der selektierten Objekte
  * sowie die Reaktionen auf Mausklicks und
  * -bewegungen im Zeichenbereich.
  *
  * @version 1.1 vom 21.07.2012
  * @author Tom Schaller, Roland Mechling
  */
import javax.swing.JPanel;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;


public class Board extends JPanel implements MouseListener, MouseMotionListener {

  // Anfang Attribute
  private ArrayList<GPoint> geoObjects = new ArrayList<GPoint>();
  private GPoint dragPoint = null;
  // Ende Attribute
  
  // Konstruktor
  public Board() {
    super();
    addMouseListener(this);
    addMouseMotionListener(this);
    GPoint p = new GPoint(100, 100);
    geoObjects.add(p);
    p = new GPoint(140, 120);
    geoObjects.add(p);
    p = new GPoint(240, 120);
    geoObjects.add(p);
    p = new GPoint(170, 130);
    geoObjects.add(p);
  }
  
  // MouseListener
  
  public void mousePressed(MouseEvent e) {
    dragPoint = null;
    for (GPoint p : geoObjects) {
      double d = p.abstandZu(e.getX(), e.getY());
      if (d < 4) {
        dragPoint = p;
      } // end of if
    } // end of for
    if (dragPoint == null) {
      GPoint newP = new GPoint(e.getX(), e.getY());
      geoObjects.add(newP);
      repaint();
    } // end of if
  }
  
  public void mouseReleased(MouseEvent e) {
    dragPoint = null;
  }
  
  public void mouseEntered(MouseEvent e) {  }
  
  public void mouseExited(MouseEvent e) {  }
  
  public void mouseClicked(MouseEvent e) { }
  
  
  // MouseMotionListener
  
  public void mouseMoved(MouseEvent e) {  }
  
  public void mouseDragged(MouseEvent e) {
    if (dragPoint != null) {
      dragPoint.setX(e.getX());
      dragPoint.setY(e.getY());
      repaint();
    } // end of if
  }
  
  
  // Anfang Methoden
  
  public int getSelPtsCount() {
    return 0;
  }
  public void addNewCircle() {  }
  
  public void addNewRect() {  }
  
  public void addNewLine() {  }
  
  public void addNewPolygon() {  }
  
  public void setObjColor(Color newCol) {  }
  
  public void deleteObj() {  }
  
  public void paint(Graphics g) {
    super.paint(g);
    BasicStroke stroke2 = new BasicStroke(2.0f, BasicStroke.CAP_BUTT,
    BasicStroke.JOIN_MITER);
    ((Graphics2D) g).setStroke(stroke2);
    for (GPoint p : geoObjects ) {
      p.draw(g);
    } // end of for
  }
  // Ende Methoden
  
} // end of Board
