/**
  * Spielleiter fr das Wrfelspiel Dice (Wrfelpoker) .
  * Es werden die Mitspieler verwaltet, der aktuelle Spieler gespeichert, die Wrfel erzeugt.
  *
  * @version 1.0 vom 08.10.2012
  * @author Thomas Schaller  und Thomas Ningelgen
  */
import java.math.*;

public class Dice {

  // Anfang Attribute
  private Spieler[] spieler = new Spieler[2];   // Referenz auf die Spieler
  private Wuerfel[] wuerfel = new Wuerfel[5];   // Referenz auf die Wrfel
  protected int amZug;
  private int[] anzahlZahl = new int[6];        // Speichert die Anzahl der jeweiligen Wrfe: {3,0,0,2,1,0} 
                                                // bedeutet: 3 1-er, 0 2-er, 0 3-er, 2 4-er, 1 5-er, 0 6-er
  // Ende Attribute
  
  /** Erzeugt den Spielleiter fr Dice. Es werden auch die notwendigen zwei Wrfel erzeugt.
  */
  // fnf Wrfel erzeugen
  public Dice() {
    for (int i = 0;i<5 ;i++ ) {
      this.wuerfel[i] = new Wuerfel() ;
    } // end of for
  } 
  
  // Anfang Methoden
  /** Meldet einen Spieler beim Spielleiter an. Der Spieler wird darber informiert, wer der Spielleiter ist.
  * @param s Spieler, der angemeldet werden soll.
  */
  public void setSpieler(Spieler s) {
    s.setSpielleiter(this);
    if (spieler[0] == null) {
      spieler[0] = s;
    } else {
      spieler[1] = s;
    }// end of if
  }
  
  //Wertet den letzten Wrfelwurf aus. Der Punktewert bercksichtigt die verschiedenen Wertigkeiten der Wrfe bei Dice
  public void auswerten() {
    if (spieler[0].gesamtEinsatz > spieler[1].gesamtEinsatz) {    //zweiter Spieler zieht nicht mit  
      spieler[0].guthaben +=  spieler[0].gesamtEinsatz - spieler[1].gesamtEinsatz ; // Nicht akzeptierter Einsatz zurckgebucht 
      spieler[0].gesamtEinsatz = spieler[1].gesamtEinsatz ; // Gesamteinsatz angepasst
      spieler[0].gewonnen(); spieler[1].verloren();
      spielBeenden();
      
    } 
    if (spieler[0].gesamtEinsatz < spieler[1].gesamtEinsatz) {    //erster Spieler zieht nicht mit      
      spieler[1].guthaben +=  spieler[1].gesamtEinsatz - spieler[0].gesamtEinsatz ; // Nicht akzeptierter Einsatz zurckgebucht 
      spieler[1].gesamtEinsatz = spieler[0].gesamtEinsatz ; // Gesamteinsatz angepasst
      spieler[1].gewonnen(); spieler[0].verloren();
      spielBeenden();
    } 
    if (spieler[0].gesamtEinsatz == spieler[1].gesamtEinsatz) {     //Normalfall: Einstze gleich
      // Initialisierung
      for (int i = 0;i<6 ;i++ ) {
        anzahlZahl[i] = 0;
      } // end of for
      spieler[amZug].punkte = 0;                    
      // zhlen wieviele von jeder mglichen Zahl j+1
      for (int j = 0;j<6 ;j++ ) {              
        //j+1-er Wrfe zhlen
        for (int i = 0;i<5 ; i++) {             
          if (getWuerfel(i).wurf == j+1) {
            anzahlZahl[j] = anzahlZahl[j]+1;          
          } // end of if
        } // end of i-for
      } // end of j-for
      spieler[amZug].wurfNummer += 1;
      //Gesamtpunktzahl berechnen  
      for (int k = 0;k<6 ;k++ ) {
        spieler[amZug].punkte = spieler[amZug].punkte + (int) ((k+1)*Math.pow(10,(anzahlZahl[k]-1)));
      }  
    } // end of if  
  }
  
  /** liefert eine Referenz auf einen Wrfel
  * @param nr Nummer des gewnschten Wrfels
  * @return Referenz auf den Wrfel
  */
  public Wuerfel getWuerfel(int nr) {
    return wuerfel[nr];
  }
  
  /** liefert eine Referenz auf den Spieler der am Zug ist
  * @return Referenz auf den Spieler
  */
  public Spieler getSpielerAmZug() {
    return spieler[amZug];
  }
  public void gewinnFeststellen() {
    if (spieler[0].punkte > spieler[1].punkte) {spieler[0].gewonnen(); spieler[1].verloren();} 
    if (spieler[0].punkte < spieler[1].punkte) {spieler[1].gewonnen(); spieler[0].verloren();} 
    spielBeenden();
    
  }
  
  public void spielBeenden() {
    spieler[0].punkte = 0; spieler[1].punkte = 0;
    spieler[0].wurfNummer = 0; spieler[1].wurfNummer = 0; 
  }
  
  // Ende Methoden
} // end of Dice
